<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Inicio extends CI_Controller {
	
	//Constructor
	function __construct(){
		parent::__construct();

		$this->load->library('publico/inicio_lib');

		$this->form_validation->set_message('required','Debe ingresar un valor para %s');
		$this->form_validation->set_message('loginok','Usuario o Contraseña incorrectos');
		$this->form_validation->set_message('usuario_activo','El usuario esta dado de baja. Contacte con el administrador');
	}
	
	public function index(){
		$this->session->sess_destroy();
		$data['contenido'] = 'publico/inicio/index';
		$this->load->view('publico/template',$data);
	}

	public function ingresar(){
		$this->form_validation->set_rules('txt_user','Usuario','required|callback_loginok|callback_usuario_activo');
		$this->form_validation->set_rules('txt_pass','Contraseña','required');
		if($this->form_validation->run() == FALSE){
			$this->index();
		}
		else{
			redirect('principal/index');
		}
	}

	public function loginok(){
		$usuario = $this->input->post('txt_user');
		$pass = $this->input->post('txt_pass');
		return $this->inicio_lib->login($usuario,md5($pass));
	}

	public function usuario_activo(){
		$usuario = $this->input->post('txt_user');
		return $this->inicio_lib->check_status($usuario);
	}
	
}