<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Principal extends CI_Controller {
	
	//Constructor
	function __construct(){
		parent::__construct();

		$this->load->model("principal/model_personal","mp");

		$this->load->library('principal/Personal_lib');

		$this->load->helper('principal/my_xajax_privilegios');

		$this->form_validation->set_message('required','Debe ingresar un valor para %s');
		$this->form_validation->set_message('matches','%s no coincide con %s');
		$this->form_validation->set_message('cambiook','No se puede realizar el cambio de contraseña');
		$this->form_validation->set_message('norep','Existe otro registro con el mismo %s');
		$this->form_validation->set_message('emailok','Correo inválido');

		/*****Parametros para el correcto funcionamiento de XAJAX*****/
		//mostrar ventana de depuracion
		$this->xajax->configure('debug',FALSE);
		//Registro de funciones XAJAX
        $this->xajax->register(XAJAX_FUNCTION,array('cargar_menu',&$this,'cargar_menu'));
        $this->xajax->register(XAJAX_FUNCTION,array('guardar',&$this,'guardar'));
        $this->xajax->register(XAJAX_FUNCTION,array('ver',&$this,'ver'));
        //Para procesar las peticiones
        $this->xajax->processRequest();
        //mandamos el script a la pagina      
        $this->xajax->configure('javascript URI',base_url());  
        $this->data['xajax_js'] = $this->xajax->getJavascript(base_url());
	}
	
	public function index($param = ''){
		$this->data['contenido'] = 'principal/index';
		/*pantalla principal*/
		//Actividades
		$this->data["actividades"] = $this->mp->v_actividades($this->session->userdata("pk_cat_personal"));
		//Status de venta
		//obtenemos nuestro universo de prospectos
		$universo = $this->mp->ciclos_prospecto($this->session->userdata("pk_cat_personal"));
		//Revisamos si son frios, tibios, calientes o cerrada
		$cerradas = 0;
		//print_r($universo);
		//cerradas
		for ($i=0; $i < count($universo); $i++) { 
			if($universo[$i]["concluido"] == 'SI')
				$cerradas++;
		}
		$this->data["cerradas"] = $cerradas;
		//calientes
		$this->data["calientes"] = $this->mp->calientes($this->session->userdata("pk_cat_personal"));
		//tibios
		$this->data["tibias"] = $this->mp->tibias($this->session->userdata("pk_cat_personal"));
		//frios
		$this->data["frias"] = $this->mp->frias($this->session->userdata("pk_cat_personal"));
		$this->data["tot_prospectos"] = count($universo);
		/********************/
		$this->load->view('template',$this->data);
		if($param == 'ok')
			echo "<script>alert('Actualizacion de Datos Satisfactoria');</script>";
		//elseif($param == 'no')
			//echo "<script>alert('No tienes Permisos para acceder al módulo');</script>";
	}

	public function perfil(){
		$data['contenido'] = 'principal/perfil';
		$data['registro'] = $this->mp->find($this->session->userdata('pk_cat_personal'));
		$this->load->view('template',$data);
	}

	public function update(){
		$pk_cat_personal = $this->input->post('pk_cat_personal');
		$this->form_validation->set_rules('nombre','Nombre','required');
		$this->form_validation->set_rules('apat','Ap. Paterno','required');
		$this->form_validation->set_rules('amat','Ap. Materno','required');
		$this->form_validation->set_rules('correo','Correo','required|callback_emailok|callback_norep[correo]');
		$this->form_validation->set_rules('usuario','Usuario','required|callback_norep[usuario]');
		if($this->form_validation->run() == FALSE){
			$this->perfil();
		}
		else{
			$registro = array(
				"pk_cat_personal" => $pk_cat_personal,
				"nombre" => $this->input->post('nombre'),
				"apat" => $this->input->post('apat'),
				"amat" => $this->input->post('amat'),
				"correo" => $this->input->post('correo'),
				"usuario" => $this->input->post('usuario'));
			$this->mp->update($registro);
			redirect('principal/index/ok');
		}
	}

	public function emailok(){
		return $this->personal_lib->emailok($this->input->post('correo'));
	}

	public function norep($value,$campo){
		return $this->personal_lib->norep($this->input->post(),$campo);
	}

	public function cambio_clave(){//muestra la vista
		$data['contenido'] = 'principal/cambio_clave';
		$this->load->view('template',$data);
	}

	public function cambiar_clave(){//cambia la clave
		$this->form_validation->set_rules('txt_actual_pass','Contraseña Actual','required|callback_cambiook');
		$this->form_validation->set_rules('txt_new_pass','Contraseña Nueva','required|matches[txt_new_pass2]');
		$this->form_validation->set_rules('txt_new_pass2','Repetir Contraseña','required');
		if($this->form_validation->run() == FALSE){
			$this->cambio_clave();
		}
		else{
			redirect('principal/index/ok');
		}
	}

	public function cambiook(){
		$actual_pass = $this->input->post('txt_actual_pass');
		$new_pass = $this->input->post('txt_new_pass');
		return $this->personal_lib->cambiar_pass(md5($actual_pass),md5($new_pass));
	}

	public function privilegios($pk_cat_personal){
		if($pk_cat_personal == md5($this->session->userdata('pk_cat_personal'))){
			$this->data['contenido'] = 'principal/privilegios';
			$this->data['personal'] = $this->mp->cargar_personal();
			$this->load->view('template',$this->data);
		}
		else
			redirect('principal/no');
	}

	public function salir(){
		redirect('');
	}

	/********** METODOS XAJAX **********/

	public function cargar_menu($value){
		$respuesta = new xajaxResponse();
		if($value == 'Seleccione')
			$respuesta->assign('div_mostrar','innerHTML',empty_msg('Selecciona un Personal'));
		else{
			$query = $this->mp->obtener_menu();
			$asg_menu = $this->mp->menus_asignados($value);
			$permisos = $this->mp->permisos($value);
			$respuesta->assign('div_mostrar','innerHTML',mostrar_menu($query,$asg_menu,$permisos));
		}
		return $respuesta;
	}

	public function guardar($form,$existe_registro){
		$respuesta = new xajaxResponse();
		//obtenemos los campos de la tabla privilegios y los comparamos con los checks del formulario. Si no exsiten los check, entonces es 0
		$query = $this->mp->obtener_menu();
		$registro = array();
		foreach($query as $campos){
			if($campos == "pk_privilegios" || $campos == "fk_cat_personal"  || $campos == "status")
				continue;
			elseif(!isset($form["ch_".$campos]))
				$registro[$campos] = 0;
			else
				$registro[$campos] = 1;
		}
		//anexamos el pk_personal
		$registro["fk_cat_personal"] = $form["fk_cat_personal"];
		if(empty($existe_registro))
			$this->mp->insert_privilegios($registro);
		else
			$this->mp->update_privilegios($registro);

		//actualizamos los permisos individuales
		$registro_permisos["editar"] = (isset($form["ch_editar"])) ? 'S' : 'N';
		$registro_permisos["pk_cat_personal"] = $form["fk_cat_personal"];
		$this->mp->update_permisos($registro_permisos);

		$respuesta->alert("Privilegios Actualizados Satisfactoriamente");
		$respuesta->redirect(base_url()."principal/privilegios/".md5($this->session->userdata('pk_cat_personal')));
		return $respuesta;
	}

	public function ver($status,$tipo,$pk){
		$respuesta = new xajaxResponse();
		$com = ($tipo == 'status') ? "fk_cat_status_seguimiento=".$pk : "fk_cat_actividad_status_seguimiento=".$pk;
		$having = ($status == 'pendiente') ? "dif >= 0" : "dif < 0";
		$datos = $this->mp->mostrar_info_act($this->session->userdata("pk_cat_personal"),$com,$having);
		$respuesta->assign("div_modal","innerHTML",mostrar_prospectos($datos));
		$respuesta->script("$(document).ready(function () {
						        mostrarOpcionesTabla('dt_mostrar_prospectos',false,false,true);
						    });");
		return $respuesta;
	}
}