<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Actividad_status extends CI_Controller {
	
	//Constructor
	function __construct(){
		parent::__construct();
		
		$this->load->model('catalogos/Model_actividad_status','mas');

		$this->load->library('catalogos/Actividad_status_lib');

		$this->form_validation->set_message('required','Debe ingresar un valor para %s');
		$this->form_validation->set_message('norep','Existe otro registro con el mismo nombre');
	}
	
	public function index(){
	  	$data['contenido'] = 'catalogos/actividad_status/index';
		$data['query'] = $this->mas->all();
		$this->load->view('template',$data);
	}
	
	public function search(){
		$data['contenido'] = 'catalogos/actividad_status/index';
		$valor = $this->input->post('txt_buscar');
		$data['query'] = $this->mas->all_filtered('descripcion',$valor);
		$this->load->view('template',$data);
	}

	public function create(){
		$data['contenido'] = 'catalogos/actividad_status/create';
		$this->load->view('template',$data);
	}

	public function insert(){
		$registro = $this->input->post();
		$this->form_validation->set_rules('descripcion','Actividad de Status','required|callback_norep');
		if($this->form_validation->run() == FALSE){
			$this->create();
		}
		else{
			$this->mas->insert($registro);
			redirect('catalogos/actividad_status/index');
		}
	}

	public function norep(){
		return $this->actividad_status_lib->norep($this->input->post());
	}

	public function edit($pk_sucursal){
		$data['contenido'] = 'catalogos/actividad_status/edit';
		$data['registro'] = $this->mas->find($pk_sucursal);
		$this->load->view('template',$data);

	}

	public function update(){
		$registro = $this->input->post();
		$this->form_validation->set_rules('descripcion','Tipo de Usuario','required|callback_norep');
		if($this->form_validation->run() == FALSE){
			$this->edit($registro['pk_cat_actividad_status_seguimiento']);
		}
		else{
			$this->mas->update($registro);
			redirect('catalogos/actividad_status/index');
		}
	}

	public function update_status($pk_cat_actividad_status_seguimiento,$status){
		$status = ($status == 'A') ? 'B' : 'A';
		$this->mas->update_status($pk_cat_actividad_status_seguimiento,$status);
		redirect('catalogos/actividad_status/index');
	}
	
}