<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Actividad_tipos extends CI_Controller {
	
	//Constructor
	function __construct(){
		parent::__construct();

		$this->load->helper('catalogos/my_xajax_actividad_tipos');
		$this->load->model('catalogos/Model_actividad_tipos','mat');
		$this->load->library('catalogos/Actividad_tipos_lib');

		$this->form_validation->set_message('alpha_numeric_dash_space','El campo %s acepta únicamente letras, numeros y espacios');
		$this->form_validation->set_message('required','Debe ingresar un valor para %s');
		$this->form_validation->set_message('norep','Ya existe un(a) %s con ese nombre');
		$this->form_validation->set_message('combo_check','Selecciona un %s');

		/*****Parametros para el correcto funcionamiento de XAJAX*****/
		//mostrar ventana de depuracion
		$this->xajax->configure('debug',FALSE);
		//Registro de funciones XAJAX
        $this->xajax->register(XAJAX_FUNCTION,array('seleccion',&$this,'seleccion'));
        $this->xajax->register(XAJAX_FUNCTION,array('mostrar',&$this,'mostrar'));
        $this->xajax->register(XAJAX_FUNCTION,array('cargar_marcas',&$this,'cargar_marcas'));
        //Para procesar las peticiones
        $this->xajax->processRequest();
        //mandamos el script a la pagina      
        $this->xajax->configure('javascript URI',base_url());  
        $this->data['xajax_js'] = $this->xajax->getJavascript(base_url());
        /**************************************************************/

	}

	public function index($value = ""){
		$this->data['contenido'] = 'catalogos/actividad_tipos/index';
		$this->data[$value] = TRUE;
		$this->load->view('template',$this->data);
	}

	public function create_actividad(){
		$data['contenido'] = 'catalogos/actividad_tipos/create_actividad';
		$this->load->view('template',$data);
	}

	public function create_tipo_actividad(){
		$this->data['contenido'] = 'catalogos/actividad_tipos/create_tipo_actividad';
		$this->data['query'] = $this->mat->cargar_actividad();
		$this->load->view('template',$this->data);
	}

	public function insert_actividad(){
		$registro = $this->input->post();
		$this->form_validation->set_rules('descripcion','Actividad','trim|required|alpha_numeric_dash_space|callback_norep[cat_actividad]');
		if($this->form_validation->run() == FALSE)
			$this->create_actividad();
		else{
			$this->mat->insert($registro,'cat_actividad');
			redirect('catalogos/actividad_tipos/index/actividad');
		}
	}

	public function insert_tipo_actividad(){
		$registro = $this->input->post();
		$this->form_validation->set_rules('descripcion','Tipo de Actividad','trim|required|alpha_numeric_dash_space|callback_norep[cat_tipo_actividad]');
		$this->form_validation->set_rules('fk_cat_actividad','Actividad','callback_combo_check[fk_cat_actividad]');
		if($this->form_validation->run() == FALSE)
			$this->create_tipo_actividad();
		else{
			$this->mat->insert(array('descripcion' => $this->input->post('descripcion'),
									 'fk_cat_actividad' => $this->input->post('fk_cat_actividad')),
								'cat_tipo_actividad');
			redirect('catalogos/actividad_tipos/index/tipo_actividad');
		}
	}

	public function edit_actividad($pk_actividad){
		$data['contenido'] = 'catalogos/actividad_tipos/edit_actividad';
		$data['registro'] = $this->mat->find_actividad($pk_actividad);
		$this->load->view('template',$data);
	}

	public function edit_tipo_actividad($pk_tipo_actividad){
		$data['contenido'] = 'catalogos/actividad_tipos/edit_tipo_actividad';
		$data['registro'] = $this->mat->find_tipo_actividad($pk_tipo_actividad);
		$this->load->view('template',$data);
	}

	public function update_actividad(){
		$registro = $this->input->post();
		$this->form_validation->set_rules('descripcion','Actividad','trim|required|alpha_numeric_dash_space|callback_norep[cat_actividad]');
		if ($this->form_validation->run() == FALSE) 
			$this->edit_actividad($registro['pk_cat_actividad']);
		else{
			$this->mat->update($registro,'pk_cat_actividad','cat_actividad');
			redirect('catalogos/actividad_tipos/index/actividad');
		}
	}

	public function update_tipo_actividad(){
		$registro = $this->input->post();
		$this->form_validation->set_rules('descripcion','Tipo de Actividad','trim|required|alpha_numeric_dash_space|callback_norep[cat_tipo_actividad]');
		if ($this->form_validation->run() == FALSE) 
			$this->edit_tipo_actividad($registro['pk_cat_tipo_actividad']);
		else{
			$this->mat->update($registro,'pk_cat_tipo_actividad','cat_tipo_actividad');
			redirect('catalogos/actividad_tipos/index/tipo_actividad');
		}
	}

	public function update_status($pk,$status,$tabla){
		$status = ($status == 'A') ? 'B' : 'A';
		$this->mat->update_status($pk,$status,'pk_cat_'.$tabla,'cat_'.$tabla);
		redirect('catalogos/actividad_tipos/index/'.$tabla);
	}

	public function norep($value,$tabla){
		return $this->actividad_tipos_lib->norep($this->input->post(),$tabla);
	}

	public function combo_check($value,$tabla){
		return $this->actividad_tipos_lib->combo_check($this->input->post(),$tabla);
	}

	/*FUNCIONES XAJAX*/
	public function seleccion($value){
		$respuesta = new xajaxResponse();
	    //OBTENEMOS LOS DATOS DE LA TABLA
	    if($value == 'actividad')
	    	$datos = $this->mat->all_actividad();
	    else
	    	$datos = $this->mat->all_tipo_actividad();
	    $respuesta->Assign('div_mostrar','innerHTML',mostrar_seleccion($value,$datos));
	    $respuesta->script("$(document).ready(function () {
						        mostrarOpcionesTabla('dt_mostrar_seleccion',false,false,true);
						    });");

	    return $respuesta;
    }

    public function mostrar($tabla,$value){
		$respuesta = new xajaxResponse();
		//OBTENEMOS LOS DATOS DE LA TABLA
	    if($tabla == 'actividad')
	    	$datos = $this->mat->all_filtered_actividad($value);
	    else
	    	$datos = $this->mat->all_filtered_tipo_actividad($value);
	    $respuesta->Assign('div_mostrar','innerHTML',mostrar_seleccion($tabla,$datos));
	    $respuesta->script("$('#txt_buscar').focus()");
		return $respuesta;
	}

	public function cargar_marcas($pk_cat_proveedor){
		$respuesta = new xajaxResponse();
		$datos = $this->mat->cargar_marcas($pk_cat_proveedor);
		$respuesta->Assign('div_cmb_marca','innerHTML',mostrar_marcas($datos,$pk_cat_proveedor));
		return $respuesta;
	}
    /*****************/
	
	
}