<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Articulo_tipo extends CI_Controller {
	
	//Constructor
	function __construct(){
		parent::__construct();
		
		$this->load->model('catalogos/Model_articulo_tipo','mat');

		$this->load->library('catalogos/Articulo_tipo_lib');

		$this->form_validation->set_message('required','Debe ingresar un valor para %s');
		$this->form_validation->set_message('norep','Existe otro registro con el mismo nombre');
	}
	
	public function index(){
	  	$data['contenido'] = 'catalogos/articulo_tipo/index';
		$data['query'] = $this->mat->all();
		$this->load->view('template',$data);
	}
	
	public function search(){
		$data['contenido'] = 'catalogos/articulo_tipo/index';
		$valor = $this->input->post('txt_buscar');
		$data['query'] = $this->mat->all_filtered('descripcion',$valor);
		$this->load->view('template',$data);
	}

	public function create(){
		$data['contenido'] = 'catalogos/articulo_tipo/create';
		$this->load->view('template',$data);
	}

	public function insert(){
		$registro = $this->input->post();
		$this->form_validation->set_rules('descripcion','Tipo de Usuario','required|callback_norep');
		if($this->form_validation->run() == FALSE){
			$this->create();
		}
		else{
			$this->mat->insert($registro);
			redirect('catalogos/articulo_tipo/index');
		}
	}

	public function norep(){
		return $this->articulo_tipo_lib->norep($this->input->post());
	}

	public function edit($pk_sucursal){
		$data['contenido'] = 'catalogos/articulo_tipo/edit';
		$data['registro'] = $this->mat->find($pk_sucursal);
		$this->load->view('template',$data);

	}

	public function update(){
		$registro = $this->input->post();
		$this->form_validation->set_rules('descripcion','Tipo de Usuario','required|callback_norep');
		if($this->form_validation->run() == FALSE){
			$this->edit($registro['pk_cat_tipo_usuario']);
		}
		else{
			$this->mat->update($registro);
			redirect('catalogos/articulo_tipo/index');
		}
	}

	public function update_status($pk_departamento,$status){
		$status = ($status == 'A') ? 'B' : 'A';
		$this->mat->update_status($pk_departamento,$status);
		redirect('catalogos/articulo_tipo/index');
	}
	
}