<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cat_planta extends CI_Controller {
	
	//Constructor
	function __construct(){
		parent::__construct();
		
		$this->load->model('catalogos/Model_cat_planta','mat');

		$this->load->library('catalogos/Cat_planta_lib');

		$this->form_validation->set_message('required','Debe ingresar un valor para %s');
		$this->form_validation->set_message('norep','Existe otro registro con el mismo código');
	}
	
	public function index(){
	  	$data['contenido'] = 'catalogos/cat_planta/index';
		$data['query'] = $this->mat->all();
		$this->load->view('template',$data);
	}
	
	public function search(){
		$data['contenido'] = 'catalogos/cat_planta/index';
		$valor = $this->input->post('txt_buscar');
		$data['query'] = $this->mat->all_filtered('descripcion',$valor);
		$this->load->view('template',$data);
	}

	public function create(){
		$data['contenido'] = 'catalogos/cat_planta/create';
		$this->load->view('template',$data);
	}

	public function insert(){
		$registro = $this->input->post();
		$this->form_validation->set_rules('codigo','Código','required|callback_norep');
		$this->form_validation->set_rules('descripcion','Descripción','required');
		if($this->form_validation->run() == FALSE){
			$this->create();
		}
		else{
			$this->mat->insert($registro);
			redirect('catalogos/cat_planta/index');
		}
	}

	public function norep(){
		return $this->cat_planta_lib->norep($this->input->post());
	}

	public function edit($pk_sucursal){
		$data['contenido'] = 'catalogos/cat_planta/edit';
		$data['registro'] = $this->mat->find($pk_sucursal);
		$this->load->view('template',$data);

	}

	public function update(){
		$registro = $this->input->post();
		$this->form_validation->set_rules('codigo','Código','required|callback_norep');
		$this->form_validation->set_rules('descripcion','Descripción','required');
		if($this->form_validation->run() == FALSE){
			$this->edit($registro['pk_cat_planta']);
		}
		else{
			$this->mat->update($registro);
			redirect('catalogos/cat_planta/index');
		}
	}

	public function update_status($pk_departamento,$status){
		$status = ($status == 'A') ? 'B' : 'A';
		$this->mat->update_status($pk_departamento,$status);
		redirect('catalogos/cat_planta/index');
	}
	
}