<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Metas extends CI_Controller {
	
	//Constructor
	function __construct(){
		parent::__construct();

		$this->load->helper('catalogos/my_xajax_metas');
		$this->load->model('catalogos/Model_metas','mm');
		$this->load->library('catalogos/Metas_lib');

		/*****Parametros para el correcto funcionamiento de XAJAX*****/
		//mostrar ventana de depuracion
		$this->xajax->configure('debug',FALSE);
		//Registro de funciones XAJAX
        $this->xajax->register(XAJAX_FUNCTION,array('insert_meta',&$this,'insert_meta'));
        $this->xajax->register(XAJAX_FUNCTION,array('asignar_meta',&$this,'asignar_meta'));
        $this->xajax->register(XAJAX_FUNCTION,array('insert_asignar_meta',&$this,'insert_asignar_meta'));
        $this->xajax->register(XAJAX_FUNCTION,array('update_status',&$this,'update_status'));
        $this->xajax->register(XAJAX_FUNCTION,array('update_meta',&$this,'update_meta'));
        //Para procesar las peticiones
        $this->xajax->processRequest();
        //mandamos el script a la pagina      
        $this->xajax->configure('javascript URI',base_url());  
        $this->data['xajax_js'] = $this->xajax->getJavascript(base_url());
        /**************************************************************/

	}

	public function index(){
		$this->data['contenido'] = 'catalogos/metas/index';
		$this->data['seguimiento'] = $this->mm->cargar_status();
		$this->data['tipo_articulo'] = $this->mm->cargar_tipo_articulo();
		$this->data['metas'] = $this->mm->cargar_metas();
		$this->data['metas_asignadas'] = $this->mm->obtener_metas();
		$this->load->view('template',$this->data);
	}

	/*FUNCIONES XAJAX*/
    public function insert_meta($form){
		$respuesta = new xajaxResponse();
		//Validamos si todo esta llenado
		//print_r($form);
		$error_msg = "";
		if(!isset($form["tipo"]))
			$error_msg = "Selecciona Individual o Grupal";
		elseif($form["fk_cat_status_seguimiento"] == "Seleccione")
			$error_msg = "Selecciona un Status";
		elseif($form["fk_cat_tipo_articulo"] == "Seleccione")
			$error_msg = "Selecciona un Tipo de Artículo";
		elseif($this->metas_lib->norep($form))
			$error_msg = "La combinación seleccionada ya existe. No es necesario darla de alta";
		if(!empty($error_msg))
			$respuesta->assign('div_msj','innerHTML',empty_msg($error_msg));
		else{
			$registro = array(
				"tipo" => $form["tipo"],
				"fk_cat_status_seguimiento" => $form["fk_cat_status_seguimiento"],
				"fk_cat_tipo_articulo" => $form["fk_cat_tipo_articulo"]
			);
			$this->mm->insert($registro,"cat_metas");
			$respuesta->alert("Meta Creada Satisfactoriamente");
			$respuesta->redirect(base_url().'catalogos/metas');
		}
		return $respuesta;
	}

	public function asignar_meta($pk_cat_metas){
		$respuesta = new xajaxResponse();
		if($pk_cat_metas == 'Seleccione')
			$respuesta->assign("div_meta","innerHTML",empty_msg("Selecciona una meta"));
		else{
			//obtenemos las caracteristicas de la meta seleccionada
			$meta = $this->mm->find_meta($pk_cat_metas);
			//dependiendo del tipo, obtenemos todo el personal(I) o todas las sucursales(G)
			$a_asignar = $this->mm->obtener_asigados($meta->tipo);
			$respuesta->assign("div_meta","innerHTML",mostrar_asignar_meta($meta,$a_asignar,$pk_cat_metas));
			$respuesta->script("$(function () {
						            $('.chosen-select').chosen({width: '100%'});
						        });");
		}
		return $respuesta;
	}

	public function insert_asignar_meta($form,$label){
		$respuesta = new xajaxResponse();
		//Validamos si todo esta llenado
		//print_r($form);
		$cantidad = trim($form["cantidad"]);
		$error_msg = "";
		if($form["fk"] == "Seleccione")
			$error_msg = "Selecciona ".$label;
		elseif($form["mes"] == "Seleccione")
			$error_msg = "Selecciona Mes";
		elseif($form["anio"] == "Seleccione")
			$error_msg = "Selecciona Año";
		elseif(!isset($form["meta_por"]))
			$error_msg = "Selecciona meta por cantidad o por monto";
		elseif(empty($cantidad))
			$error_msg = "Cantidad no puede ir vacio o llevar 0";
		//elseif($this->metas_lib->norep($form))
			//$error_msg = "La combinación seleccionada ya existe. No es necesario darla de alta";
		if(!empty($error_msg))
			$respuesta->assign('div_msj_asignar','innerHTML',empty_msg($error_msg));
		else{
			//si es personal, insertamos normalmente una fila en la tabla union_personal_metas
			if($label == 'Personal'){
				$registro = array(
					"mes" => $form["mes"],
					"anio" => $form["anio"],
					"cantidad" => $cantidad,
					"fk_cat_personal" => $form["fk"],
					"fk_cat_metas" => $form["fk_cat_metas"],
					"meta_por" => $form["meta_por"]
				);
				$this->mm->insert($registro,"union_personal_metas");
			}
			//si es Sucursal, buscamos todos los empleados dependientes de esa sucursal para insertarlos en la meta
			//22-01-2016 Actualizacion
			//Vamos a guardar únicamente la sucursal, YA NO A TODOS LOS EMPLEADOS
			else{
				/*$empleados = $this->mm->obtener_empleados_sucursal($form["fk"]);
				foreach ($empleados as $value) {
					$registro = array(
						"mes" => $form["mes"],
						"anio" => $form["anio"],
						"cantidad" => $cantidad,
						"fk_cat_personal" => $value->pk_cat_personal,
						"fk_cat_metas" => $form["fk_cat_metas"]
					);
					$this->mm->insert($registro,"union_personal_metas");
				}*/
				$registro = array(
					"mes" => $form["mes"],
					"anio" => $form["anio"],
					"cantidad" => $cantidad,
					"fk_cat_metas" => $form["fk_cat_metas"],
					"fk_cat_sucursal" => $form["fk"],
					"meta_por" => $form["meta_por"]
				);
				$this->mm->insert($registro,"union_personal_metas");
			}
			//print_r($registro);
			$respuesta->alert("Meta Asignada Satisfactoriamente");
			$respuesta->redirect(base_url().'catalogos/metas');
		}
		return $respuesta;
	}

	public function update_status($pk_u,$status){
		$respuesta = new xajaxResponse();
		$status = ($status == 'A') ? 'B' : 'A';
		$this->mm->update_status($pk_u,$status);
		$respuesta->alert("Status Actualizado Satisfactoriamente");
		$respuesta->redirect(base_url().'catalogos/metas');
		return $respuesta;
	}

	public function update_meta($cantidad,$pk_u){
		$respuesta = new xajaxResponse();
		if(empty($cantidad))
			$respuesta->alert("Cantidad No puede llevar cero o vacio");
		else{
			$this->mm->update_meta($cantidad,$pk_u);
			$respuesta->alert("Cantidad Actualizado Satisfactoriamente");
		}
		return $respuesta;
	}

    /*****************/
}