<?php if ( ! defined('BASEPATH')) exit('No esta permitido el acceso directo');//impide el acceso directo a este script

class Plantillas_servicio extends CI_Controller {

	//Constructor
	function __construct(){
		parent::__construct();

		$this->load->model('catalogos/model_plantillas_servicio','mps');
		$this->load->helper('catalogos/my_xajax_plantillas_servicio');
		$this->load->library('catalogos/Plantillas_servicio_lib');

		/*****Parametros para el correcto funcionamiento de XAJAX*****/
		//mostrar ventana de depuracion
		$this->xajax->configure('debug',FALSE);
		//Registro de funciones XAJAX
        $this->xajax->register(XAJAX_FUNCTION,array('seleccion',&$this,'seleccion'));
		$this->xajax->register(XAJAX_FUNCTION,array('add_ra',&$this,'add_ra'));
		$this->xajax->register(XAJAX_FUNCTION,array('add_sa',&$this,'add_sa'));
        $this->xajax->register(XAJAX_FUNCTION,array('guardar',&$this,'guardar'));
		$this->xajax->register(XAJAX_FUNCTION,array('cargar_unidades',&$this,'cargar_unidades'));
        $this->xajax->register(XAJAX_FUNCTION,array('plantilla',&$this,'plantilla'));
        $this->xajax->register(XAJAX_FUNCTION,array('update_status',&$this,'update_status'));
        //Para procesar las peticiones
        $this->xajax->processRequest();
        //mandamos el script a la pagina
        $this->xajax->configure('javascript URI',base_url());
        $this->data['xajax_js'] = $this->xajax->getJavascript(base_url());
        /**************************************************************/
	}

	public function index(){
		$this->data['contenido'] = 'catalogos/plantillas_servicio/index';
		$this->load->view('template',$this->data);
	}

	/********** METODOS XAJAX **********/

	public function seleccion ($value){
		$respuesta = new xajaxResponse();
		if($value == 'nuevo'){
			$datos['inventRefaccion'] = $this->mps->inventRefaccion();
			$datos['cat_planta'] = $this->mps->cat_planta();
			$datos['v_unidades'] = $this->mps->v_unidades();
			$respuesta->Assign('div_mostrar','innerHTML',nuevo($datos));
		}
		else{
			$datos = $this->mps->servicio();
			$respuesta->Assign('div_mostrar','innerHTML',buscar($datos));
		}
		$respuesta->script("$(function () {
							    $('.chosen-select').chosen({width: '100%'});
							});");
		return $respuesta;
	}

	public function add_ra($num){
    	$respuesta = new xajaxResponse();
		$datos['inventRefaccion'] = $this->mps->inventRefaccion();
		$respuesta->assign("div_ra".($num-1),"innerHTML",mostrar_add_ra($num,$datos));
		$respuesta->script("$('#h_num_ra').val('".$num."')");
		$respuesta->script("$(function () {
							    $('.chosen-select').chosen({width: '100%'});
							});");
    	return $respuesta;
    }

	public function add_sa($num){
    	$respuesta = new xajaxResponse();
		$datos['cat_planta'] = $this->mps->cat_planta();
		$respuesta->assign("div_sa".($num-1),"innerHTML",mostrar_add_sa($num,$datos));
		$respuesta->script("$('#h_num_sa').val('".$num."')");
		$respuesta->script("$(function () {
							    $('.chosen-select').chosen({width: '100%'});
							});");
    	return $respuesta;
    }

	public function guardar($form){
		$respuesta = new xajaxResponse();
		$respuesta->script("$('#btn_guardar').attr('disabled',true);");
		//print_r($form);
		$msj = "";
		if(empty($form["h_num_sa"]))
			$msj = "Es neceario seleccionar, al menos, un servicio";
		elseif(empty($msj)){//CONTINUAMOS CON SERVICIOS ADICIONALES
			for($i = 1; $i <= $form["h_num_sa"]; $i++){
				if(empty($form["fk_cat_planta".$i])){
					$msj = "Es necesario seleccionar un SERVICIO";
					break;
				}
				elseif(empty(trim($form["horas_sa".$i]))){
					$msj = "HORAS, en el apartado de SERVICIOS, no puede ir vacío o llevar 0";
					break;
				}
			}
		}
		if(empty($msj)){
			if($form["h_num_ra"] != 0){
				for($i = 1; $i <= $form["h_num_ra"]; $i++){
					if(empty($form["refaccionId".$i])){
						$msj = "Es necesario seleccionar una REFACCIÓN";
						break;
					}
					elseif(empty(trim($form["capacidad".$i]))){
						$msj = "CAPACIDAD (LITROS), en el apartado de REFACCIONES, no puede ir vacío o llevar 0";
						break;
					}
					elseif(empty(trim($form["tipo_fluido".$i]))){
						$msj = "TIPO DE FLUIDO, en el apartado de REFACCIONES, no puede ir vacío o llevar 0";
						break;
					}
					elseif(empty(trim($form["cantidad".$i]))){
						$msj = "QT (CANTIDAD), en el apartado de REFACCIONES, no puede ir vacío o llevar 0";
						break;
					}
					elseif(empty(trim($form["horas_ra".$i]))){
						$msj = "HORAS, en el apartado de REFACCIONES, no puede ir vacío o llevar 0";
						break;
					}
				}
			}
		}
		if(empty($msj)){
			if(empty($form["fk_cat_modelo"]))
				$msj = "Es neceario seleccionar, al menos, una UNIDAD";
		}
		if(empty($msj)){
			if(empty(trim($form["descripcion"])))
				$msj = "Es neceario escribir el NOMBRE DE LA PLANTILLA";
		}
		if(!empty($msj)){
			$respuesta->assign('div_msj','innerHTML',empty_msg($msj));
			$respuesta->script("$('#btn_guardar').attr('disabled',false);");
		}
		else{
			//insetamos servicio
			$pk = $this->mps->insert_servicio(array("descripcion" => trim($form["descripcion"])));
			//creamos un foreach para insertar det_servicio
			foreach ($form["fk_cat_modelo"] as $value){
				for($i = 1; $i <= $form["h_num_sa"]; $i++){//Servicios
					foreach ($form["fk_cat_planta".$i] as $servicio){
						$servicio = explode("|",$servicio);
						$datos = array(
							"codigo" => $servicio[0],
							"descripcion_trabajo" => $servicio[1],
							"numero_parte" => "-",
							"descripcion_parte" => "-",
							"capacidad" => "-",
							"tipo_fluido" => "-",
							"cantidad" => "-",
							"horas" => trim($form["horas_sa".$i]),
							"fk_cat_modelo" => $value,
							"fk_servicio" => $pk
						);
						$this->mps->insert($datos);
						/* //validamos si ya existe la relacion. Si existe, la guarda, sino, no
						if($this->plantillas_servicio_lib->norep($pk,$datos["fk_cat_diseno"],$datos["fk_cat_diseno_pro"]))
							$this->mps->insert($datos); */
					}
				}
				for($i = 1; $i <= $form["h_num_ra"]; $i++){//Refacciones
					foreach ($form["refaccionId".$i] as $refaccion){
						$refaccion = explode("|",$refaccion);
						$datos = array(
							"codigo" => $refaccion[0],
							"descripcion_trabajo" => $refaccion[1],
							"numero_parte" => $refaccion[2],
							"descripcion_parte" => $refaccion[3],
							"capacidad" => trim($form["capacidad".$i]),
							"tipo_fluido" => trim($form["tipo_fluido".$i]),
							"cantidad" => trim($form["cantidad".$i]),
							"horas" => trim($form["horas_ra".$i]),
							"fk_cat_modelo" => $value,
							"fk_servicio" => $pk
						);
						$this->mps->insert($datos);
						/* //validamos si ya existe la relacion. Si existe, la guarda, sino, no
						if($this->plantillas_servicio_lib->norep($pk,$datos["fk_cat_diseno"],$datos["fk_cat_diseno_pro"]))
							$this->mps->insert($datos); */
					}
				}
			}
			$respuesta->alert("Plantilla Guardada Satisfactoriamente");
			$respuesta->redirect("");
		}
		return $respuesta;
	}

	public function cargar_unidades($pk_servicio){
		$respuesta = new xajaxResponse();
		//$respuesta->alert($pk_servicio);
		if($pk_servicio == 'Seleccione'){
			$respuesta->assign('div_cmb_unidades','innerHTML',empty_msg('Selecciona una plantilla de servicio'));
			$respuesta->assign('div_buscar','innerHTML','');
		}
		else{
			$datos = $this->mps->unidades_plantilla($pk_servicio);
			$respuesta->Assign('div_cmb_unidades','innerHTML',mostrar_unidades($datos,$pk_servicio));
			$respuesta->script("$(function () {
									$('.chosen-select').chosen({width: '100%'});
								});");
		}
		return $respuesta;
	}

	public function plantilla($pk_cat_modelo,$pk_servicio){
		$respuesta = new xajaxResponse();
		if($pk_cat_modelo == 'Seleccione')
			$respuesta->assign('div_buscar','innerHTML',empty_msg('Selecciona una unidad'));
		else{
			$datos = $this->mps->detalle_unidad_plantilla($pk_cat_modelo,$pk_servicio);
			$respuesta->Assign('div_buscar','innerHTML',mostrar_busqueda($datos,$pk_cat_modelo,$pk_servicio));
			$respuesta->script("mostrarOpcionesTabla('dt_plantillas_servicio',false,false,true);");
		}
		return $respuesta;
	}

	public function update_status($pk_det_servicio,$status,$pk_cat_modelo,$pk_servicio){
		$respuesta = new xajaxResponse();
		$this->mps->update_status($pk_det_servicio,$status);
		$respuesta->alert("Status Actualizado Satisfactoriamente");
		$respuesta->call("xajax_plantilla('".$pk_cat_modelo."','".$pk_servicio."')");
		return $respuesta;
	}

	/***********************************/

}