<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class plazo_pago extends CI_Controller {
	
	//Constructor
	function __construct(){
		parent::__construct();
		
		$this->load->model('catalogos/Model_plazo_pago','mpc');

		$this->load->library('catalogos/Plazo_pago_lib');

		$this->form_validation->set_message('required','Debe ingresar un valor para %s');
		$this->form_validation->set_message('norep','Existe otro registro con el mismo nombre');
	}
	
	public function index(){
	  $data['contenido'] = 'catalogos/plazo_pago/index';
		$data['query'] = $this->mpc->all();
		$this->load->view('template',$data);
	}
	
	public function search(){
		$data['contenido'] = 'catalogos/plazo_pago/index';
		$valor = $this->input->post('txt_buscar');
		$data['query'] = $this->mpc->all_filtered('descripcion',$valor);
		$this->load->view('template',$data);
	}

	public function create(){
		$data['contenido'] = 'catalogos/plazo_pago/create';
		$this->load->view('template',$data);
	}

	public function insert(){
		$registro = $this->input->post();
		$this->form_validation->set_rules('descripcion','Plazo requerido para pago','required|callback_norep');
		if($this->form_validation->run() == FALSE){
			$this->create();
		}
		else{
			$this->mpc->insert($registro);
			redirect('catalogos/plazo_pago/index');
		}
	}

	public function norep(){
		return $this->plazo_pago_lib->norep($this->input->post());
	}

	public function edit($pk_sucursal){
		$data['contenido'] = 'catalogos/plazo_pago/edit';
		$data['registro'] = $this->mpc->find($pk_sucursal);
		$this->load->view('template',$data);

	}

	public function update(){
		$registro = $this->input->post();
		$this->form_validation->set_rules('descripcion','Plazo requerido para Pago','required|callback_norep');
		if($this->form_validation->run() == FALSE){
			$this->edit($registro['pk_cat_plazo_pago']);
		}
		else{
			$this->mpc->update($registro);
			redirect('catalogos/plazo_pago/index');
		}
	}

	public function update_status($pk_departamento,$status){
		$status = ($status == 'A') ? 'B' : 'A';
		$this->mpc->update_status($pk_departamento,$status);
		redirect('catalogos/plazo_pago/index');
	}
	
}