<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class probabilidad_compra extends CI_Controller {
	
	//Constructor
	function __construct(){
		parent::__construct();
		
		$this->load->model('catalogos/Model_probabilidad_compra','mpc');

		$this->load->library('catalogos/Probabilidad_compra_lib');

		$this->form_validation->set_message('required','Debe ingresar un valor para %s');
		$this->form_validation->set_message('norep','Existe otro registro con el mismo nombre');
	}
	
	public function index(){
	  $data['contenido'] = 'catalogos/probabilidad_compra/index';
		$data['query'] = $this->mpc->all();
		$this->load->view('template',$data);
	}
	
	public function search(){
		$data['contenido'] = 'catalogos/probabilidad_compra/index';
		$valor = $this->input->post('txt_buscar');
		$data['query'] = $this->mpc->all_filtered('descripcion',$valor);
		$this->load->view('template',$data);
	}

	public function create(){
		$data['contenido'] = 'catalogos/probabilidad_compra/create';
		$this->load->view('template',$data);
	}

	public function insert(){
		$registro = $this->input->post();
		$this->form_validation->set_rules('descripcion','Probabilidad de comprao','required|callback_norep');
		if($this->form_validation->run() == FALSE){
			$this->create();
		}
		else{
			$this->mpc->insert($registro);
			redirect('catalogos/probabilidad_compra/index');
		}
	}

	public function norep(){
		return $this->probabilidad_compra_lib->norep($this->input->post());
	}

	public function edit($pk_sucursal){
		$data['contenido'] = 'catalogos/probabilidad_compra/edit';
		$data['registro'] = $this->mpc->find($pk_sucursal);
		$this->load->view('template',$data);

	}

	public function update(){
		$registro = $this->input->post();
		$this->form_validation->set_rules('descripcion','Probabilidad de Compra','required|callback_norep');
		if($this->form_validation->run() == FALSE){
			$this->edit($registro['pk_cat_probabilidad_compra']);
		}
		else{
			$this->mpc->update($registro);
			redirect('catalogos/probabilidad_compra/index');
		}
	}

	public function update_status($pk_departamento,$status){
		$status = ($status == 'A') ? 'B' : 'A';
		$this->mpc->update_status($pk_departamento,$status);
		redirect('catalogos/probabilidad_compra/index');
	}
	
}