<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Status extends CI_Controller {
	
	//Constructor
	function __construct(){
		parent::__construct();
		
		$this->load->model('catalogos/Model_status','ms');

		$this->load->library('catalogos/Status_lib');

		$this->form_validation->set_message('required','Debe ingresar un valor para %s');
		$this->form_validation->set_message('norep','Existe otro registro con el mismo nombre');
	}
	
	public function index(){
	  	$data['contenido'] = 'catalogos/status/index';
		$data['query'] = $this->ms->all();
		$this->load->view('template',$data);
	}
	
	public function search(){
		$data['contenido'] = 'catalogos/status/index';
		$valor = $this->input->post('txt_buscar');
		$data['query'] = $this->ms->all_filtered('descripcion',$valor);
		$this->load->view('template',$data);
	}

	public function create(){
		$data['contenido'] = 'catalogos/status/create';
		$this->load->view('template',$data);
	}

	public function insert(){
		$registro = $this->input->post();
		$this->form_validation->set_rules('descripcion','Status','required|callback_norep');
		if($this->form_validation->run() == FALSE){
			$this->create();
		}
		else{
			$this->ms->insert($registro);
			redirect('catalogos/status/index');
		}
	}

	public function norep(){
		return $this->status_lib->norep($this->input->post());
	}

	public function edit($pk_sucursal){
		$data['contenido'] = 'catalogos/status/edit';
		$data['registro'] = $this->ms->find($pk_sucursal);
		$this->load->view('template',$data);

	}

	public function update(){
		$registro = $this->input->post();
		$this->form_validation->set_rules('descripcion','Status','required|callback_norep');
		if($this->form_validation->run() == FALSE){
			$this->edit($registro['pk_cat_tipo_usuario']);
		}
		else{
			$this->ms->update($registro);
			redirect('catalogos/status/index');
		}
	}

	public function update_status($pk_departamento,$status){
		$status = ($status == 'A') ? 'B' : 'A';
		$this->ms->update_status($pk_departamento,$status);
		redirect('catalogos/status/index');
	}
	
}