<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Tipo_rechazo extends CI_Controller {
	
	//Constructor
	function __construct(){
		parent::__construct();
		
		$this->load->model('catalogos/Model_tipo_rechazo','mtr');

		$this->load->library('catalogos/Tipo_rechazo_lib');

		$this->form_validation->set_message('required','Debe ingresar un valor para %s');
		$this->form_validation->set_message('norep','Existe otro registro con el mismo nombre');
	}
	
	public function index(){
	  	$data['contenido'] = 'catalogos/tipo_rechazo/index';
		$data['query'] = $this->mtr->all();
		$this->load->view('template',$data);
	}
	
	public function search(){
		$data['contenido'] = 'catalogos/tipo_rechazo/index';
		$valor = $this->input->post('txt_buscar');
		$data['query'] = $this->mtr->all_filtered('descripcion',$valor);
		$this->load->view('template',$data);
	}

	public function create(){
		$data['contenido'] = 'catalogos/tipo_rechazo/create';
		$this->load->view('template',$data);
	}

	public function insert(){
		$registro = $this->input->post();
		$this->form_validation->set_rules('descripcion','Tipo de Usuario','required|callback_norep');
		if($this->form_validation->run() == FALSE){
			$this->create();
		}
		else{
			$this->mtr->insert($registro);
			redirect('catalogos/tipo_rechazo/index');
		}
	}

	public function norep(){
		return $this->tipo_rechazo_lib->norep($this->input->post());
	}

	public function edit($pk_sucursal){
		$data['contenido'] = 'catalogos/tipo_rechazo/edit';
		$data['registro'] = $this->mtr->find($pk_sucursal);
		$this->load->view('template',$data);

	}

	public function update(){
		$registro = $this->input->post();
		$this->form_validation->set_rules('descripcion','Tipo de Usuario','required|callback_norep');
		if($this->form_validation->run() == FALSE){
			$this->edit($registro['pk_cat_tipo_usuario']);
		}
		else{
			$this->mtr->update($registro);
			redirect('catalogos/tipo_rechazo/index');
		}
	}

	public function update_status($pk_cat_rechazo,$status){
		$status = ($status == 'A') ? 'B' : 'A';
		$this->mtr->update_status($pk_cat_rechazo,$status);
		redirect('catalogos/tipo_rechazo/index');
	}
	
}