<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Tipo_usuarios extends CI_Controller {
	
	//Constructor
	function __construct(){
		parent::__construct();
		
		$this->load->model('catalogos/Model_tipo_usuarios','mtu');

		$this->load->library('catalogos/Tipo_usuarios_lib');

		$this->form_validation->set_message('required','Debe ingresar un valor para %s');
		$this->form_validation->set_message('norep','Existe otro registro con el mismo nombre');
	}
	
	public function index(){
	  	$data['contenido'] = 'catalogos/tipo_usuarios/index';
		$data['query'] = $this->mtu->all();
		$this->load->view('template',$data);
	}
	
	public function search(){
		$data['contenido'] = 'catalogos/tipo_usuarios/index';
		$valor = $this->input->post('txt_buscar');
		$data['query'] = $this->mtu->all_filtered('descripcion',$valor);
		$this->load->view('template',$data);
	}

	public function create(){
		$data['contenido'] = 'catalogos/tipo_usuarios/create';
		$this->load->view('template',$data);
	}

	public function insert(){
		$registro = $this->input->post();
		$this->form_validation->set_rules('descripcion','Tipo de Usuario','required|callback_norep');
		if($this->form_validation->run() == FALSE){
			$this->create();
		}
		else{
			$this->mtu->insert($registro);
			redirect('catalogos/tipo_usuarios/index');
		}
	}

	public function norep(){
		return $this->tipo_usuarios_lib->norep($this->input->post());
	}

	public function edit($pk_sucursal){
		$data['contenido'] = 'catalogos/tipo_usuarios/edit';
		$data['registro'] = $this->mtu->find($pk_sucursal);
		$this->load->view('template',$data);

	}

	public function update(){
		$registro = $this->input->post();
		$this->form_validation->set_rules('descripcion','Tipo de Usuario','required|callback_norep');
		if($this->form_validation->run() == FALSE){
			$this->edit($registro['pk_cat_tipo_usuario']);
		}
		else{
			$this->mtu->update($registro);
			redirect('catalogos/tipo_usuarios/index');
		}
	}

	public function update_status($pk_departamento,$status){
		$status = ($status == 'A') ? 'B' : 'A';
		$this->mtu->update_status($pk_departamento,$status);
		redirect('catalogos/tipo_usuarios/index');
	}
	
}