<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Tipos_anexo extends CI_Controller {
	
	//Constructor
	function __construct(){
		parent::__construct();
		
		$this->load->model('catalogos/Model_tipos_anexo','mta');

		$this->load->library('catalogos/Tipos_anexo_lib');

		$this->form_validation->set_message('required','Debe ingresar un valor para %s');
		$this->form_validation->set_message('norep','Existe otro registro con el mismo nombre');
		$this->form_validation->set_message('numeric','El campo %s solo acepta números');
	}
	
	public function index(){
	  	$data['contenido'] = 'catalogos/tipos_anexo/index';
		$data['query'] = $this->mta->all();
		$this->load->view('template',$data);
	}
	
	public function search(){
		$data['contenido'] = 'catalogos/tipos_anexo/index';
		$valor = $this->input->post('txt_buscar');
		$data['query'] = $this->mta->all_filtered('descripcion',$valor);
		$this->load->view('template',$data);
	}

	public function create(){
		$data['contenido'] = 'catalogos/tipos_anexo/create';
		$this->load->view('template',$data);
	}

	public function insert(){
		$registro = $this->input->post();
		$this->form_validation->set_rules('descripcion','Status','required|callback_norep');
		$this->form_validation->set_rules('cantidad','Cantidad','required|numeric');
		if($this->form_validation->run() == FALSE){
			$this->create();
		}
		else{
			$this->mta->insert($registro);
			redirect('catalogos/tipos_anexo/index');
		}
	}

	public function norep(){
		return $this->tipos_anexo_lib->norep($this->input->post());
	}

	public function edit($pk_cat_anexos){
		$data['contenido'] = 'catalogos/tipos_anexo/edit';
		$data['registro'] = $this->mta->find($pk_cat_anexos);
		$this->load->view('template',$data);

	}

	public function update(){
		$registro = $this->input->post();
		$this->form_validation->set_rules('descripcion','Status','required|callback_norep');
		$this->form_validation->set_rules('cantidad','Cantidad','required');
		if($this->form_validation->run() == FALSE){
			$this->edit($registro['pk_cat_tipo_usuario']);
		}
		else{
			$this->mta->update($registro);
			redirect('catalogos/tipos_anexo/index');
		}
	}

	public function update_status($pk_cat_anexos,$status){
		$status = ($status == 'A') ? 'B' : 'A';
		$this->mta->update_status($pk_cat_anexos,$status);
		redirect('catalogos/tipos_anexo/index');
	}
	
}