<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Unidades extends CI_Controller {
	
	//Constructor
	function __construct(){
		parent::__construct();
		
		$this->load->helper('catalogos/my_xajax_unidades_helper');
		$this->load->model('catalogos/Model_unidades','mu');
		$this->load->library('catalogos/Unidades_lib');

		/*****Parametros para el correcto funcionamiento de XAJAX*****/
		//mostrar ventana de depuracion
		$this->xajax->configure('debug',FALSE);
		//Registro de funciones XAJAX
        $this->xajax->register(XAJAX_FUNCTION,array('show_div2',&$this,'show_div2'));
        $this->xajax->register(XAJAX_FUNCTION,array('show_div3',&$this,'show_div3'));
        $this->xajax->register(XAJAX_FUNCTION,array('show_div4',&$this,'show_div4'));
        $this->xajax->register(XAJAX_FUNCTION,array('modelos',&$this,'modelos'));
        $this->xajax->register(XAJAX_FUNCTION,array('crear',&$this,'crear'));
        $this->xajax->register(XAJAX_FUNCTION,array('editar',&$this,'editar'));
        $this->xajax->register(XAJAX_FUNCTION,array('update_status',&$this,'update_status'));
        $this->xajax->register(XAJAX_FUNCTION,array('update',&$this,'update'));
        $this->xajax->register(XAJAX_FUNCTION,array('update_status_modelo',&$this,'update_status_modelo'));
        $this->xajax->register(XAJAX_FUNCTION,array('update_modelo',&$this,'update_modelo'));
        //Para procesar las peticiones
        $this->xajax->processRequest();
        //mandamos el script a la pagina      
        $this->xajax->configure('javascript URI',base_url());  
        $this->data['xajax_js'] = $this->xajax->getJavascript(base_url());
        /**************************************************************/
	}
	
	public function index(){
	  	$this->data['contenido'] = 'catalogos/unidades/index';
		$this->data['articulos'] = $this->mu->get_cat_tipo_articulo();
		$this->load->view('template',$this->data);
	}
	
	/*FUNCIONES XAJAX*/
	public function show_div2($value,$articulo,$filtro = ""){
		$respuesta = new xajaxResponse();
		//$respuesta->alert($value.",".$texto);
		$respuesta->clear('div_modelos','innerHTML');
		if($value == 'Seleccione'){
			$respuesta->Assign('div2','innerHTML',empty_msg('Selecciona un Artículo'));
			$respuesta->clear('div_crear','innerHTML');
		}
		else{
			//filtro para ir mostrando los modelos
			$filtro = "pk_cat_tipo_articulo=".$value;
		    $datos = $this->mu->get_gpo_catalogo($value);
		    $respuesta->Assign('div2','innerHTML',mostrar_cmb($datos,'gpo_catalogo',$articulo,$filtro));
		    $respuesta->Assign('div_crear','innerHTML',crear_registro($value,'gpo_catalogo',$filtro));
		    //mostrar los modelos según la selección
		    $respuesta->Assign("div_modelos","innerHTML",mostrar_modelo($this->mu->v_unidades($filtro),$value,$articulo,$filtro,'show_div2'));
		    $respuesta->script("$(function () {
						            $('.chosen-select').chosen({width: '100%'});
						        });");
		}
	    return $respuesta;
    }

    public function show_div3($value,$articulo,$filtro){
		$respuesta = new xajaxResponse();
		$respuesta->clear('div_modelos','innerHTML');
		if($value == 'Seleccione'){
			$respuesta->Assign('div3','innerHTML',empty_msg('Selecciona un Grupo Catálogo'));
			$respuesta->clear('div_crear','innerHTML');
		}
		else{
			//filtro para ir mostrando los modelos
			$filtro.= " and pk_gpo_catalogo=".$value;
		    $datos = $this->mu->get_subgpo_catalogo($value);
		    $respuesta->Assign('div3','innerHTML',mostrar_cmb($datos,'subgpo_catalogo',$articulo,$filtro));
		    $respuesta->Assign('div_crear','innerHTML',crear_registro($value,'subgpo_catalogo',$filtro));
		    //mostrar los modelos según la selección
		    $respuesta->Assign("div_modelos","innerHTML",mostrar_modelo($this->mu->v_unidades($filtro),$value,$articulo,$filtro,'show_div3'));
		    $respuesta->script("$(function () {
						            $('.chosen-select').chosen({width: '100%'});
						        });");
		}
	    return $respuesta;
    }

    public function show_div4($value,$articulo,$filtro){
		$respuesta = new xajaxResponse();
		$respuesta->clear('div_modelos','innerHTML');
		if($value == 'Seleccione'){
			$respuesta->Assign('div4','innerHTML',empty_msg('Selecciona un Subgrupo de Catálogo'));
			$respuesta->clear('div_crear','innerHTML');
		}
		else{
			//filtro para ir mostrando los modelos
			$filtro.= " and pk_subgpo_catalogo=".$value;
		    $datos = $this->mu->get_cat_marca($value);
		    $respuesta->Assign('div4','innerHTML',mostrar_cmb($datos,'marca',$articulo,$filtro));
		    $respuesta->Assign('div_crear','innerHTML',crear_registro($value,'marca',$filtro));
		    //mostrar los modelos según la selección
		    $respuesta->Assign("div_modelos","innerHTML",mostrar_modelo($this->mu->v_unidades($filtro),$value,$articulo,$filtro,'show_div4'));
		    $respuesta->script("$(function () {
						            $('.chosen-select').chosen({width: '100%'});
						        });");
		}
	    return $respuesta;
    }

    public function modelos($value,$articulo,$filtro){
    	$respuesta = new xajaxResponse();
    	if($value == 'Seleccione'){
    		$respuesta->Assign('div_crear','innerHTML',empty_msg('Selecciona una marca'));
			$respuesta->Assign('div_modelos','innerHTML',empty_msg('Selecciona una marca'));
		}
		else{
			//filtro para ir mostrando los modelos
			$filtro.= " and pk_cat_marca=".$value;
			//$datos = $this->mu->get_cat_modelo($value);
			$respuesta->Assign("div_modelos","innerHTML",mostrar_modelo($this->mu->v_unidades($filtro),$value,$articulo,$filtro,'modelos'));
			$respuesta->Assign("div_crear","innerHTML",crear_modelo($value,$articulo,$filtro));
			$respuesta->script("$(document).ready(function () {
							        mostrarOpcionesTabla('dt_mostrar_modelo');
							    });");
		}
    	return $respuesta;
    }

    public function crear($form){
    	$respuesta = new xajaxResponse();
    	if(get_instance()->session->userdata('editar') != 'N' || get_instance()->session->userdata('fk_cat_tipo_usuario') == 1){
	    	if(!isset($form["h_texto_m"])){
		    	$descripcion = trim($form["descripcion"]);
		    	if(empty($descripcion))
		    		$respuesta->Assign("div_msj","innerHTML",empty_msg("Descripción no puede ir vacío o llevar 0"));
		    	else{
		    		$bandera = TRUE;
		    		$div = "";
		    		switch ($form["h_texto"]) {
		    			case 'gpo_catalogo':
		    				if($bandera = $this->unidades_lib->norep('gpo_catalogo',$descripcion,'fk_cat_tipo_articulo',$form["h_value"]))
					    		$respuesta->Assign("div_msj","innerHTML",empty_msg("Ya existe un nombre con el mismo registro"));
					    	else{
			    				$registro = array("descripcion" => $descripcion,"fk_cat_tipo_articulo" => $form["h_value"]);
					    		$this->mu->insert($registro,"gpo_catalogo");
					    		$div = "div2";
					    	}
		    				break;
		    			case 'subgpo_catalogo':
		    				if($bandera = $this->unidades_lib->norep('subgpo_catalogo',$descripcion,'fk_gpo_catalogo',$form["h_value"]))
					    		$respuesta->Assign("div_msj","innerHTML",empty_msg("Ya existe un nombre con el mismo registro"));
					    	else{
			    				$registro = array("descripcion" => $descripcion,"fk_gpo_catalogo" => $form["h_value"]);
					    		$this->mu->insert($registro,"subgpo_catalogo");
					    		$div = "div3";
					    	}
		    				break;
		    			case 'marca':
		    				if($bandera = $this->unidades_lib->norep('cat_marca',$descripcion,'fk_subgpo_catalogo',$form["h_value"]))
					    		$respuesta->Assign("div_msj","innerHTML",empty_msg("Ya existe un nombre con el mismo registro"));
					    	else{
			    				$registro = array("descripcion" => $descripcion,"fk_subgpo_catalogo" => $form["h_value"]);
					    		$this->mu->insert($registro,"cat_marca");
					    		$div = "div4";
					    	}
		    				break;
		    		}
		    		if(!$bandera){
			    		$respuesta->alert("Registro Guardado Satisfactoriaemnte");
			    		$respuesta->call("loading_small('".$div."');xajax_show_".$div."('".$form["h_value"]."','".$form["h_texto"]."','".$form["h_filtro"]."')");
			    	}
		    	}
		    }
		    else{
		    	$descripcion = trim($form["descripcion"]);
		    	$potencia = (isset($form["potencia"])) ? trim($form["potencia"]) : "";
			    $rodada = (isset($form["rodada"])) ? trim($form["rodada"]) : "";
		    	$anio = trim($form["anio"]);
		    	$precio = trim($form["precio"]);
		    	$detalles = trim($form["detalles"]);
		    	$bandera = TRUE;
		    	if($form["h_texto_m"] == 'Implementos'){
			    	if(empty($descripcion) || empty($precio) || empty($anio) || empty($detalles)){
			    		$respuesta->Assign("div_msj","innerHTML",empty_msg("Los campos no pueden ir vacios o llevar 0"));
			    		$bandera = TRUE;
			    	}
			    	elseif($bandera = $this->unidades_lib->norep('cat_modelo',$descripcion,'fk_cat_marca',$form["h_value"]))
					    $respuesta->Assign("div_msj","innerHTML",empty_msg("Ya existe un nombre con el mismo registro"));
			    	else{
			    		$registro = array(
			    			"descripcion" => $descripcion,
			    			"anio" => $anio,
			    			"precio" => $precio,
			    			"detalles" => $detalles,
			    			"fk_cat_marca" => $form["h_value"]
			    		);
			    	}
			    }
		    	else{
			    	if(empty($descripcion) || empty($potencia) || empty($rodada) || empty($precio) || empty($anio) || empty($detalles)){
			    		$respuesta->Assign("div_msj","innerHTML",empty_msg("Los campos no pueden ir vacios o llevar 0"));
			    		$bandera = TRUE;
			    	}
			    	elseif($bandera = $this->unidades_lib->norep('cat_modelo',$descripcion,'fk_cat_marca',$form["h_value"]))
					    $respuesta->Assign("div_msj","innerHTML",empty_msg("Ya existe un nombre con el mismo registro"));
			    	else{
			    		$registro = array(
			    			"descripcion" => $descripcion,
			    			"potencia" => $potencia,
			    			"rodada" => $rodada,
			    			"anio" => $anio,
			    			"precio" => $precio,
			    			"detalles" => $detalles,
			    			"fk_cat_marca" => $form["h_value"]
			    		);
			    	}
		    	}
		    	if(!$bandera){
					$this->mu->insert($registro,"cat_modelo");
					$respuesta->alert("Registro Guardado Satisfactoriaemnte");
			    	$respuesta->call("loading_small('div_modelos');xajax_modelos('".$form["h_value"]."','".$form["h_texto_m"]."','".$form["h_filtro"]."')");
			    }
		    }
		}
		else
			$respuesta->alert('No tienes permisos para guardar y/o editar');
    	return $respuesta;
    }

    public function editar($texto,$fk,$filtro){
    	$respuesta = new xajaxResponse();
    	if(get_instance()->session->userdata('editar') != 'N' || get_instance()->session->userdata('fk_cat_tipo_usuario') == 1){
	    	//$respuesta->alert($texto." - ".$fk);
	    	$respuesta->clear("div_msj_modal","innerHTML");
	    	switch ($texto) {
				case 'gpo_catalogo':
					$datos = $this->mu->get_gpo_catalogo($fk,FALSE);
					$pk_campo = "pk_gpo_catalogo";
					$tabla = "gpo_catalogo";
					$onclick_cancelar = "loading_small(\"div2\");xajax_show_div2($(\"#fk_cat_tipo_articulo\").val(),\"gpo_catalogo\",\"".$filtro."\")";
					break;
				case 'subgpo_catalogo':
					$datos = $this->mu->get_subgpo_catalogo($fk,FALSE);
					$pk_campo = "pk_subgpo_catalogo";
					$tabla = "subgpo_catalogo";
					$onclick_cancelar = "loading_small(\"div3\");xajax_show_div3($(\"#fk_gpo_catalogo\").val(),\"subgpo_catalogo\",\"".$filtro."\")";
					break;
				case 'marca':
					$datos = $this->mu->get_cat_marca($fk,FALSE);
					$pk_campo = "pk_cat_marca";
					$tabla = "cat_marca";
					$onclick_cancelar = "loading_small(\"div4\");xajax_show_div4($(\"#fk_subgpo_catalogo\").val(),\"marca\",\"".$filtro."\")";
					break;
			}
			$respuesta->Assign("div_modal","innerHTML",mostrar_editar($datos,$pk_campo,$texto,$fk,$filtro,$tabla));
			$respuesta->script("document.getElementById('btn_cancelar_modal').onclick = function () {
									".$onclick_cancelar."
								}");
			$respuesta->script("$(document).ready(function () {
							        mostrarOpcionesTabla('dt_mostrar_editar');
							    });");
		}
		else
			$respuesta->alert('No tienes permisos para guardar y/o editar');
    	return $respuesta;
    }

    public function update_status($pk,$status,$pk_campo,$tabla,$texto,$fk,$filtro){
		$respuesta = new xajaxResponse();
		if(get_instance()->session->userdata('editar') != 'N' || get_instance()->session->userdata('fk_cat_tipo_usuario') == 1){
			$this->mu->update_status($pk,$status,$pk_campo,$tabla);
			$respuesta->alert("Status Actualizado Satisfactoriamente");
			$respuesta->call("xajax_editar('".$texto."','".$fk."','".$filtro."')");
		}
		else
			$respuesta->alert('No tienes permisos para guardar y/o editar');
		return $respuesta;
	}

	public function update($value,$pk,$texto,$fk,$filtro){
		$respuesta = new xajaxResponse();
		if(get_instance()->session->userdata('editar') != 'N' || get_instance()->session->userdata('fk_cat_tipo_usuario') == 1){
			$bandera = TRUE;
		    switch ($texto) {
		    	case 'gpo_catalogo':
		    		if($bandera = $this->unidades_lib->norep('gpo_catalogo',$value,'fk_cat_tipo_articulo',$fk))
			    		$respuesta->Assign("div_msj_modal","innerHTML",empty_msg("Ya existe un nombre con el mismo registro"));
			    	else{
						$registro = array("descripcion" => $value,"pk_gpo_catalogo" => $pk);
			    		$this->mu->update($registro,"pk_gpo_catalogo","gpo_catalogo");
			    	}
		    		break;
		    	case 'subgpo_catalogo':
		    		if($bandera = $this->unidades_lib->norep('subgpo_catalogo',$value,'fk_gpo_catalogo',$fk))
			    		$respuesta->Assign("div_msj_modal","innerHTML",empty_msg("Ya existe un nombre con el mismo registro"));
			    	else{
						$registro = array("descripcion" => $value,"pk_subgpo_catalogo" => $pk);
			    		$this->mu->update($registro,"pk_subgpo_catalogo","subgpo_catalogo");
			    	}
		    		break;
		    	case 'marca':
		    		if($bandera = $this->unidades_lib->norep('cat_marca',$value,'fk_subgpo_catalogo',$fk))
			    		$respuesta->Assign("div_msj_modal","innerHTML",empty_msg("Ya existe un nombre con el mismo registro"));
			    	else{
						$registro = array("descripcion" => $value,"pk_cat_marca" => $pk);
			    		$this->mu->update($registro,"pk_cat_marca","cat_marca");
			    	}
		    		break;
		    }
		    if(!$bandera){
		    	$respuesta->alert("Registro Actualizado Satisfactoriaemnte");
				$respuesta->call("xajax_editar('".$texto."','".$fk."','".$filtro."')");
			}
		}
		else
			$respuesta->alert('No tienes permisos para guardar y/o editar');

		return $respuesta;
	}

	public function update_status_modelo($pk,$status,$value,$articulo,$filtro,$metodo){
		$respuesta = new xajaxResponse();
		if(get_instance()->session->userdata('editar') != 'N' || get_instance()->session->userdata('fk_cat_tipo_usuario') == 1){
			$this->mu->update_status($pk,$status,'pk_cat_modelo','cat_modelo');
			$respuesta->alert("Status Actualizado Satisfactoriamente");
			$respuesta->call("xajax_".$metodo."('".$value."','".$articulo."','".$filtro."')");
		}
		else
			$respuesta->alert('No tienes permisos para guardar y/o editar');
		return $respuesta;
	}

	public function update_modelo($form){
		$respuesta = new xajaxResponse();
		if(get_instance()->session->userdata('editar') != 'N' || get_instance()->session->userdata('fk_cat_tipo_usuario') == 1){
			$metodo = $form["h_metodo"];
			$value = $form["h_value"];
			$articulo = $form["h_articulo"];
			$filtro = $form["h_filtro"];
			for($i = 0; $i < $form["h_i"]; $i++){
				if($articulo == 'Implementos')
					$registro = array(
						"descripcion" => $form["descripcion".$i],
						"potencia" => '----------',
						"rodada" => '----------',
						"anio" => $form["anio".$i],
						"precio" => $form["precio".$i],
						"detalles" => $form["detalles".$i],
						"pk_cat_modelo" => $form["h_pk_cat_modelo".$i]
					);
				else
					$registro = array(
						"descripcion" => $form["descripcion".$i],
						"potencia" => $form["potencia".$i],
						"rodada" => $form["rodada".$i],
						"anio" => $form["anio".$i],
						"precio" => $form["precio".$i],
						"detalles" => $form["detalles".$i],
						"pk_cat_modelo" => $form["h_pk_cat_modelo".$i]
					);
		    	$this->mu->update($registro,"pk_cat_modelo","cat_modelo");
			}
			$respuesta->alert("Datos Actualizados Satisfactoriamente");
			$respuesta->call("xajax_".$metodo."('".$value."','".$articulo."','".$filtro."')");
		}
		else
			$respuesta->alert('No tienes permisos para guardar y/o editar');
		return $respuesta;
	}

    /*****************/
}