<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Agenda extends CI_Controller {
	
	//Constructor
	function __construct(){
		parent::__construct();

		$this->load->model("prospectos/Model_agenda","ma");
		$this->load->helper("prospectos/my_xajax_agenda_helper");
		$this->load->library('prospectos/Agenda_lib');
		$this->load->library('upload');
		$this->load->helper('download');

		/*****Parametros para el correcto funcionamiento de XAJAX*****/
		//mostrar ventana de depuracion
		$this->xajax->configure('debug',FALSE);
		//Registro de funciones XAJAX
		$this->xajax->register(XAJAX_FUNCTION,array('buscar_prospecto',&$this,'buscar_prospecto'));
		$this->xajax->register(XAJAX_FUNCTION,array('mostrar_prospectos',&$this,'mostrar_prospectos'));
		$this->xajax->register(XAJAX_FUNCTION,array('update_actividad',&$this,'update_actividad'));
        $this->xajax->register(XAJAX_FUNCTION,array('guardar',&$this,'guardar'));
        $this->xajax->register(XAJAX_FUNCTION,array('update_info',&$this,'update_info'));
        $this->xajax->register(XAJAX_FUNCTION,array('add_ic',&$this,'add_ic'));
        $this->xajax->register(XAJAX_FUNCTION,array('add_la',&$this,'add_la'));
        $this->xajax->register(XAJAX_FUNCTION,array('update_ic',&$this,'update_ic'));
        $this->xajax->register(XAJAX_FUNCTION,array('update_la',&$this,'update_la'));
		$this->xajax->register(XAJAX_FUNCTION,array('add',&$this,'add'));
		$this->xajax->register(XAJAX_FUNCTION,array('add_re',&$this,'add_re'));
		$this->xajax->register(XAJAX_FUNCTION,array('add_se',&$this,'add_se'));
		$this->xajax->register(XAJAX_FUNCTION,array('cargar_combos',&$this,'cargar_combos'));
		$this->xajax->register(XAJAX_FUNCTION,array('guardar_add',&$this,'guardar_add'));
		$this->xajax->register(XAJAX_FUNCTION,array('guardar_add_re',&$this,'guardar_add_re'));
		$this->xajax->register(XAJAX_FUNCTION,array('guardar_add_se',&$this,'guardar_add_se'));
        //Para procesar las peticiones
        $this->xajax->processRequest();
        //mandamos el script a la pagina      
        $this->xajax->configure('javascript URI',base_url());  
        $this->data['xajax_js'] = $this->xajax->getJavascript(base_url());
	}
	
	public function index($param = ""){
		if(!empty($param)){
			if($param == 'ok')
				$this->data["script"] = "<script>alert('Archivos Subidos Satisfactoriamente');</script>";
			else
				$this->data["script"] = "<script>xajax_mostrar_prospectos('".$param."');</script>";
		}
		$this->data['contenido'] = 'prospectos/agenda/index';
		$this->data["prospectos"] = $this->ma->cargar_prospecto(get_instance()->session->userdata('pk_cat_personal'));
		//$this->data["prospectos"] = $this->ma->cargar_prospecto(get_instance()->session->userdata('articulo_maestro'));
		$this->load->view('template',$this->data);
	}

	public function descargar($prospecto_20,$nombre_archivo){
		$datos = file_get_contents(base_url("info/".$prospecto_20."/".$nombre_archivo."")); // Leer el contenido del archivo
		$nombre = $nombre_archivo;
		force_download($nombre, $datos);
	}

	public function upload(){
		$registro = $this->input->post();
		//si no existe el directorio lo crea
		$dir = "info/";
		if(!is_dir($dir))
			mkdir($dir,0777,true);
		//vemos si tiene nombre o rs
		$nombre = "";
		$nombre = (stripos($registro["txt_nombre"], '-') !== FALSE) ? $registro["txt_razon_social"] : $registro["txt_nombre"];
		//Quitamos los caracteres especiales
		$nombre = strtoupper($this->agenda_lib->normaliza($nombre));
		//Generamos carpetas por cada prospecto
		$directorio = $dir.$nombre."/";
		if(!is_dir($directorio))
			mkdir($directorio,0777,true);//true si se van a crear subcarpetas para habilitar la recursividad
		//vemos cuantos archivos subió el usuario.
		//vamos a obtener los datos de la bd y compararlos si son los mismos con las etiquetas HTML
		$anexos = $this->ma->cargar_cat_anexos();
		foreach ($anexos as $anexos) {
			//quitamos los caracteres especiales
			$descripcion = str_replace(".","",$anexos->descripcion);
			//quitamos los espacios para remplazarlos por "_"
			$descripcion = str_replace(" ","_",$descripcion);
			//quitamos las mayusculas
			$descripcion = strtolower($descripcion);
			for($j = 1; $j <= $anexos->cantidad; $j++){
				$mi_archivo = $descripcion."_".$j;
		        $config['upload_path'] = $directorio;
		        $config['file_name'] = $nombre."_".$descripcion."_".$j;
		        $config['allowed_types'] = "jpg|jpeg|png";
		        $config['max_size'] = "0";//50000
		        $config['max_width'] = "0";//2000
		        $config['max_height'] = "0";//2000
		        $config['overwrite'] = TRUE;

				// Cargamos la configuración del archivo
            	$this->upload->initialize($config);

		        if(!$this->upload->do_upload($mi_archivo)){
		        	//print_r($this->upload->display_errors());
		        	//*** ocurrio un error
		            $data['uploadError'] = $this->upload->display_errors();
		            //echo $this->upload->display_errors();
		            continue;
		        }
			}
		}
		redirect('prospectos/agenda/index/ok');
	}

	/*FUNCIONES XAJAX*/

	public function buscar_prospecto($texto){
		$respuesta = new xajaxResponse();
		$respuesta->clear("div_show","innerHTML");
		$datos = $this->ma->buscar_prospecto(get_instance()->session->userdata('pk_cat_personal'),$texto);
		$respuesta->assign("div_prospectos","innerHTML",mostrar_filtro_prospecto($datos));
		return $respuesta;
	}

	public function mostrar_prospectos($pk_u_prospecto_ciclo,$tab_historial = TRUE){
		$respuesta = new xajaxResponse();
		$datos = $this->ma->v_info_prospecto($pk_u_prospecto_ciclo);
		$flotilla_actual = $this->ma->flotilla_actual($pk_u_prospecto_ciclo);
		$equipo_solicitado = $this->ma->equipo_solicitado($pk_u_prospecto_ciclo);
		$refaccion_solicitada = $this->ma->refaccion_solicitada($pk_u_prospecto_ciclo);
		$servicio_solicitada = $this->ma->servicio_solicitada($pk_u_prospecto_ciclo);
		$localizacion_ad = $this->ma->localizacion_ad($pk_u_prospecto_ciclo);
		$anexos = $this->ma->cargar_cat_anexos();
		$agenda = $this->ma->agenda($pk_u_prospecto_ciclo);
		$status = $this->ma->cargar_status();
		$actividad_status = $this->ma->cargar_cat_actividad_status_seguimiento();
		//Obtenemos desde aquí el nombre del prospecto porque tenemos que quitarle los caracteres especiales si los tuviera
		//Quitamos los caracteres especiales
		$prospecto = strtoupper($this->agenda_lib->normaliza($datos->nombre));
		$respuesta->assign("div_show","innerHTML",mostrar_info_prospectos($prospecto,$datos,$flotilla_actual,$equipo_solicitado,$refaccion_solicitada,$servicio_solicitada,$localizacion_ad,$anexos,$agenda,$status,$actividad_status,$tab_historial));
		$respuesta->script("$(function () {
								$('#dt_fecha_actividad').datetimepicker({
										pickTime: false
									});
        						$('.chosen-select').chosen({width: '100%'});
								mostrarOpcionesTabla('dt_refaccion',false,false,true);
								mostrarOpcionesTabla('dt_servicio',false,false,true);
							});");
		return $respuesta;
	}

	public function update_actividad($pk_agenda,$value,$pk_u_prospecto_ciclo,$bandera = FALSE,$observa = ""){
		$respuesta = new xajaxResponse();
		if(!$bandera){
			$respuesta->script("var observa = prompt(\"Escribe una observacion\");
								if(observa != null && observa != '')
									xajax_update_actividad('".$pk_agenda."','".$value."','".$pk_u_prospecto_ciclo."',true,observa);
								else
									alert('LAS OBSERVACIONES NO PUEDEN IR EN BLANCO...VERIFIQUE');");
		}
		else{
			$observa = trim($observa);
			if(!empty($observa)){
				$this->load->helper('date');
				//OBTENEMOS LA HORA EXACTA SETEANDO LA VARIABLE DATE_DEFAULT_TIMEZONE_SET
				date_default_timezone_set("America/Mexico_City");
				$registro = array(
					"realizada" => $value,
					"observaciones_realizada" => $observa,
					"fecha_realizada" => date("Y-m-d H:i:s"),
					"pk_agenda" => $pk_agenda
				);
				$this->ma->update_agenda($registro);
				$respuesta->alert("Actividad Actualizada Satisfactoriamente");
				$bandera = FALSE;
				$respuesta->call("xajax_mostrar_prospectos('".$pk_u_prospecto_ciclo."','".$bandera."')");
			}
			else
				$respuesta->alert("LAS OBSERVACIONES NO PUEDEN IR EN BLANCO...VERIFIQUE");
		}
		return $respuesta;
	}

    public function guardar($form){
    	$respuesta = new xajaxResponse();
    	//print_r($form);
    	$error_msj = "";
	    $lugar = trim($form["txt_lugar"]);
	    $observaciones_agenda = trim($form["observaciones_agenda"]);
	    if($form["fk_cat_status_seguimiento"] == 'Seleccione')
		   	$error_msj = "Es necesario seleccionar un Status";
		   elseif($form["fk_cat_actividad_status_seguimiento"] == 'Seleccione')
		   	$error_msj = "Es necesario seleccionar una Actividad";
		   elseif(empty($form["txt_fecha_actividad"]))
		   	$error_msj = "Es necesario seleccionar una Fecha de Actividad";
		   elseif(empty($lugar))
		   	$error_msj = "Lugar no puede ir vacío o llevar 0";
		   elseif(empty($observaciones_agenda))
		   	$error_msj = "Observaciones no puede ir vacío o llevar 0";
    	if(!empty($error_msj))//Si existe algún error, entrará aquí
    		$respuesta->assign("div_msj","innerHTML",empty_msg($error_msj));
    	else{
    		// guardamos en la tabla de agenda
    		$registro = array(
				"fecha_actividad" => $form["txt_fecha_actividad"],
				"lugar" => $lugar,
				"observaciones" => $observaciones_agenda,
				"fk_cat_status_seguimiento" => $form["fk_cat_status_seguimiento"],
				"fk_cat_actividad_status_seguimiento" => $form["fk_cat_actividad_status_seguimiento"],
				"fk_u_prospecto_ciclo" => $form["h_pk_u_prospecto_ciclo"],
				"fk_cat_personal" => (get_instance()->session->userdata('pk_cat_personal'))
			);
			$this->ma->insert($registro,"agenda");
			$respuesta->alert("Actividad Guardada Satisfactoriamente");
			$bandera = TRUE;
			$respuesta->call("xajax_mostrar_prospectos('".$form["h_pk_u_prospecto_ciclo"]."','".$bandera."')");
    	}
    	return $respuesta;
    }

    public function update_info($form){
    	$respuesta = new xajaxResponse();
    	//print_r($form);
    	$nombre = trim($form["txt_nombre"]);
    	$rfc = trim($form["txt_rfc"]);
    	$razon_social = trim($form["txt_razon_social"]);
    	$contacto = trim($form["txt_contacto"]);
    	$calle = trim($form["txt_calle"]);
    	$num_int = trim($form["txt_num_int"]);
    	$num_ext = trim($form["txt_num_ext"]);
    	$cp = trim($form["txt_cp"]);
    	$colonia = trim($form["txt_colonia"]);
    	$localidad = trim($form["txt_localidad"]);
    	$municipio = trim($form["txt_municipio"]);
    	$ciudad = trim($form["txt_ciudad"]);
    	$estado = trim($form["txt_estado"]);
    	$pais = trim($form["txt_pais"]);
    	$telefono = trim($form["txt_telefono"]);
    	$correo = trim($form["txt_correo"]);

    	//empezamos a validar
    	if(empty($nombre))
			$error_msj = "Nombre no puede ir vacío o llevar 0";
		elseif(empty($rfc))
			$error_msj = "RFC no puede ir vacío o llevar 0";
		elseif(empty($razon_social))
			$error_msj = "Razón Social no puede ir vacío o llevar 0";
		elseif(empty($contacto))
			$error_msj = "Contacto no puede ir vacío o llevar 0";
    	elseif(empty($calle))
   			$error_msj = "Calle no puede ir vacío o llevar 0";
   		elseif(empty($num_int))
   			$error_msj = "N° Int no puede ir vacío o llevar 0";
   		elseif(empty($num_ext))
   			$error_msj = "N° Ext no puede ir vacío o llevar 0";
   		elseif(empty($cp))
   			$error_msj = "C.P. no puede ir vacío o llevar 0";
   		elseif(empty($colonia))
   			$error_msj = "Colonia no puede ir vacío o llevar 0";
   		elseif(empty($localidad))
   			$error_msj = "Localidad no puede ir vacío o llevar 0";
   		elseif(empty($municipio))
   			$error_msj = "Municipio no puede ir vacío o llevar 0";
   		elseif(empty($ciudad))
   			$error_msj = "Ciudad no puede ir vacío o llevar 0";
   		elseif(empty($estado))
   			$error_msj = "Estado no puede ir vacío o llevar 0";
   		elseif(empty($pais))
   			$error_msj = "País no puede ir vacío o llevar 0";
   		elseif(empty($telefono))
  			$error_msj = "Teléfono no puede ir vacío o llevar 0";
   		elseif(empty($correo))
   			$error_msj = "Correo no puede ir vacío o llevar 0";

   		if(!empty($error_msj))//Si existe algún error, entrará aquí
    		$respuesta->assign("div_msj_info","innerHTML",empty_msg($error_msj));
    	else{
    		//cachamos los pk
    		$pk_cat_generales = $form["h_pk_cat_generales"];
    		$pk_prospecto = $form["h_pk_prospecto"];
    		//empezamos a actualizar los datos en la tabla de prospectos y de cat_generales
    		$registro = array(
				"calle" => $calle,
				"num_int" => $num_int,
				"num_ext" => $num_ext,
				"cp" => $cp,
				"colonia" => $colonia,
				"localidad" => $localidad,
				"municipio" => $municipio,
				"ciudad" => $ciudad,
				"estado" => $estado,
				"pais" => $pais,
				"telefono" => $telefono,
				"correo" => $correo,
				"pk_cat_generales" => $pk_cat_generales
			);
			$this->ma->update_tabla("pk_cat_generales","cat_generales",$registro);
			$registro = array(
				"nombre" => $nombre,
				"razon_social" => $razon_social,
				"rfc" => $rfc,
				"contacto" => $contacto,
				"pk_prospecto" => $pk_prospecto
			);
			$this->ma->update_tabla("pk_prospecto","prospecto",$registro);
			$respuesta->alert("Información Actualizada Satisfactoriamente");
			$respuesta->call("xajax_mostrar_prospectos('".$form["h_pk_u_prospecto_ciclo"]."')");
    	}

    	return $respuesta;
    }

    public function add_ic($num){
    	$respuesta = new xajaxResponse();
		$respuesta->assign("div_ic".($num-1),"innerHTML",mostrar_add_ic($num));
		$respuesta->script("$(function(){
								$('#datetimepicker".$num."').datetimepicker({
							    	pickTime: false
							    });
							});");
		$respuesta->script("$('#h_num_ic').val('".$num."')");
    	return $respuesta;
    }

    public function add_la($num){
    	$respuesta = new xajaxResponse();
		$respuesta->assign("div_la".($num-1),"innerHTML",mostrar_add_la($num));
		$respuesta->script("$('#h_num_la').val('".$num."')");
    	return $respuesta;
    }

    public function update_ic($form){
    	$respuesta = new xajaxResponse();
    	//print_r($form);
    	if($form["h_num_ic"] != 0){//SI TIENE ALGÚN INVENTARIO
	    	for($i = 1; $i <= $form["h_num_ic"]; $i++){
	    		$descripcion_ic = trim($form["txt_descripcion_ic".$i]);
	    		$cantidad_ic = trim($form["txt_cantidad_ic".$i]);
	    		$fecha_adq = trim($form["txt_fecha_adq".$i]);
	    		if(empty($descripcion_ic)){
		   			$error_msj = "Descripción del INVENTARIO CLIENTE no puede ir vacío o llevar 0";
		   			break;
		   		}
		   		elseif(empty($cantidad_ic)){
		   			$error_msj = "Cantidad del INVENTARIO CLIENTE no puede ir vacío o llevar 0";
		   			break;
		   		}
		   		elseif(empty($fecha_adq)){
		   			$error_msj = "Fecha de Adquisición del INVENTARIO CLIENTE no puede ir vacío o llevar 0";
		   			break;
		   		}
	    	}
	    	if(!empty($error_msj))//Si existe algún error, entrará aquí
	    		$respuesta->assign("div_msj_ic","innerHTML",empty_msg($error_msj));
	    	else{
	    		//despues guardamos en la tabla de flotilla_actual
				if($form["h_num_ic"] != 0){//SI TIENE ALGÚN INVENTARIO
	    			for($i = 1; $i <= $form["h_num_ic"]; $i++){
	    				$descripcion_ic = trim($form["txt_descripcion_ic".$i]);
	    				$cantidad_ic = trim($form["txt_cantidad_ic".$i]);
	    				$fecha_adq = trim($form["txt_fecha_adq".$i]);
	    				//insertamos
	    				$registro = array(
							"fecha_adquisicion" => $fecha_adq,
							"descripcion" => $descripcion_ic,
							"cantidad" => $cantidad_ic,
							"fk_u_prospecto_ciclo" => $form["h_pk_u_prospecto_ciclo"]
						);
			    		$this->ma->insert($registro,"flotilla_actual");
	    			}
	    			$respuesta->alert("Flotilla Agregada Satisfactoriamente");
					$respuesta->call("xajax_mostrar_prospectos('".$form["h_pk_u_prospecto_ciclo"]."')");
	    		}
	    	}
	    }
	    else
	    	$respuesta->assign("div_msj_ic","innerHTML",empty_msg("No existen registros ha agregar"));
    	return $respuesta;
    }

    public function update_la($form){
    	$respuesta = new xajaxResponse();
    	//print_r($form);
    	if($form["h_num_la"] != 0){//SI TIENE ALGUNA LOCALIZACION ADICIONAL
	    	for($i = 1; $i <= $form["h_num_la"]; $i++){
	    		$tipo = trim($form["txt_tipo".$i]);
	    		$descripcion_la = trim($form["txt_descripcion_la".$i]);
	    		$nombre = trim($form["txt_nombre".$i]);
	    		$relacion = trim($form["txt_relacion".$i]);
	    		if(empty($tipo)){
		   			$error_msj = "Tipo no puede ir vacío o llevar 0";
		   			break;
		   		}
		   		elseif(empty($descripcion_la)){
		   			$error_msj = "Descripción no puede ir vacío o llevar 0";
		   			break;
		   		}
		   		elseif(empty($nombre)){
		   			$error_msj = "Nombre no puede ir vacío o llevar 0";
		   			break;
		   		}
		   		elseif(empty($relacion)){
		   			$error_msj = "Relación no puede ir vacío o llevar 0";
		   			break;
		   		}
	    	}
	    	if(!empty($error_msj))//Si existe algún error, entrará aquí
	    		$respuesta->assign("div_msj_la","innerHTML",empty_msg($error_msj));
	    	else{
	    		//despues guardamos en la tabla de localizacion_ad
				if($form["h_num_la"] != 0){//SI TIENE ALGUNA LOCALIZACION ADICIONAL
	    			for($i = 1; $i <= $form["h_num_la"]; $i++){
	    				$tipo = trim($form["txt_tipo".$i]);
	    				$descripcion_la = trim($form["txt_descripcion_la".$i]);
	    				$nombre = trim($form["txt_nombre".$i]);
	    				$relacion = trim($form["txt_relacion".$i]);
	    				//insertamos
	    				$registro = array(
							"tipo" => $tipo,
							"descripcion" => $descripcion_la,
							"nombre" => $nombre,
							"relacion" => $relacion,
							"fk_u_prospecto_ciclo" => $form["h_pk_u_prospecto_ciclo"]
						);
			    		$this->ma->insert($registro,"localizacion_ad");	
	    			}
	    			$respuesta->alert("Localizacion Agregada Satisfactoriamente");
					$respuesta->call("xajax_mostrar_prospectos('".$form["h_pk_u_prospecto_ciclo"]."')");
	    		}
	    	}
	    }
	    else
	    	$respuesta->assign("div_msj_la","innerHTML",empty_msg("No existen registros ha agregar"));
    	return $respuesta;
    }

	public function add($pk_u_prospecto_ciclo){
		$respuesta = new xajaxResponse();
		$respuesta->clear("div_msj_modal","innerHTML");
		$tipo_articulo = $this->ma->cargar_tipo_articulo();
		$respuesta->assign("div_modal","innerHTML",mostrar_add($tipo_articulo));
		$respuesta->assign("div_modal_footer","innerHTML",botones_add($pk_u_prospecto_ciclo));
		$respuesta->script("$(document).ready(function () {
							        $('.chosen-select').chosen({width: '100%'});
							    });");
		return $respuesta;
	}

	public function add_re($pk_u_prospecto_ciclo){
		$respuesta = new xajaxResponse();
		$respuesta->clear("div_msj_modal","innerHTML");
		$tipo_articulo = $this->ma->inventRefaccion();
		$respuesta->assign("div_modal","innerHTML",mostrar_add_re($tipo_articulo));
		$respuesta->assign("div_modal_footer","innerHTML",botones_add_re($pk_u_prospecto_ciclo));
		$respuesta->script("$(document).ready(function () {
							        $('.chosen-select').chosen({width: '100%'});
							    });");
		return $respuesta;
	}

	public function add_se($pk_u_prospecto_ciclo){
		$respuesta = new xajaxResponse();
		$respuesta->clear("div_msj_modal","innerHTML");
		$tipo_articulo = $this->ma->servicio();
		$respuesta->assign("div_modal","innerHTML",mostrar_add_se($tipo_articulo));
		$respuesta->assign("div_modal_footer","innerHTML",botones_add_se($pk_u_prospecto_ciclo));
		$respuesta->script("$(document).ready(function () {
							        $('.chosen-select').chosen({width: '100%'});
							    });");
		return $respuesta;
	}

	public function cargar_combos($value,$div){
		$respuesta = new xajaxResponse();
		//OBTENEMOS LOS DATOS DE LA BD
		switch($div){
			 case "div_gpo_catalogo":
			 	if($value == "Seleccione")
			 		$respuesta->assign($div,"innerHTML",empty_msg('Selecciona un Artículo'));
			 	else{
				 	$datos = $this->ma->cargar_gpo_catalogo($value);
				 	$respuesta->assign($div,"innerHTML",mostrar_combo($datos,$div));
				 }
			 break;
			 case "div_subgpo_catalogo":
			 	if($value == "Seleccione")
			 		$respuesta->assign($div,"innerHTML",empty_msg('Selecciona un Grupo de Catálogo'));
			 	else{
				 	$datos = $this->ma->cargar_subgpo_catalogo($value);
				 	$respuesta->assign($div,"innerHTML",mostrar_combo($datos,$div));
				 }
			 break;
			 case "div_marca":
			 	if($value == "Seleccione")
			 		$respuesta->assign($div,"innerHTML",empty_msg('Selecciona un Subgrupo de Catálogo'));
			 	else{
				 	$datos = $this->ma->cargar_cat_marca($value);
				 	$respuesta->assign($div,"innerHTML",mostrar_combo($datos,$div));
				 }
			 break;
			 case "div_modelo":
			 	if($value == "Seleccione")
			 		$respuesta->assign($div,"innerHTML",empty_msg('Selecciona una Marca'));
			 	else{
				 	$datos = $this->ma->cargar_cat_modelo($value);
				 	$respuesta->assign($div,"innerHTML",mostrar_combo($datos,$div));
				 }
			 break;
			 case "div_unidades_plantilla":
				if($value == "Seleccione")
					$respuesta->assign($div,"innerHTML",empty_msg('Selecciona una plantilla de servicio'));
				else{
					$datos = $this->ma->unidades_plantilla($value);
					$respuesta->assign($div,"innerHTML",mostrar_combo($datos,$div));
				}
			 break;

		}
		$respuesta->script("$(document).ready(function () {
						        $('.chosen-select').chosen({width: '100%'});
						    });");
	    return $respuesta;
    }





	
    public function guardar_add($pk_prospecto,$fk_cat_modelo){
    	$respuesta = new xajaxResponse();
		//$respuesta->alert($pk_prospecto);
    	if($fk_cat_modelo == 'Seleccione' || empty($fk_cat_modelo))
    		$respuesta->assign("div_msj_modal","innerHTML",empty_msg("Selecciona un Modelo"));
    	else{
			//Validamos que el prospecto no cuente ya con un ciclo abierto
			$ciclo = $this->ma->validar_ciclo($pk_prospecto,"unidad");
			if(empty($ciclo)){
				//$respuesta->alert('ok');
				$info = $this->ma->obtener_gerente_articulo_maestro('unidad');
				$fk_cat_personal = (empty($info)) ? get_instance()->session->userdata('pk_cat_personal') : $info->pk_cat_personal;
				$info = $this->ma->datos_prospecto($pk_prospecto);
				//despues guardamos en la tabla u_prospecto_ciclo
				$registro = array(
					"observaciones" => "Ciclo creado desde la agenda",
					"servicio" => "NO",
					"refacciones" => "NO",
					"articulo_maestro" => "unidad",
					"fk_prospecto" => $pk_prospecto,
					"fk_cat_tipo_actividad" => $info->fk_cat_tipo_actividad,
					"fk_cat_probabilidad_compra" => $info->fk_cat_probabilidad_compra,
					"fk_cat_condiciones_pago" => $info->fk_cat_condiciones_pago,
					"fk_cat_plazo_pago" => $info->fk_cat_plazo_pago,
					"fk_cat_personal" => $fk_cat_personal
				);
				$pk_u_prospecto_ciclo = $this->ma->insert_u_prospecto_ciclo($registro);
				// guardamos en la tabla
				$registro = array(
					"fk_cat_modelo" => $fk_cat_modelo,
					"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo
				);
				$this->ma->insert($registro,"equipo_solicitado");
				//Generamos actividad automática de alta
				$this->load->helper('date');
				//OBTENEMOS LA HORA EXACTA SETEANDO LA VARIABLE DATE_DEFAULT_TIMEZONE_SET
				date_default_timezone_set("America/Mexico_City");
				$registro = array(
					"fecha_actividad" => date("Y-m-d H:i:s"),
					"lugar" => '-- GENERADO AUTOMÁTICAMENTE --',
					"observaciones" => "Alta de Prospecto (Creado desde la agenda por otro vendedor)",
					"realizada" => 'SI',
					"fecha_realizada" => date("Y-m-d H:i:s"),
					"articulo_maestro" => 'unidad',
					"fk_cat_status_seguimiento" => 1,
					"fk_cat_actividad_status_seguimiento" => 1,
					"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo,
					"fk_cat_personal" => $fk_cat_personal
				);
				$this->ma->insert($registro,"agenda");
				$respuesta->script("$('#myModal').modal('hide')");
				$respuesta->alert("Ciclo Generado Satisfactoriamente");
			}
			else
				$respuesta->assign("div_msj_modal","innerHTML",empty_msg("No puedes asignar una UNIDAD ya que el prospecto cuenta con un ciclo abierto de este tipo de  artículo"));
    	}
    	return $respuesta;
    }

	public function guardar_add_re($pk_prospecto,$refaccionId){
    	$respuesta = new xajaxResponse();
    	if($refaccionId == 'Seleccione' || empty($refaccionId))
    		$respuesta->assign("div_msj_modal","innerHTML",empty_msg("Selecciona una Refacción"));
    	else{
			//Validamos que el prospecto no cuente ya con un ciclo abierto
			$ciclo = $this->ma->validar_ciclo($pk_prospecto,"refaccion");
			if(empty($ciclo)){
				//$respuesta->alert('ok');
				$info = $this->ma->obtener_gerente_articulo_maestro('refaccion');
				$fk_cat_personal = (empty($info)) ? get_instance()->session->userdata('pk_cat_personal') : $info->pk_cat_personal;
				$info = $this->ma->datos_prospecto($pk_prospecto);
				//despues guardamos en la tabla u_prospecto_ciclo
				$registro = array(
					"observaciones" => "Ciclo creado desde la agenda",
					"servicio" => "NO",
					"refacciones" => "SI",
					"articulo_maestro" => "refaccion",
					"fk_prospecto" => $pk_prospecto,
					"fk_cat_tipo_actividad" => $info->fk_cat_tipo_actividad,
					"fk_cat_probabilidad_compra" => $info->fk_cat_probabilidad_compra,
					"fk_cat_condiciones_pago" => $info->fk_cat_condiciones_pago,
					"fk_cat_plazo_pago" => $info->fk_cat_plazo_pago,
					"fk_cat_personal" => $fk_cat_personal
				);
				$pk_u_prospecto_ciclo = $this->ma->insert_u_prospecto_ciclo($registro);
				//insertamos
				$refaccion = explode("|",$refaccionId);
				$registro = array(
					"codigo" => $refaccion[0],
					"descripcion_trabajo" => $refaccion[1],
					"numero_parte" => $refaccion[2],
					"descripcion_parte" => $refaccion[3],
					"capacidad" => 0,//PENDIENTE REVISAR si se va a utilizar
					"tipo_fluido" => "N/A",//PENDIENTE REVISAR si se va a utilizar
					"cantidad" => 1,
					"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo
				);
				$this->ma->insert($registro,"refaccion_solicitada");
				//Generamos actividad automática de alta
				$this->load->helper('date');
				//OBTENEMOS LA HORA EXACTA SETEANDO LA VARIABLE DATE_DEFAULT_TIMEZONE_SET
				date_default_timezone_set("America/Mexico_City");
				$registro = array(
					"fecha_actividad" => date("Y-m-d H:i:s"),
					"lugar" => '-- GENERADO AUTOMÁTICAMENTE --',
					"observaciones" => "Alta de Prospecto (Creado desde la agenda por otro vendedor)",
					"realizada" => 'SI',
					"fecha_realizada" => date("Y-m-d H:i:s"),
					"articulo_maestro" => 'refaccion',
					"fk_cat_status_seguimiento" => 1,
					"fk_cat_actividad_status_seguimiento" => 1,
					"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo,
					"fk_cat_personal" => $fk_cat_personal
				);
				$this->ma->insert($registro,"agenda");
				$respuesta->script("$('#myModal').modal('hide')");
				$respuesta->alert("Ciclo Generado Satisfactoriamente");
			}
			else
				$respuesta->assign("div_msj_modal","innerHTML",empty_msg("No puedes asignar una REFACCIÓN ya que el prospecto cuenta con un ciclo abierto de este tipo de  artículo"));
    	}
    	return $respuesta;
    }

	public function guardar_add_se($pk_prospecto,$fk_servicio,$fk_cat_modelo_ser){
    	$respuesta = new xajaxResponse();
    	if($fk_cat_modelo_ser == 'Seleccione' || empty($fk_cat_modelo_ser))
    		$respuesta->assign("div_msj_modal","innerHTML",empty_msg("Selecciona una Plantilla de servicio y unidad"));
    	else{
			//Validamos que el prospecto no cuente ya con un ciclo abierto
			$ciclo = $this->ma->validar_ciclo($pk_prospecto,"servicio");
			if(empty($ciclo)){
				//$respuesta->alert('ok');
				$info = $this->ma->obtener_gerente_articulo_maestro('servicio');
				$fk_cat_personal = (empty($info)) ? get_instance()->session->userdata('pk_cat_personal') : $info->pk_cat_personal;
				$info = $this->ma->datos_prospecto($pk_prospecto);
				//despues guardamos en la tabla u_prospecto_ciclo
				$registro = array(
					"observaciones" => "Ciclo creado desde la agenda",
					"servicio" => "SI",
					"refacciones" => "NO",
					"articulo_maestro" => "servicio",
					"fk_prospecto" => $pk_prospecto,
					"fk_cat_tipo_actividad" => $info->fk_cat_tipo_actividad,
					"fk_cat_probabilidad_compra" => $info->fk_cat_probabilidad_compra,
					"fk_cat_condiciones_pago" => $info->fk_cat_condiciones_pago,
					"fk_cat_plazo_pago" => $info->fk_cat_plazo_pago,
					"fk_cat_personal" => $fk_cat_personal
				);
				$pk_u_prospecto_ciclo = $this->ma->insert_u_prospecto_ciclo($registro);
				//consultamos los datos a insertar
				$datos = $this->ma->detalle_unidad_plantilla($fk_cat_modelo_ser,$fk_servicio);
				foreach($datos as $value){
					$registro = array(
						"codigo" => $value->codigo,
						"descripcion_trabajo" => $value->descripcion_trabajo,
						"numero_parte" => $value->numero_parte,
						"descripcion_parte" => $value->descripcion_parte,
						"capacidad" => $value->capacidad,
						"tipo_fluido" => $value->tipo_fluido,
						"cantidad" => $value->cantidad,
						"horas" => $value->horas,
						"fk_cat_modelo" => $fk_cat_modelo_ser,
						"fk_servicio" => $fk_servicio,
						"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo
					);
					$this->ma->insert($registro,"servicio_solicitada");
				}
				//Generamos actividad automática de alta
				$this->load->helper('date');
				//OBTENEMOS LA HORA EXACTA SETEANDO LA VARIABLE DATE_DEFAULT_TIMEZONE_SET
				date_default_timezone_set("America/Mexico_City");
				$registro = array(
					"fecha_actividad" => date("Y-m-d H:i:s"),
					"lugar" => '-- GENERADO AUTOMÁTICAMENTE --',
					"observaciones" => "Alta de Prospecto (Creado desde la agenda por otro vendedor)",
					"realizada" => 'SI',
					"fecha_realizada" => date("Y-m-d H:i:s"),
					"articulo_maestro" => 'servicio',
					"fk_cat_status_seguimiento" => 1,
					"fk_cat_actividad_status_seguimiento" => 1,
					"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo,
					"fk_cat_personal" => $fk_cat_personal
				);
				$this->ma->insert($registro,"agenda");
				$respuesta->script("$('#myModal').modal('hide')");
				$respuesta->alert("Ciclo Generado Satisfactoriamente");
			}
			else
				$respuesta->assign("div_msj_modal","innerHTML",empty_msg("No puedes asignar un SERVICIO ya que el prospecto cuenta con un ciclo abierto de este tipo de  artículo"));
    	}
    	return $respuesta;
    }

    /*****************/

}