<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Asignar_prospecto extends CI_Controller {
	
	//Constructor
	function __construct(){
		parent::__construct();

		$this->load->model("prospectos/Model_asignar_prospecto","mpv");

		/*****Parametros para el correcto funcionamiento de XAJAX*****/
		//mostrar ventana de depuracion
		$this->xajax->configure('debug',FALSE);
		//Registro de funciones XAJAX
        $this->xajax->register(XAJAX_FUNCTION,array('guardar',&$this,'guardar'));
        //Para procesar las peticiones
        $this->xajax->processRequest();
        //mandamos el script a la pagina      
        $this->xajax->configure('javascript URI',base_url());  
        $this->data['xajax_js'] = $this->xajax->getJavascript(base_url());
	}
	
	public function index(){
		$this->data['contenido'] = 'prospectos/asignar_prospecto/index';
		$this->data["prospectos"] = $this->mpv->cargar_prospecto(get_instance()->session->userdata('articulo_maestro'));
		$this->data["cargar_vendedores"] = $this->mpv->cargar_vendedores(get_instance()->session->userdata('articulo_maestro'));
		$this->load->view('template',$this->data);
	}

	/*FUNCIONES XAJAX*/

    public function guardar($pk_u_prospecto_ciclo,$cmb,$articulo_maestro){
    	$respuesta = new xajaxResponse();
    	$error_msj = "";
		//$respuesta->alert($pk_u_prospecto_ciclo.",".$cmb);
    	if($cmb == 'Seleccione')
		    $error_msj = "Es necesario seleccionar un VENDEDOR";
    	if(!empty($error_msj))//Si existe algún error, entrará aquí
    		$respuesta->alert($error_msj);
    	else{
    		//actualizamos en la tabla u_prospecto_ciclo
			$registro = array(
				"fk_cat_personal" => $cmb,
				"pk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo
			);
			$this->mpv->update_u_prospecto_ciclo($registro);
    		//despues guardamos en la tabla de agenda(cambio de prospecto)
    		//Generamos actividad automática de alta
			$this->load->helper('date');
			//OBTENEMOS LA HORA EXACTA SETEANDO LA VARIABLE DATE_DEFAULT_TIMEZONE_SET
			date_default_timezone_set("America/Mexico_City");
			$registro = array(
				"fecha_actividad" => date("Y-m-d H:i:s"),
				"lugar" => '-- GENERADO AUTOMÁTICAMENTE --',
				"observaciones" => "Cambio de vendedor",
				"realizada" => 'SI',
				"fecha_realizada" => date("Y-m-d H:i:s"),
				"articulo_maestro" => $articulo_maestro,
				"fk_cat_status_seguimiento" => 8,
				"fk_cat_actividad_status_seguimiento" => 7,
				"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo,
				"fk_cat_personal" => $cmb
			);
			$this->mpv->insert($registro,"agenda");
			$respuesta->alert("Prospecto Reasignado Satisfactoriamente");
			//$respuesta->redirect(base_url(""));
    	}

    	return $respuesta;
    }

    /*****************/

}