<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cotizacion extends CI_Controller {
	
	//Constructor
	function __construct(){
		parent::__construct();

		$this->load->model("prospectos/Model_cotizacion","mc");
		$this->load->helper("prospectos/my_xajax_cotizacion_helper");
		//$this->load->library('prospectos/Cotizacion_lib');

		/*****Parametros para el correcto funcionamiento de XAJAX*****/
		//mostrar ventana de depuracion
		$this->xajax->configure('debug',FALSE);
		//Registro de funciones XAJAX
		$this->xajax->register(XAJAX_FUNCTION,array('buscar_prospecto',&$this,'buscar_prospecto'));
		$this->xajax->register(XAJAX_FUNCTION,array('mostrar_prospectos',&$this,'mostrar_prospectos'));
		$this->xajax->register(XAJAX_FUNCTION,array('baja',&$this,'baja'));
		$this->xajax->register(XAJAX_FUNCTION,array('update_status',&$this,'update_status'));
		$this->xajax->register(XAJAX_FUNCTION,array('add',&$this,'add'));
		$this->xajax->register(XAJAX_FUNCTION,array('add_re',&$this,'add_re'));
		$this->xajax->register(XAJAX_FUNCTION,array('add_se',&$this,'add_se'));
		$this->xajax->register(XAJAX_FUNCTION,array('cargar_combos',&$this,'cargar_combos'));
		$this->xajax->register(XAJAX_FUNCTION,array('guardar_add',&$this,'guardar_add'));
		$this->xajax->register(XAJAX_FUNCTION,array('guardar_add_re',&$this,'guardar_add_re'));
		$this->xajax->register(XAJAX_FUNCTION,array('guardar_add_se',&$this,'guardar_add_se'));
        //Para procesar las peticiones
        $this->xajax->processRequest();
        //mandamos el script a la pagina      
        $this->xajax->configure('javascript URI',base_url());  
        $this->data['xajax_js'] = $this->xajax->getJavascript(base_url());
	}
	
	public function index(){
		$this->data['contenido'] = 'prospectos/cotizacion/index';
		$this->data["prospectos"] = $this->mc->cargar_prospecto(get_instance()->session->userdata('pk_cat_personal'));
		//$this->data["prospectos"] = $this->mc->cargar_prospecto(get_instance()->session->userdata('articulo_maestro'));
		$this->load->view('template',$this->data);
	}

	public function imprimir(){
		$pk_u_prospecto_ciclo = $this->input->post("h_pk_u_prospecto_ciclo");
		//guardamos la cabecera de cotizacion
		$prefijo = $this->mc->prefijo(get_instance()->session->userdata('id'));
		$folio = empty($prefijo[0]->folio) ? $prefijo[1]->folio."1" : $prefijo[0]->folio;
		$registro = array(
			"folio" => $folio,
			"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo,
			"fk_cat_personal" => get_instance()->session->userdata('pk_cat_personal'),
			"fk_cat_sucursal" => get_instance()->session->userdata('id'),
			"tipo" => $this->input->post("cmb_tipo_cot")
		);
		$pk_cotizacion = $this->mc->insert_cotizacion($registro);
		//Dividimos por articulo
		switch (get_instance()->session->userdata('articulo_maestro')) {
			case 'unidad':
				//recorremos para saber si tiene status de alta o baja y saber cuantos articulos son
				for($i = 0; $i < $this->input->post("h_tot_cot"); $i++){
					if($this->input->post('h_status'.$i) == 'A'){
						$registro = array(
							"precio" => $this->input->post("precio".$i),
							"fk_cotizacion" => $pk_cotizacion,
							"fk_equipo_solicitado" => $this->input->post("h_fk_solicitado".$i),
						);
						//insertamos en la tabla det_cotizacion
						$this->mc->insert($registro,"det_cotizacion");
					}
				}
				//obtenemos los datos de los equipos cotizados
				$cotizacion = $this->mc->obtener_cotizacion($pk_cotizacion);
				//guardamos la actividad en agenda
				$this->load->helper('date');
				//OBTENEMOS LA HORA EXACTA SETEANDO LA VARIABLE DATE_DEFAULT_TIMEZONE_SET
				date_default_timezone_set("America/Mexico_City");

				$registro = array(
					"fecha_actividad" => date("Y-m-d H:i:s"),
					"lugar" => '-- GENERADO AUTOMÁTICAMENTE --',
					"observaciones" => "Generación de cotización Num. ".$folio,
					"realizada" => 'SI',
					"fecha_realizada" => date("Y-m-d H:i:s"),
					"articulo_maestro" => "unidad",
					"fk_cat_status_seguimiento" => 2,
					"fk_cat_actividad_status_seguimiento" => 3,
					"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo,
					"fk_cat_personal" => (get_instance()->session->userdata('pk_cat_personal'))
				);
				$this->mc->insert($registro,"agenda");
				break;

			case 'refaccion':
				//recorremos para saber si tiene status de alta o baja y saber cuantos articulos son
				for($i = 0; $i < $this->input->post("h_tot_cot"); $i++){
					if($this->input->post('h_status'.$i) == 'A'){
						$registro = array(
							"precio" => $this->input->post("precio".$i),
							"fk_cotizacion" => $pk_cotizacion,
							"fk_refaccion_solicitada" => $this->input->post("h_fk_solicitado".$i),
						);
						//insertamos en la tabla det_cotizacion_refa
						$this->mc->insert($registro,"det_cotizacion_refa");
					}
				}
				//obtenemos los datos de los equipos cotizados
				$cotizacion = $this->mc->obtener_cotizacion_refa($pk_cotizacion);
				//guardamos la actividad en agenda
				$this->load->helper('date');
				//OBTENEMOS LA HORA EXACTA SETEANDO LA VARIABLE DATE_DEFAULT_TIMEZONE_SET
				date_default_timezone_set("America/Mexico_City");

				$registro = array(
					"fecha_actividad" => date("Y-m-d H:i:s"),
					"lugar" => '-- GENERADO AUTOMÁTICAMENTE --',
					"observaciones" => "Generación de cotización Num. ".$folio,
					"realizada" => 'SI',
					"fecha_realizada" => date("Y-m-d H:i:s"),
					"articulo_maestro" => "refaccion",
					"fk_cat_status_seguimiento" => 2,
					"fk_cat_actividad_status_seguimiento" => 3,
					"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo,
					"fk_cat_personal" => (get_instance()->session->userdata('pk_cat_personal'))
				);
				$this->mc->insert($registro,"agenda");
				break;

			case 'servicio':
				//recorremos para saber si tiene status de alta o baja y saber cuantos articulos son
				for($i = 0; $i < $this->input->post("h_tot_cot"); $i++){
					if($this->input->post('h_status'.$i) == 'A'){
						$registro = array(
							"precio" => $this->input->post("precio".$i),
							"fk_cotizacion" => $pk_cotizacion,
							"fk_servicio_solicitada" => $this->input->post("h_fk_solicitado".$i),
						);
						//insertamos en la tabla det_cotizacion_serv
						$this->mc->insert($registro,"det_cotizacion_serv");
					}
				}
				//obtenemos los datos de los equipos cotizados
				$cotizacion = $this->mc->obtener_cotizacion_serv($pk_cotizacion);
				//guardamos la actividad en agenda
				$this->load->helper('date');
				//OBTENEMOS LA HORA EXACTA SETEANDO LA VARIABLE DATE_DEFAULT_TIMEZONE_SET
				date_default_timezone_set("America/Mexico_City");

				$registro = array(
					"fecha_actividad" => date("Y-m-d H:i:s"),
					"lugar" => '-- GENERADO AUTOMÁTICAMENTE --',
					"observaciones" => "Generación de cotización Num. ".$folio,
					"realizada" => 'SI',
					"fecha_realizada" => date("Y-m-d H:i:s"),
					"articulo_maestro" => "servicio",
					"fk_cat_status_seguimiento" => 2,
					"fk_cat_actividad_status_seguimiento" => 3,
					"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo,
					"fk_cat_personal" => (get_instance()->session->userdata('pk_cat_personal'))
				);
				$this->mc->insert($registro,"agenda");
				break;
		}
		
		//obtenemos los datos del prospecto
		$prospecto = $this->mc->prospecto_impresion($pk_u_prospecto_ciclo);		
		imprimir($prospecto,$cotizacion);
	}

	/*FUNCIONES XAJAX*/

	public function buscar_prospecto($texto){
		$respuesta = new xajaxResponse();
		$respuesta->clear("div_show","innerHTML");
		$datos = $this->mc->buscar_prospecto(get_instance()->session->userdata('pk_cat_personal'),$texto);
		$respuesta->assign("div_prospectos","innerHTML",mostrar_filtro_prospecto($datos));
		return $respuesta;
	}

	public function mostrar_prospectos($pk_u_prospecto_ciclo){
		$respuesta = new xajaxResponse();
		$datos = $this->mc->v_info_prospecto($pk_u_prospecto_ciclo);
		$solicitado = "";
		switch (get_instance()->session->userdata('articulo_maestro')) {
			case 'unidad':
				$solicitado = $this->mc->equipo_solicitado($pk_u_prospecto_ciclo);
				break;
			
			case 'refaccion':
				$solicitado = $this->mc->refaccion_solicitada($pk_u_prospecto_ciclo);
				break;

			case 'servicio':
				$solicitado = $this->mc->servicio_solicitada($pk_u_prospecto_ciclo);
				break;
		}
		$respuesta->assign("div_show","innerHTML",mostrar_datos_cotizacion($datos,$solicitado,$pk_u_prospecto_ciclo,get_instance()->session->userdata('articulo_maestro')));
		$respuesta->script("$(document).ready(function () {
						        mostrarOpcionesTabla('dt_cotizaciones');
						        $('.chosen-select').chosen({width: '100%'});
						    });");
		return $respuesta;
	}

	public function baja($pk_solicitado,$status,$pk_u_prospecto_ciclo){
		$respuesta = new xajaxResponse();
		$respuesta->clear("div_msj_modal","innerHTML");
		$rechazo = $this->mc->cat_rechazo();
		$respuesta->assign("div_modal","innerHTML",mostrar_datos_baja($rechazo));
		if($status == 'A'){
			$respuesta->assign("div_modal_footer","innerHTML",botones_baja($pk_solicitado,$status,$pk_u_prospecto_ciclo));
			$respuesta->script("$(document).ready(function () {
							        $('.chosen-select').chosen({width: '100%'});
							    });");
		}
		else
			$respuesta->call("xajax_update_status('".$pk_solicitado."','0','B','".$pk_u_prospecto_ciclo."')");
		return $respuesta;
	}

	public function update_status($pk_solicitado,$fk_cat_rechazo,$status,$pk_u_prospecto_ciclo){
		$respuesta = new xajaxResponse();
		if($fk_cat_rechazo == 'Seleccione')
			$respuesta->assign("div_msj_modal","innerHTML",empty_msg("Selecciona un Motivo"));
		else{
			$status = ($status == 'A') ? 'B' : 'A';
			$this->load->helper('date');
			//OBTENEMOS LA HORA EXACTA SETEANDO LA VARIABLE DATE_DEFAULT_TIMEZONE_SET
			date_default_timezone_set("America/Mexico_City");
			$registro = array(
				"fk_cat_rechazo" => $fk_cat_rechazo,
				"fecha_rechazo" => date("Y-m-d H:i:s"),
				"status" => $status
			);
			switch (get_instance()->session->userdata('articulo_maestro')) {
				case 'unidad':
					$this->mc->update_status($pk_solicitado,$registro,"equipo_solicitado");
					break;
				
				case 'refaccion':
					$this->mc->update_status($pk_solicitado,$registro,"refaccion_solicitada");
					break;
				
				case 'servicio':
					$this->mc->update_status($pk_solicitado,$registro,"servicio_solicitada");
					break;
			}
			$respuesta->script("$('#myModal').modal('hide')");
			$respuesta->alert("Status Actualizado Satisfactoriamente");
			$respuesta->call("xajax_mostrar_prospectos('".$pk_u_prospecto_ciclo."')");
		}
		return $respuesta;
	}

	public function add($pk_u_prospecto_ciclo){
		$respuesta = new xajaxResponse();
		$respuesta->clear("div_msj_modal","innerHTML");
		$tipo_articulo = $this->mc->cargar_tipo_articulo();
		$respuesta->assign("div_modal","innerHTML",mostrar_add($tipo_articulo));
		$respuesta->assign("div_modal_footer","innerHTML",botones_add($pk_u_prospecto_ciclo));
		$respuesta->script("$(document).ready(function () {
							        $('.chosen-select').chosen({width: '100%'});
							    });");
		return $respuesta;
	}

	public function add_re($pk_u_prospecto_ciclo){
		$respuesta = new xajaxResponse();
		$respuesta->clear("div_msj_modal","innerHTML");
		$tipo_articulo = $this->mc->inventRefaccion();
		$respuesta->assign("div_modal","innerHTML",mostrar_add_re($tipo_articulo));
		$respuesta->assign("div_modal_footer","innerHTML",botones_add_re($pk_u_prospecto_ciclo));
		$respuesta->script("$(document).ready(function () {
							        $('.chosen-select').chosen({width: '100%'});
							    });");
		return $respuesta;
	}

	public function add_se($pk_u_prospecto_ciclo){
		$respuesta = new xajaxResponse();
		$respuesta->clear("div_msj_modal","innerHTML");
		$tipo_articulo = $this->mc->servicio();
		$respuesta->assign("div_modal","innerHTML",mostrar_add_se($tipo_articulo));
		$respuesta->assign("div_modal_footer","innerHTML",botones_add_se($pk_u_prospecto_ciclo));
		$respuesta->script("$(document).ready(function () {
							        $('.chosen-select').chosen({width: '100%'});
							    });");
		return $respuesta;
	}

	public function cargar_combos($value,$div){
		$respuesta = new xajaxResponse();
		//OBTENEMOS LOS DATOS DE LA BD
		switch($div){
			 case "div_gpo_catalogo":
			 	if($value == "Seleccione")
			 		$respuesta->assign($div,"innerHTML",empty_msg('Selecciona un Artículo'));
			 	else{
				 	$datos = $this->mc->cargar_gpo_catalogo($value);
				 	$respuesta->assign($div,"innerHTML",mostrar_combo($datos,$div));
				 }
			 break;
			 case "div_subgpo_catalogo":
			 	if($value == "Seleccione")
			 		$respuesta->assign($div,"innerHTML",empty_msg('Selecciona un Grupo de Catálogo'));
			 	else{
				 	$datos = $this->mc->cargar_subgpo_catalogo($value);
				 	$respuesta->assign($div,"innerHTML",mostrar_combo($datos,$div));
				 }
			 break;
			 case "div_marca":
			 	if($value == "Seleccione")
			 		$respuesta->assign($div,"innerHTML",empty_msg('Selecciona un Subgrupo de Catálogo'));
			 	else{
				 	$datos = $this->mc->cargar_cat_marca($value);
				 	$respuesta->assign($div,"innerHTML",mostrar_combo($datos,$div));
				 }
			 break;
			 case "div_modelo":
			 	if($value == "Seleccione")
			 		$respuesta->assign($div,"innerHTML",empty_msg('Selecciona una Marca'));
			 	else{
				 	$datos = $this->mc->cargar_cat_modelo($value);
				 	$respuesta->assign($div,"innerHTML",mostrar_combo($datos,$div));
				 }
			 break;
			 case "div_unidades_plantilla":
				if($value == "Seleccione")
					$respuesta->assign($div,"innerHTML",empty_msg('Selecciona una plantilla de servicio'));
				else{
					$datos = $this->mc->unidades_plantilla($value);
					$respuesta->assign($div,"innerHTML",mostrar_combo($datos,$div));
				}
			 break;

		}
		$respuesta->script("$(document).ready(function () {
						        $('.chosen-select').chosen({width: '100%'});
						    });");
	    return $respuesta;
    }

    public function guardar_add($pk_u_prospecto_ciclo,$fk_cat_modelo){
    	$respuesta = new xajaxResponse();
    	if($fk_cat_modelo == 'Seleccione' || empty($fk_cat_modelo))
    		$respuesta->assign("div_msj_modal","innerHTML",empty_msg("Selecciona un Modelo"));
    	else{
    		// guardamos en la tabla de agenda
    		$registro = array(
				"fk_cat_modelo" => $fk_cat_modelo,
				"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo
			);
			$this->mc->insert($registro,"equipo_solicitado");
			$respuesta->script("$('#myModal').modal('hide')");
			$respuesta->alert("Articulo Guardado Satisfactoriamente");
			$respuesta->call("xajax_mostrar_prospectos('".$pk_u_prospecto_ciclo."')");
    	}
    	return $respuesta;
    }

	public function guardar_add_re($pk_u_prospecto_ciclo,$refaccionId){
    	$respuesta = new xajaxResponse();
    	if($refaccionId == 'Seleccione' || empty($refaccionId))
    		$respuesta->assign("div_msj_modal","innerHTML",empty_msg("Selecciona una Refacción"));
    	else{
			//insertamos
			$refaccion = explode("|",$refaccionId);
			$registro = array(
				"codigo" => $refaccion[0],
				"descripcion_trabajo" => $refaccion[1],
				"numero_parte" => $refaccion[2],
				"descripcion_parte" => $refaccion[3],
				"capacidad" => 0,//PENDIENTE REVISAR si se va a utilizar
				"tipo_fluido" => "N/A",//PENDIENTE REVISAR si se va a utilizar
				"cantidad" => 1,
				"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo
			);
			$this->mc->insert($registro,"refaccion_solicitada");
			$respuesta->script("$('#myModal').modal('hide')");
			$respuesta->alert("Refaccion Guardada Satisfactoriamente");
			$respuesta->call("xajax_mostrar_prospectos('".$pk_u_prospecto_ciclo."')");
    	}
    	return $respuesta;
    }

	public function guardar_add_se($pk_u_prospecto_ciclo,$fk_servicio,$fk_cat_modelo_ser){
    	$respuesta = new xajaxResponse();
    	if($fk_cat_modelo_ser == 'Seleccione' || empty($fk_cat_modelo_ser))
    		$respuesta->assign("div_msj_modal","innerHTML",empty_msg("Selecciona una Plantilla de servicio y unidad"));
    	else{
			//consultamos los datos a insertar
			$datos = $this->mc->detalle_unidad_plantilla($fk_cat_modelo_ser,$fk_servicio);
			foreach($datos as $value){
				$registro = array(
					"codigo" => $value->codigo,
					"descripcion_trabajo" => $value->descripcion_trabajo,
					"numero_parte" => $value->numero_parte,
					"descripcion_parte" => $value->descripcion_parte,
					"capacidad" => $value->capacidad,
					"tipo_fluido" => $value->tipo_fluido,
					"cantidad" => $value->cantidad,
					"horas" => $value->horas,
					"fk_cat_modelo" => $fk_cat_modelo_ser,
					"fk_servicio" => $fk_servicio,
					"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo
				);
				$this->mc->insert($registro,"servicio_solicitada");
			}			
			$respuesta->script("$('#myModal').modal('hide')");
			$respuesta->alert("Servicio Guardado Satisfactoriamente");
			$respuesta->call("xajax_mostrar_prospectos('".$pk_u_prospecto_ciclo."')");
    	}
    	return $respuesta;
    }

    /*****************/

}