<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Nuevo extends CI_Controller {
	
	//Constructor
	function __construct(){
		parent::__construct();

		$this->load->model("prospectos/Model_nuevo","mn");
		$this->load->helper("prospectos/my_xajax_nuevo_helper");
		$this->load->library('prospectos/Nuevo_lib');
		$this->load->library('upload');

		/*$this->form_validation->set_message('required','Debe ingresar un valor para %s');
		$this->form_validation->set_message('matches','%s no coincide con %s');
		$this->form_validation->set_message('cambiook','No se puede realizar el cambio de contraseña');
		$this->form_validation->set_message('norep','Existe otro registro con el mismo %s');
		$this->form_validation->set_message('emailok','Correo inválido');*/

		/*****Parametros para el correcto funcionamiento de XAJAX*****/
		//mostrar ventana de depuracion
		$this->xajax->configure('debug',FALSE);
		//Registro de funciones XAJAX
        $this->xajax->register(XAJAX_FUNCTION,array('cargar_combos',&$this,'cargar_combos'));
        $this->xajax->register(XAJAX_FUNCTION,array('add_ic',&$this,'add_ic'));
        $this->xajax->register(XAJAX_FUNCTION,array('add_la',&$this,'add_la'));
        $this->xajax->register(XAJAX_FUNCTION,array('add_es',&$this,'add_es'));
		$this->xajax->register(XAJAX_FUNCTION,array('add_re',&$this,'add_re'));
		$this->xajax->register(XAJAX_FUNCTION,array('add_se',&$this,'add_se'));
        $this->xajax->register(XAJAX_FUNCTION,array('mostrar_detalles_modelo',&$this,'mostrar_detalles_modelo'));
        $this->xajax->register(XAJAX_FUNCTION,array('guardar',&$this,'guardar'),array('mode' => "'synchronous'"));
        //Para procesar las peticiones
        $this->xajax->processRequest();
        //mandamos el script a la pagina      
        $this->xajax->configure('javascript URI',base_url());  
        $this->data['xajax_js'] = $this->xajax->getJavascript(base_url());
	}
	
	public function index($param = ""){
		if(stripos(get_instance()->session->userdata('empleado_de'),"s") !== FALSE){
			$this->data['contenido'] = 'prospectos/nuevo/index';
			$this->data["actividades"] = $this->mn->cargar_actividades();
			$this->data["probabilidades_compra"] = $this->mn->cargar_probabilidades_compra();
			$this->data["condiciones_pago"] = $this->mn->cargar_condiciones_pago();
			$this->data["plazo_pago"] = $this->mn->cargar_plazo_pago();
			$this->data["motivo_visita"] = $this->mn->cargar_status();
			$this->data["tipo_articulo"] = $this->mn->cargar_tipo_articulo();
			$this->data["cat_anexos"] = $this->mn->cargar_cat_anexos();
			$this->data["actividad_status"] = $this->mn->cargar_cat_actividad_status_seguimiento();
			//creamos un arreglo para poder poner PENDIENTE a todos los campos
			$this->data["pendiente"] = array(
				"calle" => "PENDIENTE",
				"num_int" => "PENDIENTE",
				"num_ext" => "PENDIENTE",
				"cp" => "PENDIENTE",
				"colonia" => "PENDIENTE",
				"localidad" => "PENDIENTE",
				"municipio" => "PENDIENTE",
				"ciudad" => "PENDIENTE",
				"estado" => "PENDIENTE",
				"pais" => "PENDIENTE",
				"telefono" => "PENDIENTE",
				"correo" => "PENDIENTE"
			);
			//realizamos CAST para que sea tipo OBJECT
			$this->data["pendiente"] = (object) $this->data["pendiente"];
			$this->load->view('template',$this->data);
			if($param == 'ok')
				echo "<script>alert('Prospecto Guardado Satisfactoriamente');</script>";
		}
		else{
			$data["contenido"] = 'prospectos/nuevo/error_msj';
			$this->load->view('template',$data);
		}
	}

	public function upload(){
		$registro = $this->input->post();
		//si no existe el directorio lo crea
		$dir = "info/";
		if(!is_dir($dir))
			mkdir($dir,0777,true);
		//vemos si es persona moral o física para crear una carpeta y anteponer su nombre o rs
		$nombre = "";
		if($registro["rbtn_persona"] == 'PF')
			$nombre = $registro["txt_nombre"];
		else
			$nombre = $registro["txt_razon_social"];
		//Quitamos los caracteres especiales
		$nombre = strtoupper($this->nuevo_lib->normaliza($nombre));
		//Generamos carpetas por cada prospecto
		$directorio = $dir.$nombre."/";
		if(!is_dir($directorio))
			mkdir($directorio,0777,true);//true si se van a crear subcarpetas para habilitar la recursividad
		//vemos cuantos archivos subió el usuario.
		//vamos a obtener los datos de la bd y compararlos si son los mismos con las etiquetas HTML
		$anexos = $this->mn->cargar_cat_anexos();
		foreach ($anexos as $anexos) {
			//quitamos los caracteres especiales
			$descripcion = str_replace(".","",$anexos->descripcion);
			//quitamos los espacios para remplazarlos por "_"
			$descripcion = str_replace(" ","_",$descripcion);
			//quitamos las mayusculas
			$descripcion = strtolower($descripcion);
			for($j = 1; $j <= $anexos->cantidad; $j++){
				$mi_archivo = $descripcion."_".$j;
		        $config['upload_path'] = $directorio;
		        $config['file_name'] = $nombre."_".$descripcion."_".$j;
		        $config['allowed_types'] = "jpg|jpeg|png";
		        $config['max_size'] = "0";//50000
		        $config['max_width'] = "0";//2000
		        $config['max_height'] = "0";//2000
		        $config['overwrite'] = TRUE;

				// Cargamos la configuración del archivo
            	$this->upload->initialize($config);

		        if(!$this->upload->do_upload($mi_archivo)){
		        	//print_r($this->upload->display_errors());
		        	//*** ocurrio un error
		            $data['uploadError'] = $this->upload->display_errors();
		            //echo $this->upload->display_errors();
		            continue;
		        }
			}
		}
		redirect('prospectos/nuevo/index/ok');
	}

	/*FUNCIONES XAJAX*/
	public function cargar_combos($value,$div,$num = ""){
		$respuesta = new xajaxResponse();
		//OBTENEMOS LOS DATOS DE LA BD
		switch($div){
			 case "div_tipo_actividad":
			 	$datos = $this->mn->cargar_tipo_actividades($value);
			 	$respuesta->assign($div,"innerHTML",mostrar_tipo_actividades($datos,$value));
			 break;
			 case "div_gpo_catalogo":
			 	if($value == "Seleccione")
			 		$respuesta->assign($div.$num,"innerHTML",empty_msg('Selecciona un Artículo'));
			 	else{
				 	$datos = $this->mn->cargar_gpo_catalogo($value);
				 	$respuesta->assign($div.$num,"innerHTML",mostrar_combo($datos,$div,$num));
				 }
			 break;
			 case "div_subgpo_catalogo":
			 	if($value == "Seleccione")
			 		$respuesta->assign($div.$num,"innerHTML",empty_msg('Selecciona un Grupo de Catálogo'));
			 	else{
				 	$datos = $this->mn->cargar_subgpo_catalogo($value);
				 	$respuesta->assign($div.$num,"innerHTML",mostrar_combo($datos,$div,$num));
				 }
			 break;
			 case "div_marca":
			 	if($value == "Seleccione")
			 		$respuesta->assign($div.$num,"innerHTML",empty_msg('Selecciona un Subgrupo de Catálogo'));
			 	else{
				 	$datos = $this->mn->cargar_cat_marca($value);
				 	$respuesta->assign($div.$num,"innerHTML",mostrar_combo($datos,$div,$num));
				 }
			 break;
			 case "div_modelo":
			 	if($value == "Seleccione")
			 		$respuesta->assign($div.$num,"innerHTML",empty_msg('Selecciona una Marca'));
			 	else{
				 	$datos = $this->mn->cargar_cat_modelo($value);
				 	$respuesta->assign($div.$num,"innerHTML",mostrar_combo($datos,$div,$num));
				 }
			 break;
			 case "div_unidades_plantilla":
				if($value == "Seleccione")
					$respuesta->assign($div.$num,"innerHTML",empty_msg('Selecciona una plantilla de servicio'));
				else{
					$datos = $this->mn->unidades_plantilla($value);
					$respuesta->assign($div.$num,"innerHTML",mostrar_combo($datos,$div,$num));
				}
			 break;

		}
		$respuesta->script("$(function () {
        						$('.chosen-select').chosen({width: '100%'});
							});");
	    return $respuesta;
    }

    public function add_ic($num){
    	$respuesta = new xajaxResponse();
		$respuesta->assign("div_ic".($num-1),"innerHTML",mostrar_add_ic($num));
		$respuesta->script("$(function(){
								$('#datetimepicker".$num."').datetimepicker({
							    	pickTime: false
							    });
							});");
		$respuesta->script("$('#h_num_ic').val('".$num."')");
    	return $respuesta;
    }

    public function add_la($num){
    	$respuesta = new xajaxResponse();
		$respuesta->assign("div_la".($num-1),"innerHTML",mostrar_add_la($num));
		$respuesta->script("$('#h_num_la').val('".$num."')");
    	return $respuesta;
    }

    public function add_es($num){
    	$respuesta = new xajaxResponse();
		$respuesta->assign("div_es".($num-1),"innerHTML",mostrar_add_es($num,$this->mn->cargar_tipo_articulo()));
		$respuesta->script("$('#h_num_es').val('".$num."')");
    	return $respuesta;
    }

	public function add_re($num){
    	$respuesta = new xajaxResponse();
		$respuesta->assign("div_re".($num-1),"innerHTML",mostrar_add_re($num,$this->mn->inventRefaccion()));
		$respuesta->script("$('#h_num_re').val('".$num."')");
		$respuesta->script("$(function () {
        						$('.chosen-select').chosen({width: '100%'});
							});");
    	return $respuesta;
    }

	public function add_se($num){
    	$respuesta = new xajaxResponse();
		$respuesta->assign("div_se".($num-1),"innerHTML",mostrar_add_se($num,$this->mn->servicio()));
		$respuesta->script("$('#h_num_se').val('".$num."')");
		$respuesta->script("$(function () {
        						$('.chosen-select').chosen({width: '100%'});
							});");
    	return $respuesta;
    }

    public function mostrar_detalles_modelo($pk_cat_modelo){
    	$respuesta = new xajaxResponse();
    	if($pk_cat_modelo == "Seleccione")
    		$respuesta->assign("div_modal","innerHTML",empty_msg("Selecciona un modelo"));
    	else{
    		$modelo = $this->mn->v_unidades($pk_cat_modelo);
    		$respuesta->assign("div_modal","innerHTML",mostrar_detalles_modelo($modelo));
    	}
    	return $respuesta;
    }

    public function guardar($form){
    	$respuesta = new xajaxResponse();
    	$respuesta->script("$('#btn_guardar').attr('disabled',true);");
    	//print_r($form);
    	$nombre = trim($form["txt_nombre"]);
    	$rfc_pf = trim($form["txt_rfc_pf"]);
    	$razon_social = trim($form["txt_razon_social"]);
    	$rfc_pm = trim($form["txt_rfc_pm"]);
    	$contacto = trim($form["txt_contacto"]);
    	$calle = trim($form["txt_calle"]);
    	$num_int = trim($form["txt_num_int"]);
    	$num_ext = trim($form["txt_num_ext"]);
    	$cp = trim($form["txt_cp"]);
    	$colonia = trim($form["txt_colonia"]);
    	$localidad = trim($form["txt_localidad"]);
    	$municipio = trim($form["txt_municipio"]);
    	$ciudad = trim($form["txt_ciudad"]);
    	$estado = trim($form["txt_estado"]);
    	$pais = trim($form["txt_pais"]);
    	$telefono = trim($form["txt_telefono"]);
    	$correo = trim($form["txt_correo"]);

    	$error_msj = "";
    	if(isset($form["rbtn_persona"])){
    		if($form["rbtn_persona"] == 'PF'){//PERSONA FISICA
    			if(empty($nombre))
    				$error_msj = "Nombre no puede ir vacío o llevar 0";
    			elseif(empty($rfc_pf))
    				$error_msj = "RFC no puede ir vacío o llevar 0";
    		}
    		elseif($form["rbtn_persona"] == 'PM'){//PERSONA MORAL PM
    			if(empty($razon_social))
    				$error_msj = "Razón Social no puede ir vacío o llevar 0";
    			elseif(empty($rfc_pm))
    				$error_msj = "RFC no puede ir vacío o llevar 0";
    			elseif(empty($contacto))
    				$error_msj = "Contacto no puede ir vacío o llevar 0";
    		}
    		if(empty($error_msj)){//CONTINUAMOS CON LA VALIDACION DE DATOS PERSONALES
	    		if(empty($calle))
	    			$error_msj = "Calle no puede ir vacío o llevar 0";
	    		elseif(empty($num_int))
	    			$error_msj = "N° Int no puede ir vacío o llevar 0";
	    		elseif(empty($num_ext))
	    			$error_msj = "N° Ext no puede ir vacío o llevar 0";
	    		elseif(empty($cp))
	    			$error_msj = "C.P. no puede ir vacío o llevar 0";
	    		elseif(empty($colonia))
	    			$error_msj = "Colonia no puede ir vacío o llevar 0";
	    		elseif(empty($localidad))
	    			$error_msj = "Localidad no puede ir vacío o llevar 0";
	    		elseif(empty($municipio))
	    			$error_msj = "Municipio no puede ir vacío o llevar 0";
	    		elseif(empty($ciudad))
	    			$error_msj = "Ciudad no puede ir vacío o llevar 0";
	    		elseif(empty($estado))
	    			$error_msj = "Estado no puede ir vacío o llevar 0";
	    		elseif(empty($pais))
	    			$error_msj = "País no puede ir vacío o llevar 0";
	    		elseif(empty($telefono))
	    			$error_msj = "Teléfono no puede ir vacío o llevar 0";
	    		elseif(empty($correo))
	    			$error_msj = "Correo no puede ir vacío o llevar 0";
	    	}
	    	if(empty($error_msj)){//CONTINUAMOS CON INVENTARIO DEL CLIENTE
	    		if($form["h_num_ic"] != 0){//SI TIENE ALGÚN INVENTARIO
	    			for($i = 1; $i <= $form["h_num_ic"]; $i++){
	    				$descripcion_ic = trim($form["txt_descripcion_ic".$i]);
	    				$cantidad_ic = trim($form["txt_cantidad_ic".$i]);
	    				$fecha_adq = trim($form["txt_fecha_adq".$i]);
	    				if(empty($descripcion_ic)){
			    			$error_msj = "Descripción del INVENTARIO CLIENTE no puede ir vacío o llevar 0";
			    			break;
			    		}
			    		elseif(empty($cantidad_ic)){
			    			$error_msj = "Cantidad del INVENTARIO CLIENTE no puede ir vacío o llevar 0";
			    			break;
			    		}
			    		elseif(empty($fecha_adq)){
			    			$error_msj = "Fecha de Adquisición del INVENTARIO CLIENTE no puede ir vacío o llevar 0";
			    			break;
			    		}
	    			}
	    		}
	    	}
	    	if(empty($error_msj)){//CONTINUAMOS CON EQUIPO SOLICITADO
				if($form["h_num_es"] != 0){//SI TIENE ALGÚN EQUIPO SOLICITADO
					for($i = 1; $i <= $form["h_num_es"]; $i++){
						if($form["fk_cat_tipo_articulo".$i] == 'Seleccione' || $form["fk_gpo_catalogo".$i] == 'Seleccione' || $form["fk_subgpo_catalogo".$i] == 'Seleccione' || $form["fk_cat_marca".$i] == 'Seleccione' || $form["fk_cat_modelo".$i] == 'Seleccione'){
							$error_msj = "Es necesario seleccionar, por lo menos, un EQUIPO SOLICITADO";
							break;
						}
					}
				}
	    	}
			if(empty($error_msj)){//CONTINUAMOS CON REFACCION
				if($form["h_num_re"] != 0){//SI TIENE ALGÚN REFACCION
					for($i = 1; $i <= $form["h_num_re"]; $i++){
						if($form["refaccionId".$i] == 'Seleccione'){
							$error_msj = "Es necesario seleccionar, por lo menos, una REFACCIÓN";
							break;
						}
					}
				}
	    	}
			if(empty($error_msj)){//CONTINUAMOS CON SERVICIOS
				if($form["h_num_se"] != 0){//SI TIENE ALGÚN SERVICIOS
					for($i = 1; $i <= $form["h_num_se"]; $i++){
						if($form["fk_servicio".$i] == 'Seleccione' || $form["fk_cat_modelo_ser".$i] == 'Seleccione'){
							$error_msj = "Es necesario seleccionar, por lo menos, una UNIDAD en SERVICIO";
							break;
						}
					}
				}
	    	}
	    	if(empty($error_msj)){//CONTINUAMOS CON LOCALIZACIONES ADICIONALES
	    		if($form["h_num_la"] != 0){//SI TIENE ALGUNA LOCALIZACION ADICIONAL
	    			for($i = 1; $i <= $form["h_num_la"]; $i++){
	    				$tipo = trim($form["txt_tipo".$i]);
	    				$descripcion_la = trim($form["txt_descripcion_la".$i]);
	    				$nombre = trim($form["txt_nombre".$i]);
	    				$relacion = trim($form["txt_relacion".$i]);
	    				if(empty($tipo)){
			    			$error_msj = "Tipo de LOCALIZACIONES ADICIONALES no puede ir vacío o llevar 0";
			    			break;
			    		}
			    		elseif(empty($descripcion_la)){
			    			$error_msj = "Descripción de LOCALIZACIONES ADICIONALES no puede ir vacío o llevar 0";
			    			break;
			    		}
			    		elseif(empty($nombre)){
			    			$error_msj = "Nombre de LOCALIZACIONES ADICIONALES no puede ir vacío o llevar 0";
			    			break;
			    		}
			    		elseif(empty($relacion)){
			    			$error_msj = "Relación de LOCALIZACIONES ADICIONALES no puede ir vacío o llevar 0";
			    			break;
			    		}
	    			}
	    		}
	    	}
	    	if(empty($error_msj)){//CONTINUAMOS CON INFORMACIÓN RELEVANTE
	    		//$servicio = ($form["h_num_se"] != 0) ? "SI" : "NO";
    			//$refaccion = ($form["h_num_re"] != 0) ? "SI" : "NO";
	    		$observaciones_pros = trim($form["obs_prospecto"]);
	    		$observaciones_pros = (empty($observaciones_pros)) ? "NINGUNA" : $observaciones_pros;
	    		$fk_cat_status_seguimiento = 1;
	    		$lugar = trim($form["txt_lugar"]);
	    		$observaciones_agenda = trim($form["observaciones_agenda"]);
	    		if($form["fk_cat_actividad"] == 'Seleccione' || $form["fk_cat_tipo_actividad"] == 'Seleccione')
			    	$error_msj = "Es necesario seleccionar una Actividad y Tipo actividad";
			    elseif($form["fk_cat_probabilidad_compra"] == 'Seleccione')
			    	$error_msj = "Es necesario seleccionar una Probabilidad de Compra";
			    elseif($form["fk_cat_condiciones_pago"] == 'Seleccione')
			    	$error_msj = "Es necesario seleccionar una Condicion de Pago";
			    elseif($form["fk_cat_plazo_pago"] == 'Seleccione')
			    	$error_msj = "Es necesario seleccionar un Plazo Pago";
			    elseif($form["fk_cat_actividad_status_seguimiento"] == 'Seleccione')
			    	$error_msj = "Es necesario seleccionar una Actividad de Seguimiento";
			    elseif(empty($form["txt_fecha_actividad"]))
			    	$error_msj = "Es necesario seleccionar una Fecha de Actividad";
			    elseif(empty($lugar))
			    	$error_msj = "Lugar no puede ir vacío o llevar 0";
			    elseif(empty($observaciones_agenda))
			    	$error_msj = "Observaciones de Actividad no puede ir vacío o llevar 0";
	    	}
    	}
    	else
    		$error_msj = "Selecciona Persona Moral o Física";
    	if(!empty($error_msj)){//Si existe algún error, entrará aquí
    		$respuesta->assign("div_msj","innerHTML",empty_msg($error_msj));
    		$respuesta->script("$('#btn_guardar').attr('disabled',false);");
    	}
    	else{
    		//VALIDAMOS EL RFC QUE NO EXISTA (SI NO TIENE, DEJAR PASAR VENTAS PUBLICO RFC)

    		//EMPEZAMOS A HACER LAS INSERCIONES A LAS TABLAS CORRESPONDIENTES
    		$registro = array(
				"calle" => $calle,
				"num_int" => $num_int,
				"num_ext" => $num_ext,
				"cp" => $cp,
				"colonia" => $colonia,
				"localidad" => $localidad,
				"municipio" => $municipio,
				"ciudad" => $ciudad,
				"estado" => $estado,
				"pais" => $pais,
				"telefono" => $telefono,
				"correo" => $correo
			);
			//primero insertamos en cat_general para que regrese el pk insertado
			$pk_cat_generales = $this->mn->insert_cat_general($registro);
			//despues guardamos en la tabla de prospecto
			$registro = array(
				"nombre" => (empty($nombre)) ? '----------' : $nombre,
				"razon_social" => (empty($razon_social)) ? '----------' : $razon_social,
				"rfc" => (empty($rfc_pf)) ? $rfc_pm : $rfc_pf,
				"contacto" => (empty($contacto)) ? '----------' : $contacto,
				"fk_cat_generales" => $pk_cat_generales
			);
			$pk_prospecto = $this->mn->insert_prospecto($registro);
			//despues guardamos en la tabla de flotilla_actual
			if($form["h_num_ic"] != 0){//SI TIENE ALGÚN INVENTARIO
    			for($i = 1; $i <= $form["h_num_ic"]; $i++){
    				$descripcion_ic = trim($form["txt_descripcion_ic".$i]);
    				$cantidad_ic = trim($form["txt_cantidad_ic".$i]);
    				$fecha_adq = trim($form["txt_fecha_adq".$i]);
    				//insertamos
    				$registro = array(
						"fecha_adquisicion" => $fecha_adq,
						"descripcion" => $descripcion_ic,
						"cantidad" => $cantidad_ic,
						"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo
					);
		    		$this->mn->insert($registro,"flotilla_actual");
    			}
    		}
    		//despues guardamos en la tabla de equipo_solicitado
			if($form["h_num_es"] != 0){//SI TIENE ALGÚN EQUIPO SOLICITADO
				//Validar si el articulo maestro es igual al que tenemos. si es dif, asignar al gerente correspondiente
				$info = "";
				if((get_instance()->session->userdata('articulo_maestro') != 'unidad'))
					$info = $this->mn->obtener_gerente_articulo_maestro('unidad');
				$fk_cat_personal = (empty($info)) ? get_instance()->session->userdata('pk_cat_personal') : $info->pk_cat_personal;
				//despues guardamos en la tabla u_prospecto_ciclo
				$registro = array(
					"observaciones" => $observaciones_pros,
					"servicio" => "NO",
					"refacciones" => "NO",
					"articulo_maestro" => "unidad",
					"fk_prospecto" => $pk_prospecto,
					"fk_cat_tipo_actividad" => $form["fk_cat_tipo_actividad"],
					"fk_cat_probabilidad_compra" => $form["fk_cat_probabilidad_compra"],
					"fk_cat_condiciones_pago" => $form["fk_cat_condiciones_pago"],
					"fk_cat_plazo_pago" => $form["fk_cat_plazo_pago"],
					"fk_cat_personal" => $fk_cat_personal
				);
				$pk_u_prospecto_ciclo = $this->mn->insert_u_prospecto_ciclo($registro);
				for($i = 1; $i <= $form["h_num_es"]; $i++){
					//insertamos
					$registro = array(
						"fk_cat_modelo" => $form["fk_cat_modelo".$i],
						"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo
					);
					$this->mn->insert($registro,"equipo_solicitado");
				}
				//Generamos actividad automática de alta
				$this->load->helper('date');
				//OBTENEMOS LA HORA EXACTA SETEANDO LA VARIABLE DATE_DEFAULT_TIMEZONE_SET
				date_default_timezone_set("America/Mexico_City");
				$registro = array(
					"fecha_actividad" => date("Y-m-d H:i:s"),
					"lugar" => '-- GENERADO AUTOMÁTICAMENTE --',
					"observaciones" => "Alta de Prospecto",
					"realizada" => 'SI',
					"fecha_realizada" => date("Y-m-d H:i:s"),
					"articulo_maestro" => 'unidad',
					"fk_cat_status_seguimiento" => $fk_cat_status_seguimiento,
					"fk_cat_actividad_status_seguimiento" => 1,
					"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo,
					"fk_cat_personal" => $fk_cat_personal
				);
				$this->mn->insert($registro,"agenda");
				//despues guardamos en la tabla de agenda
				$registro = array(
					"fecha_actividad" => $form["txt_fecha_actividad"],
					"lugar" => $lugar,
					"observaciones" => $observaciones_agenda,
					"articulo_maestro" => 'unidad',
					"fk_cat_status_seguimiento" => $fk_cat_status_seguimiento,
					"fk_cat_actividad_status_seguimiento" => $form["fk_cat_actividad_status_seguimiento"],
					"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo,
					"fk_cat_personal" => $fk_cat_personal
				);
				$this->mn->insert($registro,"agenda");
			}
			//despues guardamos en la tabla de refaccion_solicitada
			if($form["h_num_re"] != 0){//SI TIENE ALGÚNA REFACCION SOLICITADA
				//Validar si el articulo maestro es igual al que tenemos. si es dif, asignar al gerente correspondiente
				$info = "";
				if((get_instance()->session->userdata('articulo_maestro') != 'refaccion'))
					$info = $this->mn->obtener_gerente_articulo_maestro('refaccion');
				$fk_cat_personal = (empty($info)) ? get_instance()->session->userdata('pk_cat_personal') : $info->pk_cat_personal;
				//despues guardamos en la tabla u_prospecto_ciclo
				$registro = array(
					"observaciones" => $observaciones_pros,
					"servicio" => "NO",
					"refacciones" => "SI",
					"articulo_maestro" => "refaccion",
					"fk_prospecto" => $pk_prospecto,
					"fk_cat_tipo_actividad" => $form["fk_cat_tipo_actividad"],
					"fk_cat_probabilidad_compra" => $form["fk_cat_probabilidad_compra"],
					"fk_cat_condiciones_pago" => $form["fk_cat_condiciones_pago"],
					"fk_cat_plazo_pago" => $form["fk_cat_plazo_pago"],
					"fk_cat_personal" => $fk_cat_personal
				);
				$pk_u_prospecto_ciclo = $this->mn->insert_u_prospecto_ciclo($registro);
				for($i = 1; $i <= $form["h_num_re"]; $i++){
					//insertamos
					$refaccion = explode("|",$form["refaccionId".$i]);
					$registro = array(
						"codigo" => $refaccion[0],
						"descripcion_trabajo" => $refaccion[1],
						"numero_parte" => $refaccion[2],
						"descripcion_parte" => $refaccion[3],
						"capacidad" => 0,//PENDIENTE REVISAR si se va a utilizar
						"tipo_fluido" => "N/A",//PENDIENTE REVISAR si se va a utilizar
						"cantidad" => 1,
						"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo
					);
					$this->mn->insert($registro,"refaccion_solicitada");
				}
				//Generamos actividad automática de alta
				$this->load->helper('date');
				//OBTENEMOS LA HORA EXACTA SETEANDO LA VARIABLE DATE_DEFAULT_TIMEZONE_SET
				date_default_timezone_set("America/Mexico_City");
				$registro = array(
					"fecha_actividad" => date("Y-m-d H:i:s"),
					"lugar" => '-- GENERADO AUTOMÁTICAMENTE --',
					"observaciones" => "Alta de Prospecto",
					"realizada" => 'SI',
					"fecha_realizada" => date("Y-m-d H:i:s"),
					"articulo_maestro" => 'refaccion',
					"fk_cat_status_seguimiento" => $fk_cat_status_seguimiento,
					"fk_cat_actividad_status_seguimiento" => 1,
					"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo,
					"fk_cat_personal" => $fk_cat_personal
				);
				$this->mn->insert($registro,"agenda");
				//despues guardamos en la tabla de agenda
				$registro = array(
					"fecha_actividad" => $form["txt_fecha_actividad"],
					"lugar" => $lugar,
					"observaciones" => $observaciones_agenda,
					"articulo_maestro" => 'refaccion',
					"fk_cat_status_seguimiento" => $fk_cat_status_seguimiento,
					"fk_cat_actividad_status_seguimiento" => $form["fk_cat_actividad_status_seguimiento"],
					"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo,
					"fk_cat_personal" => $fk_cat_personal
				);
				$this->mn->insert($registro,"agenda");
			}
			//despues guardamos en la tabla de servicio_solicitada
			if($form["h_num_se"] != 0){//SI TIENE ALGÚN SERVICIO SOLICITADO
				//Validar si el articulo maestro es igual al que tenemos. si es dif, asignar al gerente correspondiente
				$info = "";
				if((get_instance()->session->userdata('articulo_maestro') != 'servicio'))
					$info = $this->mn->obtener_gerente_articulo_maestro('servicio');
				$fk_cat_personal = (empty($info)) ? get_instance()->session->userdata('pk_cat_personal') : $info->pk_cat_personal;
				//despues guardamos en la tabla u_prospecto_ciclo
				$registro = array(
					"observaciones" => $observaciones_pros,
					"servicio" => "SI",
					"refacciones" => "NO",
					"articulo_maestro" => "servicio",
					"fk_prospecto" => $pk_prospecto,
					"fk_cat_tipo_actividad" => $form["fk_cat_tipo_actividad"],
					"fk_cat_probabilidad_compra" => $form["fk_cat_probabilidad_compra"],
					"fk_cat_condiciones_pago" => $form["fk_cat_condiciones_pago"],
					"fk_cat_plazo_pago" => $form["fk_cat_plazo_pago"],
					"fk_cat_personal" => $fk_cat_personal
				);
				$pk_u_prospecto_ciclo = $this->mn->insert_u_prospecto_ciclo($registro);
				for($i = 1; $i <= $form["h_num_se"]; $i++){
					//consultamos los datos a insertar
					$datos = $this->mn->detalle_unidad_plantilla($form["fk_cat_modelo_ser".$i],$form["fk_servicio".$i]);
					foreach($datos as $value){
						$registro = array(
							"codigo" => $value->codigo,
							"descripcion_trabajo" => $value->descripcion_trabajo,
							"numero_parte" => $value->numero_parte,
							"descripcion_parte" => $value->descripcion_parte,
							"capacidad" => $value->capacidad,
							"tipo_fluido" => $value->tipo_fluido,
							"cantidad" => $value->cantidad,
							"horas" => $value->horas,
							"fk_cat_modelo" => $form["fk_cat_modelo_ser".$i],
							"fk_servicio" => $form["fk_servicio".$i],
							"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo
						);
						$this->mn->insert($registro,"servicio_solicitada");
					}
				}
				//Generamos actividad automática de alta
				$this->load->helper('date');
				//OBTENEMOS LA HORA EXACTA SETEANDO LA VARIABLE DATE_DEFAULT_TIMEZONE_SET
				date_default_timezone_set("America/Mexico_City");
				$registro = array(
					"fecha_actividad" => date("Y-m-d H:i:s"),
					"lugar" => '-- GENERADO AUTOMÁTICAMENTE --',
					"observaciones" => "Alta de Prospecto",
					"realizada" => 'SI',
					"fecha_realizada" => date("Y-m-d H:i:s"),
					"articulo_maestro" => 'servicio',
					"fk_cat_status_seguimiento" => $fk_cat_status_seguimiento,
					"fk_cat_actividad_status_seguimiento" => 1,
					"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo,
					"fk_cat_personal" => $fk_cat_personal
				);
				$this->mn->insert($registro,"agenda");
				//despues guardamos en la tabla de agenda
				$registro = array(
					"fecha_actividad" => $form["txt_fecha_actividad"],
					"lugar" => $lugar,
					"observaciones" => $observaciones_agenda,
					"articulo_maestro" => 'servicio',
					"fk_cat_status_seguimiento" => $fk_cat_status_seguimiento,
					"fk_cat_actividad_status_seguimiento" => $form["fk_cat_actividad_status_seguimiento"],
					"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo,
					"fk_cat_personal" => $fk_cat_personal
				);
				$this->mn->insert($registro,"agenda");
			}
    		//despues guardamos en la tabla de localizacion_ad
    		if($form["h_num_la"] != 0){//SI TIENE ALGUNA LOCALIZACION ADICIONAL
    			for($i = 1; $i <= $form["h_num_la"]; $i++){
    				$tipo = trim($form["txt_tipo".$i]);
    				$descripcion_la = trim($form["txt_descripcion_la".$i]);
    				$nombre = trim($form["txt_nombre".$i]);
    				$relacion = trim($form["txt_relacion".$i]);
    				//insertamos
    				$registro = array(
						"tipo" => $tipo,
						"descripcion" => $descripcion_la,
						"nombre" => $nombre,
						"relacion" => $relacion,
						"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo
					);
		    		$this->mn->insert($registro,"localizacion_ad");	
    			}
    		}
			//revisamos si tiene anexos para mandar llamar a la funcion de subida si es necesario
			$bandera = FALSE;
			$anexos = $this->mn->cargar_cat_anexos();
	    	foreach ($anexos as $anexos) {
				//quitamos los caracteres especiales
				$descripcion = str_replace(".","",$anexos->descripcion);
				//quitamos los espacios para remplazarlos por "_"
				$descripcion = str_replace(" ","_",$descripcion);
				//quitamos las mayusculas
				$descripcion = strtolower($descripcion);
				for($j = 1; $j <= $anexos->cantidad; $j++){
					if(!empty($form[$descripcion."_".$j])){
						$respuesta->alert("A continuación, vamos a subir el(os) DOCUMENTO(S) DIGITAL(ES). Espere un momento.....");
						$respuesta->setReturnValue(TRUE);
						break;
					}
				}
			}
			$respuesta->setReturnValue(TRUE);
    	}
    	return $respuesta;
    }

    /*****************/

}