<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Postventa extends CI_Controller {
	
	//Constructor
	function __construct(){
		parent::__construct();

		$this->load->model("prospectos/Model_postventa","mpv");
		$this->load->helper("prospectos/my_xajax_postventa_helper");
		$this->load->library('prospectos/Postventa_lib');
		$this->load->library('upload');
		$this->load->helper('download');

		/*****Parametros para el correcto funcionamiento de XAJAX*****/
		//mostrar ventana de depuracion
		$this->xajax->configure('debug',FALSE);
		//Registro de funciones XAJAX
		$this->xajax->register(XAJAX_FUNCTION,array('buscar_prospecto',&$this,'buscar_prospecto'));
		$this->xajax->register(XAJAX_FUNCTION,array('mostrar_prospectos',&$this,'mostrar_prospectos'));
		$this->xajax->register(XAJAX_FUNCTION,array('update_actividad',&$this,'update_actividad'));
        $this->xajax->register(XAJAX_FUNCTION,array('guardar',&$this,'guardar'));
        $this->xajax->register(XAJAX_FUNCTION,array('reingreso',&$this,'reingreso'));
        $this->xajax->register(XAJAX_FUNCTION,array('cargar_tipo_actividad',&$this,'cargar_tipo_actividad'));
        $this->xajax->register(XAJAX_FUNCTION,array('guardar_reingreso',&$this,'guardar_reingreso'));
        //Para procesar las peticiones
        $this->xajax->processRequest();
        //mandamos el script a la pagina      
        $this->xajax->configure('javascript URI',base_url());  
        $this->data['xajax_js'] = $this->xajax->getJavascript(base_url());
	}
	
	public function index($param = ""){
		if(!empty($param)){
			if($param == 'ok')
				$this->data["script"] = "<script>alert('Archivos Subidos Satisfactoriamente');</script>";
			else
				$this->data["script"] = "<script>xajax_mostrar_prospectos('".$param."');</script>";
		}
		$this->data['contenido'] = 'prospectos/postventa/index';
		$this->data["prospectos"] = $this->mpv->cargar_prospecto(get_instance()->session->userdata('pk_cat_personal'));
		$this->load->view('template',$this->data);
	}

	public function descargar($prospecto_20,$nombre_archivo){
		$datos = file_get_contents(base_url("info/".$prospecto_20."/".$nombre_archivo."")); // Leer el contenido del archivo
		$nombre = $nombre_archivo;
		force_download($nombre, $datos);
	}

	public function upload(){
		$registro = $this->input->post();
		//si no existe el directorio lo crea
		$dir = "info/";
		if(!is_dir($dir))
			mkdir($dir,0777,true);
		//vemos si tiene nombre o rs
		$nombre = "";
		$nombre = (stripos($registro["txt_nombre"], '-') !== FALSE) ? $registro["txt_razon_social"] : $registro["txt_nombre"];
		//Quitamos los caracteres especiales
		$nombre = strtoupper($this->postventa_lib->normaliza($nombre));
		//Generamos carpetas por cada prospecto
		$directorio = $dir.$nombre."/";
		if(!is_dir($directorio))
			mkdir($directorio,0777,true);//true si se van a crear subcarpetas para habilitar la recursividad
		//vemos cuantos archivos subió el usuario.
		//vamos a obtener los datos de la bd y compararlos si son los mismos con las etiquetas HTML
		$anexos = $this->mpv->cargar_cat_anexos();
		foreach ($anexos as $anexos) {
			//quitamos los caracteres especiales
			$descripcion = str_replace(".","",$anexos->descripcion);
			//quitamos los espacios para remplazarlos por "_"
			$descripcion = str_replace(" ","_",$descripcion);
			//quitamos las mayusculas
			$descripcion = strtolower($descripcion);
			for($j = 1; $j <= $anexos->cantidad; $j++){
				$mi_archivo = $descripcion."_".$j;
		        $config['upload_path'] = $directorio;
		        $config['file_name'] = $nombre."_".$descripcion."_".$j;
		        $config['allowed_types'] = "jpg|jpeg|png";
		        $config['max_size'] = "0";//50000
		        $config['max_width'] = "0";//2000
		        $config['max_height'] = "0";//2000
		        $config['overwrite'] = TRUE;

				// Cargamos la configuración del archivo
            	$this->upload->initialize($config);

		        if(!$this->upload->do_upload($mi_archivo)){
		        	//print_r($this->upload->display_errors());
		        	//*** ocurrio un error
		            $data['uploadError'] = $this->upload->display_errors();
		            //echo $this->upload->display_errors();
		            continue;
		        }
			}
		}
		redirect('prospectos/postventa/index/ok');
	}

	/*FUNCIONES XAJAX*/

	public function buscar_prospecto($texto){
		$respuesta = new xajaxResponse();
		$respuesta->clear("div_show","innerHTML");
		$datos = $this->mpv->buscar_prospecto(get_instance()->session->userdata('pk_cat_personal'),$texto);
		$respuesta->assign("div_prospectos","innerHTML",mostrar_filtro_prospecto($datos));
		return $respuesta;
	}

	public function mostrar_prospectos($pk_u_prospecto_ciclo,$tab_historial = TRUE){
		$respuesta = new xajaxResponse();
		$datos = $this->mpv->v_info_prospecto($pk_u_prospecto_ciclo);
		$flotilla_actual = $this->mpv->flotilla_actual($pk_u_prospecto_ciclo);
		$equipo_solicitado = $this->mpv->equipo_solicitado($pk_u_prospecto_ciclo);
		$localizacion_ad = $this->mpv->localizacion_ad($pk_u_prospecto_ciclo);
		$anexos = $this->mpv->cargar_cat_anexos();
		$agenda = $this->mpv->agenda($pk_u_prospecto_ciclo);
		$status = $this->mpv->cargar_status();
		$actividad_status = $this->mpv->cargar_cat_actividad_status_seguimiento();
		//Obtenemos desde aquí el nombre del prospecto porque tenemos que quitarle los caracteres especiales si los tuviera
		//Quitamos los caracteres especiales
		$prospecto = strtoupper($this->postventa_lib->normaliza($datos->nombre));
		//equipo comprado
		$eq_comprado = $this->mpv->equipo_comprado($pk_u_prospecto_ciclo);
		$respuesta->assign("div_show","innerHTML",mostrar_info_prospectos($prospecto,$datos,$flotilla_actual,$equipo_solicitado,$localizacion_ad,$anexos,$agenda,$status,$actividad_status,$tab_historial,$eq_comprado));
		$respuesta->script("$(function () {
								$('#dt_fecha_actividad').datetimepicker({
										pickTime: false
									});
        						$('.chosen-select').chosen({width: '100%'});
							});");
		return $respuesta;
	}

	public function update_actividad($pk_agenda,$value,$pk_u_prospecto_ciclo,$bandera = FALSE,$observa = ""){
		$respuesta = new xajaxResponse();
		if(!$bandera){
			$respuesta->script("var observa = prompt(\"Escribe una observacion\");
								if(observa != null && observa != '')
									xajax_update_actividad('".$pk_agenda."','".$value."','".$pk_u_prospecto_ciclo."',true,observa);
								else
									alert('LAS OBSERVACIONES NO PUEDEN IR EN BLANCO...VERIFIQUE');");
		}
		else{
			$observa = trim($observa);
			if(!empty($observa)){
				$this->load->helper('date');
				//OBTENEMOS LA HORA EXACTA SETEANDO LA VARIABLE DATE_DEFAULT_TIMEZONE_SET
				date_default_timezone_set("America/Mexico_City");
				$registro = array(
					"realizada" => $value,
					"observaciones_realizada" => $observa,
					"fecha_realizada" => date("Y-m-d H:i:s"),
					"pk_agenda" => $pk_agenda
				);
				$this->mpv->update_agenda($registro);
				$respuesta->alert("Actividad Actualizada Satisfactoriamente");
				$bandera = FALSE;
				$respuesta->call("xajax_mostrar_prospectos('".$pk_u_prospecto_ciclo."','".$bandera."')");
			}
			else
				$respuesta->alert("LAS OBSERVACIONES NO PUEDEN IR EN BLANCO...VERIFIQUE");
		}
		return $respuesta;
	}

    public function guardar($form){
    	$respuesta = new xajaxResponse();
    	//print_r($form);
    	$error_msj = "";
	    $lugar = trim($form["txt_lugar"]);
	    $observaciones_agenda = trim($form["observaciones_agenda"]);
		if($form["fk_cat_actividad_status_seguimiento"] == 'Seleccione')
			$error_msj = "Es necesario seleccionar una Actividad";
		elseif(empty($form["txt_fecha_actividad"]))
		   	$error_msj = "Es necesario seleccionar una Fecha de Actividad";
		elseif(empty($lugar))
		   	$error_msj = "Lugar no puede ir vacío o llevar 0";
		elseif(empty($observaciones_agenda))
		   	$error_msj = "Observaciones no puede ir vacío o llevar 0";
    	if(!empty($error_msj))//Si existe algún error, entrará aquí
    		$respuesta->assign("div_msj","innerHTML",empty_msg($error_msj));
    	else{
    		// guardamos en la tabla de agenda
    		$registro = array(
				"fecha_actividad" => $form["txt_fecha_actividad"],
				"lugar" => $lugar,
				"observaciones" => $observaciones_agenda,
				"fk_cat_status_seguimiento" => '7',
				"fk_cat_actividad_status_seguimiento" => $form["fk_cat_actividad_status_seguimiento"],
				"fk_u_prospecto_ciclo" => $form["h_pk_u_prospecto_ciclo"],
				"fk_cat_personal" => (get_instance()->session->userdata('pk_cat_personal'))
			);
			$this->mpv->insert($registro,"agenda");
			$respuesta->alert("Actividad Guardada Satisfactoriamente");
			$bandera = TRUE;
			$respuesta->call("xajax_mostrar_prospectos('".$form["h_pk_u_prospecto_ciclo"]."','".$bandera."')");
    	}
    	return $respuesta;
    }

    public function reingreso($pk_prospecto){
    	$respuesta = new xajaxResponse();
    	$actividades = $this->mpv->cargar_actividades();
		$probabilidades_compra = $this->mpv->cargar_probabilidades_compra();
		$condiciones_pago = $this->mpv->cargar_condiciones_pago();
		$plazo_pago = $this->mpv->cargar_plazo_pago();
		$motivo_visita = $this->mpv->cargar_status();
		$actividad_status = $this->mpv->cargar_cat_actividad_status_seguimiento();
    	$respuesta->assign("div_modal","innerHTML",show_reingreso($pk_prospecto,$actividades,$probabilidades_compra,$condiciones_pago,$plazo_pago,$motivo_visita,$actividad_status));
    	$respuesta->script("$(function () {
								$('#dt_fecha_actividad_ri').datetimepicker({
										pickTime: false
									});
        						$('.chosen-select').chosen({width: '100%'});
							});");
    	return $respuesta;
    }

    public function cargar_tipo_actividad($pk_actividad){
    	$respuesta = new xajaxResponse();
    	$datos = $this->mpv->cargar_tipo_actividades($pk_actividad);
		$respuesta->assign("div_tipo_actividad","innerHTML",mostrar_tipo_actividades($datos,$pk_actividad));
		$respuesta->script("$(function () {
        						$('.chosen-select').chosen({width: '100%'});
							});");
		return $respuesta;
    }

    public function guardar_reingreso($pk_prospecto,$form){
    	$respuesta = new xajaxResponse();
    	//print_r($form);
    	$error_msj = "";
    	if(empty($error_msj)){//INFORMACIÓN RELEVANTE
	    	$servicio = (isset($form["ch_servicio"])) ? "SI" : "NO";
    		$refaccion = (isset($form["ch_refaccion"])) ? "SI" : "NO";
	    	$observaciones_pros = trim($form["obs_prospecto_ri"]);
	    	$observaciones_pros = (empty($observaciones_pros)) ? "NINGUNA" : $observaciones_pros;
	    	$fk_cat_status_seguimiento = 1;
	    	$lugar = trim($form["txt_lugar_ri"]);
	    	$observaciones_agenda = trim($form["observaciones_agenda_ri"]);
	    	if($form["fk_cat_actividad_ri"] == 'Seleccione' || $form["fk_cat_tipo_actividad_ri"] == 'Seleccione')
		    	$error_msj = "Es necesario seleccionar una Actividad y Tipo actividad";
		    elseif($form["fk_cat_probabilidad_compra_ri"] == 'Seleccione')
		    	$error_msj = "Es necesario seleccionar una Probabilidad de Compra";
		    elseif($form["fk_cat_condiciones_pago_ri"] == 'Seleccione')
		    	$error_msj = "Es necesario seleccionar una Condicion de Pago";
		    elseif($form["fk_cat_plazo_pago_ri"] == 'Seleccione')
		    	$error_msj = "Es necesario seleccionar un Plazo Pago";
		    elseif($form["fk_cat_actividad_status_seguimiento_ri"] == 'Seleccione')
		    	$error_msj = "Es necesario seleccionar una Actividad de Seguimiento";
		    elseif(empty($form["txt_fecha_actividad_ri"]))
		    	$error_msj = "Es necesario seleccionar una Fecha de Actividad";
		    elseif(empty($lugar))
		    	$error_msj = "Lugar no puede ir vacío o llevar 0";
		    elseif(empty($observaciones_agenda))
		    	$error_msj = "Observaciones de Actividad no puede ir vacío o llevar 0";
	    }
    	if(!empty($error_msj))//Si existe algún error, entrará aquí
    		$respuesta->assign("div_msj_ri","innerHTML",empty_msg($error_msj));
    	else{
    		//guardamos en la tabla u_prospecto_ciclo
			$registro = array(
				"observaciones" => $observaciones_pros,
				"servicio" => $servicio,
				"refacciones" => $refaccion,
				"fk_prospecto" => $pk_prospecto,
				"fk_cat_tipo_actividad" => $form["fk_cat_tipo_actividad_ri"],
				"fk_cat_probabilidad_compra" => $form["fk_cat_probabilidad_compra_ri"],
				"fk_cat_condiciones_pago" => $form["fk_cat_condiciones_pago_ri"],
				"fk_cat_plazo_pago" => $form["fk_cat_plazo_pago_ri"],
				"fk_cat_personal" => (get_instance()->session->userdata('pk_cat_personal'))
			);
			$pk_u_prospecto_ciclo = $this->mpv->insert_u_prospecto_ciclo($registro);
    		//despues guardamos en la tabla de agenda
    		$registro = array(
				"fecha_actividad" => $form["txt_fecha_actividad_ri"],
				"lugar" => $lugar,
				"observaciones" => $observaciones_agenda,
				"fk_cat_status_seguimiento" => $fk_cat_status_seguimiento,
				"fk_cat_actividad_status_seguimiento" => $form["fk_cat_actividad_status_seguimiento_ri"],
				"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo,
				"fk_cat_personal" => (get_instance()->session->userdata('pk_cat_personal'))
			);
			$this->mpv->insert($registro,"agenda");
			$respuesta->alert("Prospecto Reasignado Satisfactoriamente");
			$respuesta->redirect(base_url("/prospectos/postventa"));
    	}

    	return $respuesta;
    }

    /*****************/

}