<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Venta extends CI_Controller {
	
	//Constructor
	function __construct(){
		parent::__construct();

		$this->load->model("prospectos/Model_venta","mv");
		$this->load->helper("prospectos/my_xajax_venta_helper");
		//$this->load->library('prospectos/Venta_lib');

		/*****Parametros para el correcto funcionamiento de XAJAX*****/
		//mostrar ventana de depuracion
		$this->xajax->configure('debug',FALSE);
		//Registro de funciones XAJAX
		$this->xajax->register(XAJAX_FUNCTION,array('buscar_prospecto',&$this,'buscar_prospecto'));
		$this->xajax->register(XAJAX_FUNCTION,array('mostrar_prospectos',&$this,'mostrar_prospectos'));
		$this->xajax->register(XAJAX_FUNCTION,array('cambiar_cot',&$this,'cambiar_cot'));
		$this->xajax->register(XAJAX_FUNCTION,array('venta',&$this,'venta'));
        //Para procesar las peticiones
        $this->xajax->processRequest();
        //mandamos el script a la pagina      
        $this->xajax->configure('javascript URI',base_url());  
        $this->data['xajax_js'] = $this->xajax->getJavascript(base_url());
	}
	
	public function index(){
		$this->data['contenido'] = 'prospectos/venta/index';
		$this->data["prospectos"] = $this->mv->cargar_prospecto(get_instance()->session->userdata('pk_cat_personal'));
		$this->load->view('template',$this->data);
	}

	public function reimpresion($pk_u_prospecto_ciclo,$pk_cotizacion){
		//obtenemos los datos del prospecto, así como los equipos cotizados
		$prospecto = $this->mv->prospecto_impresion($pk_u_prospecto_ciclo);
		$cotizacion = $this->mv->obtener_cotizacion($pk_cotizacion);
		imprimir($prospecto,$cotizacion);
	}

	/*FUNCIONES XAJAX*/

	public function buscar_prospecto($texto){
		$respuesta = new xajaxResponse();
		$respuesta->clear("div_show","innerHTML");
		$datos = $this->mv->buscar_prospecto(get_instance()->session->userdata('pk_cat_personal'),$texto);
		$respuesta->assign("div_prospectos","innerHTML",mostrar_filtro_prospecto($datos));
		return $respuesta;
	}

	public function mostrar_prospectos($pk_u_prospecto_ciclo){
		$respuesta = new xajaxResponse();
		$cotizacion = $this->mv->cotizacion($pk_u_prospecto_ciclo);
		$respuesta->assign("div_show","innerHTML",mostrar_datos_cotizacion($cotizacion,$pk_u_prospecto_ciclo));
		$respuesta->script("$(document).ready(function () {
						        mostrarOpcionesTabla('dt_mostrar_datos_cotizacion',false,false,true);
						    });");
		return $respuesta;
	}

	public function cambiar_cot($pk_cotizacion,$tipo,$pk_u_prospecto_ciclo){
		$respuesta = new xajaxResponse();
		$registro = array(
			"pk_cotizacion" => $pk_cotizacion,
			"tipo" => $tipo
		);
		$this->mv->update_tipo_cot("pk_cotizacion","cotizacion",$registro);
		$respuesta->alert("Cotizacion Actualizada Satisfactoriamente");
		$respuesta->call("xajax_mostrar_prospectos('".$pk_u_prospecto_ciclo."')");
		return $respuesta;
	}

	public function venta($pk_cotizacion,$pk_u_prospecto_ciclo,$folio){
		$respuesta = new xajaxResponse();
		// guardamos en la tabla de venta
   		$registro = array(
			"fk_cotizacion" => $pk_cotizacion,
			"fk_cat_personal" => (get_instance()->session->userdata('pk_cat_personal')),
			"fk_cat_sucursal" => get_instance()->session->userdata('id'),
			"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo
		);
		$this->mv->insert($registro,"venta");
		// después, actualizamos en la tabla de cotizaciones
		$registro = array(
			"status" => 'N',
			"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo
		);
		$this->mv->update_status("fk_u_prospecto_ciclo","cotizacion",$registro);
		//después, actualizamos en la tabla de agenda para que no tenga actividad pendiente
		$this->load->helper('date');
		//OBTENEMOS LA HORA EXACTA SETEANDO LA VARIABLE DATE_DEFAULT_TIMEZONE_SET
		date_default_timezone_set("America/Mexico_City");
		$registro = array(
			"realizada" => "SI",
			"observaciones_realizada" => "-- ACTUALIZADA AUTOMATICAMENTE --",
			"fecha_realizada" => date("Y-m-d H:i:s"),
			"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo
		);
		$this->mv->update_status("fk_u_prospecto_ciclo","agenda",$registro,TRUE);
		//después, insertamos 2 actividades en la tabla de agenda
		$registro = array(
				"fecha_actividad" => date("Y-m-d H:i:s"),
				"lugar" => "-- PLANTA-- ",
				"observaciones" => "Venta Registrada con la cotizacion ".$folio."",
				"realizada" => "SI",
				"observaciones_realizada" => "-- ACTUALIZADA AUTOMATICAMENTE --",
				"fecha_realizada" => date("Y-m-d H:i:s"),
				"fk_cat_status_seguimiento" => '5',
				"fk_cat_actividad_status_seguimiento" => '4',
				"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo,
				"fk_cat_personal" => (get_instance()->session->userdata('pk_cat_personal'))
		);
		$this->mv->insert($registro,"agenda");
		$registro = array(
				"fecha_actividad" => date("Y-m-d H:i:s"),
				"lugar" => "-- PLANTA-- ",
				"observaciones" => "Llamada Telefónica al Cliente en 72 HRS",
				"fk_cat_status_seguimiento" => '7',
				"fk_cat_actividad_status_seguimiento" => '1',
				"fk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo,
				"fk_cat_personal" => (get_instance()->session->userdata('pk_cat_personal'))
		);
		$this->mv->insert($registro,"agenda");
		// después, actualizamos en la tabla de u_prospecto_ciclo
		$registro = array(
			"concluido" => 'SI',
			"fecha_fin" => date("Y-m-d H:i:s"),
			"pk_u_prospecto_ciclo" => $pk_u_prospecto_ciclo
		);
		$this->mv->update_status("pk_u_prospecto_ciclo","u_prospecto_ciclo",$registro);
		$respuesta->alert("Venta Registrada Satisfactoriamente");
		$respuesta->redirect(base_url("/prospectos/venta"));
		return $respuesta;
	}

    /*****************/

}