<?php 
error_reporting(0);
defined('BASEPATH') OR exit('No direct script access allowed');

class Analisis_Venta extends CI_Controller {
	
	//Constructor
	function __construct(){
		parent::__construct();

		$this->load->model("reportes/model_analisis_venta","mav");

		//$this->load->library('reportes/Analisis_venta_lib');

		$this->load->helper('reportes/my_xajax_analisis_venta');

		/*****Parametros para el correcto funcionamiento de XAJAX*****/
		//mostrar ventana de depuracion
		$this->xajax->configure('debug',FALSE);
		//Registro de funciones XAJAX
        $this->xajax->register(XAJAX_FUNCTION,array('cargar_info',&$this,'cargar_info'));
        //Para procesar las peticiones
        $this->xajax->processRequest();
        //mandamos el script a la pagina      
        $this->xajax->configure('javascript URI',base_url());  
        $this->data['xajax_js'] = $this->xajax->getJavascript(base_url());
	}
	
	public function index(){
		$this->data['contenido'] = 'reportes/analisis_venta/index';
		$this->data['sucursal'] = $this->mav->sucursal();
		$this->load->view('template',$this->data);
	}

	public function descargar(){
		$fk_cat_sucursal = $this->input->post("fk_cat_sucursal");
		$fecha_inicio = $this->input->post("txt_fecha_inicio");
		$fecha_fin = $this->input->post("txt_fecha_fin");
		$anio_i = explode("-", $fecha_inicio);
		//catálogo de artículo
		$cat_tipo_articulo = $this->mav->cat_tipo_articulo();
		//inicializamos
		$com_sql_ventas = "";
		$com_sql_prospecciones = "";
		$com_sql_cotizaciones = "";
		$com_sql_vta_perdidas = "";
		$com_sql_metas = "";
		//POR EJECUTIVOS
		$com_sql_eje_ventas = "";
		$com_sql_eje_prospecciones = "";
		$com_sql_eje_cotizaciones = "";
		$com_sql_eje_vta_perdidas = "";
		$com_sql_eje_metas = "";

		if($fk_cat_sucursal != '*'){
			$com_sql_ventas = " and v.fk_cat_sucursal='".$fk_cat_sucursal."'";
			$com_sql_prospecciones = " and cp.empleado_de='s_".$fk_cat_sucursal."'";
			$com_sql_cotizaciones = " and c.fk_cat_sucursal='".$fk_cat_sucursal."'";
			$com_sql_vta_perdidas = " and cp.empleado_de='s_".$fk_cat_sucursal."'";
			$com_sql_metas = " and u.fk_cat_sucursal='".$fk_cat_sucursal."'";
			//POR EJECUTIVOS
			$com_sql_eje_ventas = " and v.fk_cat_sucursal='".$fk_cat_sucursal."'";
			$com_sql_eje_prospecciones = " and cp.empleado_de='s_".$fk_cat_sucursal."'";
			$com_sql_eje_cotizaciones = " and c.fk_cat_sucursal='".$fk_cat_sucursal."'";
			$com_sql_eje_vta_perdidas = " and cp.empleado_de='s_".$fk_cat_sucursal."'";
			$com_sql_eje_metas = " and u.fk_cat_sucursal='".$fk_cat_sucursal."'";

		}
		//datos
		$ventas = $this->mav->ventas($fecha_inicio,$fecha_fin,$com_sql_ventas,TRUE);
		$prospecciones = $this->mav->prospecciones($fecha_inicio,$fecha_fin,$com_sql_prospecciones,TRUE);
		$cotizaciones = $this->mav->cotizaciones($fecha_inicio,$fecha_fin,$com_sql_cotizaciones,TRUE);
		$vta_perdidas = $this->mav->vta_perdidas($fecha_inicio,$fecha_fin,$com_sql_vta_perdidas,TRUE);
		//POR EJECUTIVOS
		$eje_ventas = $this->mav->eje_ventas($fecha_inicio,$fecha_fin,$com_sql_ventas,FALSE);
		$eje_prospecciones = $this->mav->eje_prospecciones($fecha_inicio,$fecha_fin,$com_sql_prospecciones,FALSE);
		$eje_cotizaciones = $this->mav->eje_cotizaciones($fecha_inicio,$fecha_fin,$com_sql_cotizaciones,FALSE);
		$eje_vta_perdidas = $this->mav->eje_vta_perdidas($fecha_inicio,$fecha_fin,$com_sql_vta_perdidas,FALSE);
		//metas
		$anio = $anio_i[0];
		$metas_ventas = $this->mav->metas_ventas($anio,$com_sql_metas);
		$metas_prospecciones = $this->mav->metas_prospecciones($anio,$com_sql_metas);
		$metas_cotizaciones = $this->mav->metas_cotizaciones($anio,$com_sql_metas);
		//primero creamos un array donde esten todos los artículos
		foreach ($cat_tipo_articulo as $dato) 
			$articulos[$dato->descripcion] = array();
		$a_metas_ventas = $articulos;
		$a_realizado_ventas = $articulos;
		$a_metas_cotizaciones = $articulos;
		$a_realizado_cotizaciones = $articulos;
		$a_realizado_vta_perdidas = $articulos;
		//CREAMOS UN ARRAY DE LOS EMPLEADOS DEPENDIENDO DE LA SUCURSAL
		$com_sql_eje = "";
		if($fk_cat_sucursal != '*')
			$com_sql_eje = " and empleado_de='s_".$fk_cat_sucursal."'";
		$empleados = $this->mav->ejecutivo($fk_cat_sucursal,$com_sql_eje);
		$detalle_ejecutivo = array();
		foreach ($empleados as $ejecutivo) 
			$detalle_ejecutivo[$ejecutivo->ejecutivo] = array();
		/************VENTAS************/
		//METAS
		//despues, dependiendo el articulo, lo vamos agregando al arreglo previamente creado
		foreach ($metas_ventas as $key)
			$a_metas_ventas[$key["articulo"]] += array(
				$key["mes"] => $key["tot"]
			);
		//REALIZADO
		//despues, dependiendo el articulo, lo vamos agregando al arreglo previamente creado
		foreach ($ventas as $key)
			$a_realizado_ventas[$key["tipo_articulo"]] += array(
				$key["mes"] => $key["tot"]
			);
		/*****************************/
		/************PROSPECCION************/
		$a_metas_prospecciones = array();
		$a_realizado_prospecciones = array();
		//METAS
		foreach ($metas_prospecciones as $key) 
			$a_metas_prospecciones[$key["mes"]] = $key["tot"];
		//REALIZADO
		foreach ($prospecciones as $key)
			$a_realizado_prospecciones[$key["mes"]] = $key["tot"];
		/*****************************/
		/************COTIZACIONES************/
		//METAS
		//despues, dependiendo el articulo, lo vamos agregando al arreglo previamente creado
		foreach ($metas_cotizaciones as $key)
			$a_metas_cotizaciones[$key["articulo"]] += array(
				$key["mes"] => $key["tot"]
			);
		//REALIZADO
		//despues, dependiendo el articulo, lo vamos agregando al arreglo previamente creado
		foreach ($cotizaciones as $key)
			$a_realizado_cotizaciones[$key["tipo_articulo"]] += array(
				$key["mes"] => $key["tot"]
			);
		/*****************************/
		/************VENTAS PERDIDAS************/
		//METAS
		//NO TIENE METAS
		//REALIZADO
		foreach ($vta_perdidas as $key)
			$a_realizado_vta_perdidas[$key["tipo_articulo"]] += array(
				$key["mes"] => $key["tot"]
			);
		/*****************************/
		/**********DETALLE EJECUTIVOS***********/
		foreach ($empleados as $ejecutivo) {
			foreach ($cat_tipo_articulo as $articulo) {
				$detalle_ejecutivo[$ejecutivo->ejecutivo] += array(
						$articulo->descripcion => array(
							"V" => array(),
							"C" => array(),
							"VP" => array()
						),
						"P" => array()
				);
			}
		}
		//VENTAS
		foreach ($eje_ventas as $value) {
			$detalle_ejecutivo[$value->ejecutivo][$value->tipo_articulo]["V"] = array(
				$value->mes => $value->tot
			);
		}
		//PROSPECCIONES
		foreach ($eje_prospecciones as $value) {
			$detalle_ejecutivo[$value->ejecutivo]["P"] += array(
				$value->mes => $value->tot
			);
		}
		//COTIZACIONES
		foreach ($eje_cotizaciones as $value) {
			$detalle_ejecutivo[$value->ejecutivo][$value->tipo_articulo]["C"] = array(
				$value->mes => $value->tot
			);
		}
		//VENTAS PERDIDAS
		foreach ($eje_vta_perdidas as $value) {
			$detalle_ejecutivo[$value->ejecutivo][$value->tipo_articulo]["VP"] = array(
				$value->mes => $value->tot
			);
		}

		/*******************************/
		descargar_excel($cat_tipo_articulo,$empleados,$a_metas_ventas,$a_realizado_ventas,$a_metas_prospecciones,$a_realizado_prospecciones,$a_metas_cotizaciones,$a_realizado_cotizaciones,$a_realizado_vta_perdidas,$detalle_ejecutivo);
		//print_r($detalle_ejecutivo);
	}

	/*FUNCIONES XAJAX*/

	public function cargar_info($form){
		$respuesta = new xajaxResponse();
		$fecha_inicio = $form["txt_fecha_inicio"];
		$fecha_fin = $form["txt_fecha_fin"];
		$anio_i = explode("-", $fecha_inicio);
		$anio_f = explode("-", $fecha_fin);
		if(empty($fecha_inicio) || empty($fecha_fin))
			$respuesta->assign("div_info","innerHTML",empty_msg("Selecciona Fecha inicio y Fecha fin"));
		elseif($anio_i[0] != $anio_f[0])
			$respuesta->assign("div_info","innerHTML",empty_msg("No puedes seleccionar fechas de diferentes años"));
		elseif($form["fk_cat_sucursal"] == 'Seleccione')
			$respuesta->assign("div_info","innerHTML",empty_msg("Seleccione una Sucursal"));
		else{
			//datos
			$fk_cat_sucursal = $form["fk_cat_sucursal"];
			if($fk_cat_sucursal != '*'){
				$com_sql_ventas = " and v.fk_cat_sucursal='".$fk_cat_sucursal."'";
				$com_sql_prospecciones = " and cp.empleado_de='s_".$fk_cat_sucursal."'";
				$com_sql_cotizaciones = " and c.fk_cat_sucursal='".$fk_cat_sucursal."'";
				$com_sql_vta_perdidas = " and cp.empleado_de='s_".$fk_cat_sucursal."'";
			}
			$ventas = $this->mav->ventas($fecha_inicio,$fecha_fin,$com_sql_ventas);
			$prospecciones = $this->mav->prospecciones($fecha_inicio,$fecha_fin,$com_sql_prospecciones);
			$cotizaciones = $this->mav->cotizaciones($fecha_inicio,$fecha_fin,$com_sql_cotizaciones);
			$vta_perdidas = $this->mav->vta_perdidas($fecha_inicio,$fecha_fin,$com_sql_vta_perdidas);
			$respuesta->assign("div_info","innerHTML",
				mostrar_info($ventas,$prospecciones,$cotizaciones,$vta_perdidas));
		}
		return $respuesta;
	}

	/*****************/

}