<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Control_Ejecutivos extends CI_Controller {
	
	//Constructor
	function __construct(){
		parent::__construct();

		$this->load->model("reportes/model_control_ejecutivos","mce");

		//$this->load->library('reportes/Control_ejecutivos_lib');

		$this->load->helper('reportes/my_xajax_control_ejecutivos');

		/*****Parametros para el correcto funcionamiento de XAJAX*****/
		//mostrar ventana de depuracion
		$this->xajax->configure('debug',FALSE);
		//Registro de funciones XAJAX
        $this->xajax->register(XAJAX_FUNCTION,array('cargar_ejecutivos',&$this,'cargar_ejecutivos'));
        $this->xajax->register(XAJAX_FUNCTION,array('cargar_prospectos',&$this,'cargar_prospectos'));
        $this->xajax->register(XAJAX_FUNCTION,array('filtrar',&$this,'filtrar'));
        //Para procesar las peticiones
        $this->xajax->processRequest();
        //mandamos el script a la pagina      
        $this->xajax->configure('javascript URI',base_url());  
        $this->data['xajax_js'] = $this->xajax->getJavascript(base_url());
	}
	
	public function index(){
		$this->data['contenido'] = 'reportes/control_ejecutivos/index';
		$this->data['sucursal'] = $this->mce->sucursal();
		$this->load->view('template',$this->data);
	}

	/*FUNCIONES XAJAX*/

	public function cargar_ejecutivos($fk_cat_sucursal){
		$respuesta = new xajaxResponse();
		$respuesta->clear("div_prospectos","innerHTML");
		$datos = $this->mce->ejecutivo($fk_cat_sucursal);
		$respuesta->assign("div_mostrar","innerHTML",mostrar_ejecutivos($datos));
		$respuesta->script("$(function () {
        						$('.chosen-select').chosen({width: '100%'});
							});");
		return $respuesta;
	}

	public function cargar_prospectos($fk_cat_personal){
		$respuesta = new xajaxResponse();
		$datos = $this->mce->prospectos($fk_cat_personal);
		$status = $this->mce->status();
		$actividad = $this->mce->actividad();
		$respuesta->assign("div_prospectos","innerHTML",mostrar_filtro($datos,$status,$actividad));
		$respuesta->script("$(function () {
								$('#dt_fecha_inicio').datetimepicker({
									pickTime: false
								});
							});
							$(function () {
								$('#dt_fecha_fin').datetimepicker({
									pickTime: false
								});
							});
							$('.chosen-select').chosen({width: '100%'});
							mostrarOpcionesTabla('dt_mostrar_prospectos',false,false,true);");
		return $respuesta;
	}

	public function filtrar($form){
		$respuesta = new xajaxResponse();
		$fecha_inicio = $form["txt_fecha_inicio"];
		$fecha_fin = $form["txt_fecha_fin"];
		$fk_cat_status_seguimiento = $form["fk_cat_status_seguimiento"];
		$fk_cat_actividad_status_seguimiento = $form["fk_cat_actividad_status_seguimiento"];
		$realizada = $form["rbtn_opc"];
		$bandera = true;
		if(!((empty($fecha_inicio) && empty($fecha_fin)) || (!empty($fecha_inicio) && !empty($fecha_fin)))){
			$respuesta->alert("No puedes seleccionar una fecha. Tienen que ser ambas o ninguna");
			$respuesta->clear("div_info","innerHTML");
		}
		else{
			$com_sql = "and a.realizada='".$realizada."' ";
			if(!empty($fecha_inicio) && !empty($fecha_fin))
				$com_sql.= "and a.fecha_actividad BETWEEN STR_TO_DATE('".$fecha_inicio." 00:00:00','%Y-%m-%d %H:%i:%s') and STR_TO_DATE('".$fecha_fin." 23:59:59','%Y-%m-%d %H:%i:%s') ";
			if($fk_cat_status_seguimiento != 'Seleccione')
				$com_sql.= " and a.fk_cat_status_seguimiento=".$fk_cat_status_seguimiento." ";
			if($fk_cat_actividad_status_seguimiento != 'Seleccione')
				$com_sql.= " and a.fk_cat_actividad_status_seguimiento=".$fk_cat_actividad_status_seguimiento;
			$datos = $this->mce->prospectos($form["fk_cat_personal"],$com_sql);
			$respuesta->assign("div_info","innerHTML",mostrar_prospectos($datos));
			$respuesta->script("$(document).ready(function () {
							        mostrarOpcionesTabla('dt_mostrar_prospectos',false,false,true);
							    });");
		}
		return $respuesta;
	}

	/*****************/

}