<?php
error_reporting(0);
defined('BASEPATH') OR exit('No direct script access allowed');

class Ventas_Perdidas extends CI_Controller {
	
	//Constructor
	function __construct(){
		parent::__construct();

		$this->load->model("reportes/model_ventas_perdidas","mvp");

		//$this->load->library('reportes/Ventas_perdidas_lib');

		$this->load->helper('reportes/my_xajax_ventas_perdidas');

		/*****Parametros para el correcto funcionamiento de XAJAX*****/
		//mostrar ventana de depuracion
		$this->xajax->configure('debug',FALSE);
		//Registro de funciones XAJAX
        $this->xajax->register(XAJAX_FUNCTION,array('cargar_info',&$this,'cargar_info'));
        //Para procesar las peticiones
        $this->xajax->processRequest();
        //mandamos el script a la pagina      
        $this->xajax->configure('javascript URI',base_url());  
        $this->data['xajax_js'] = $this->xajax->getJavascript(base_url());
	}
	
	public function index(){
		$this->data['contenido'] = 'reportes/ventas_perdidas/index';
		$this->data['sucursal'] = $this->mvp->sucursal();
		$this->load->view('template',$this->data);
	}

	/*FUNCIONES XAJAX*/

	public function cargar_info($fk_cat_sucursal){
		$respuesta = new xajaxResponse();
		if($fk_cat_sucursal != '*')
			$com_sql = " and cp.empleado_de='s_".$fk_cat_sucursal."'";
		$datos = $this->mvp->ventas_perdidas($fk_cat_sucursal,$com_sql);
		$respuesta->assign("div_info","innerHTML",mostrar_info($datos));
		$respuesta->script("$(document).ready(function () {
						        mostrarOpcionesTabla('dt_ventas_perdidas',false,false,true);
						    });");
		return $respuesta;
	}	

	/*****************/

}