<?php if ( ! defined('BASEPATH')) exit('No esta permitido el acceso directo');//impide el acceso directo a este script

if(!function_exists('mostrar_filtro_prospecto')){

	function mostrar_filtro_prospecto($datos){
		$vista = "";
		if(count($datos) != 0){
			foreach($datos as $value):
				if(stripos($value->nombre, '-') !== FALSE)
					$options[$value->pk_u_prospecto_ciclo] = $value->razon_social;
				else
					$options[$value->pk_u_prospecto_ciclo] = $value->nombre;
			endforeach;
			$vista = form_multiselect('fk_cat_prospecto',$options,set_value('fk_cat_prospecto'),'onclick="loading(\'div_show\');xajax_mostrar_prospectos(this.value);" required="required" class="form-control" style="width:50%"');
		}
		else
			$vista = empty_msg('No existen prospectos según la búsqueda');
		return $vista;
	}
}

if(!function_exists('mostrar_info_prospectos')){

	function mostrar_info_prospectos($prospecto,$datos,$flotilla_actual,$equipo_solicitado,$refaccion_solicitada,$servicio_solicitada,$localizacion_ad,$anexos,$agenda,$status,$actividad_status,$tab_historial){
		/******HISTORIAL**********/
		$historial = "";
		$act_pend = 0;
		$add_extras = "";
		foreach ($agenda as $registro):
			$historial.= "<tr ".(($registro->realizada == 'NO') ? "class='table-warning'" : "class='table-info'").">
							<td>".$registro->fecha."</td>
							<td>".$registro->status_actividad."</td>
							<td>".$registro->actividad."</td>
							<td>".$registro->fecha_actividad."</td>
							<td>".$registro->lugar."</td>
							<td>".$registro->observaciones."</td>
							<td>".$registro->realizada."</td>
							<td>".$registro->observaciones_realizada."</td>
							<td>".$registro->fecha_realizada."</td>
							<td>".$registro->articulo_maestro."</td>
							<td>".(($registro->realizada == 'NO') ? 
								form_button(array('type' => 'button','value' => 'SI','content' => 'REALIZADA','class' => 'btn-xs btn btn-success','onclick' => 'if(confirm(\'¿Está Seguro?\')) xajax_update_actividad(\''.$registro->pk_agenda.'\',this.value,\''.$datos->pk_u_prospecto_ciclo.'\');')) : 
								form_button(array('type' => 'button','content' => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-bookmark-check-fill" viewBox="0 0 16 16">
									  <path fill-rule="evenodd" d="M2 15.5V2a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v13.5a.5.5 0 0 1-.74.439L8 13.069l-5.26 2.87A.5.5 0 0 1 2 15.5zm8.854-9.646a.5.5 0 0 0-.708-.708L7.5 7.793 6.354 6.646a.5.5 0 1 0-.708.708l1.5 1.5a.5.5 0 0 0 .708 0l3-3z"/>
									</svg>','class' => 'btn-xs btn btn-success')))."</td>
						</tr>";
			if($registro->realizada == 'NO')
				$act_pend++;
		endforeach;
		/*****INVENTARIO CLIENTE*****/
		$datos_flotilla = "";
		if(count($flotilla_actual) != 0){
			foreach($flotilla_actual as $registro):
				$datos_flotilla.= "<div class='form-group row'>
					    			".form_label('Descripción: ','',array('class' => 'col-sm-1 control-label'))."
									<div class='col-sm-4'>
										".form_input(array('class' => 'form-control','type' => 'text','value' => $registro->descripcion))."
									</div>
									".form_label('Cantidad: ','',array('class' => 'col-sm-1 control-label'))."
									<div class='col-sm-1'>
										".form_input(array('class' => 'form-control','type' => 'text','value' => $registro->cantidad))."
									</div>
					    			".form_label('Fecha Adquisición: ','',array('class' => 'col-sm-2 control-label'))."
									<div class='col-sm-3'>									
										".form_input(array('class' => 'form-control','type' => 'text','value' => $registro->fecha_adquisicion))."
									</div>
								</div>";
			endforeach;
		}
		else
			$datos_flotilla = empty_msg("El prospecto no cuenta con flotilla actual");
		/*****EQUIPO SOLICITADO****/
		$datos_eq_sol = "";
		if(count($equipo_solicitado) != 0){
			foreach($equipo_solicitado as $registro):
				$datos_eq_sol.= "<div class='form-group row'>
									".form_label('Equipo: ','',array('class' => 'col-sm-1 control-label'))."
									<div class='col-sm-8'>
										".form_input(array('class' => 'form-control','type' => 'text','value' => $registro->equipo))."
									</div>
									".form_label('Cantidad: ','',array('class' => 'col-sm-1 control-label'))."
									<div class='col-sm-2'>
										".form_input(array('class' => 'form-control','type' => 'text','value' => $registro->cantidad))."
									</div>
								</div>";
			endforeach;
		}
		else{
			$datos_eq_sol = empty_msg("El prospecto no requiere UNIDAD");
			$add_extras.= anchor('#','<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-plus-fill" viewBox="0 0 16 16"><path d="M9.293 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.707A1 1 0 0 0 13.707 4L10 .293A1 1 0 0 0 9.293 0zM9.5 3.5v-2l3 3h-2a1 1 0 0 1-1-1zM8.5 7v1.5H10a.5.5 0 0 1 0 1H8.5V11a.5.5 0 0 1-1 0V9.5H6a.5.5 0 0 1 0-1h1.5V7a.5.5 0 0 1 1 0z"/></svg> Equipo / Implemento','onclick="loading_small(\'div_modal\');xajax_add(\''.$datos->pk_prospecto.'\');" data-toggle="modal" data-target="#myModal"')."<br /><br />";
		}
		/*****REFACCION SOLICITADA****/
		$datos_re_sol = "";
		if(count($refaccion_solicitada) != 0){
			$datos_re_sol = "<table class='table table-bordered table-hover table-condensed' id='dt_refaccion'>
								<thead>
									<tr>
										<th>Código</th>
										<th>Descripción Trabajo</th>
										<th>N° Parte</th>
										<th>Descripción Parte</th>
										<th>Capacidad (litros)</th>
										<th>Tipo Fluido</th>
										<th>QT (cantidad)</th>
									</tr>
								</thead>
								<tbody>";
			foreach($refaccion_solicitada as $registro):
				$datos_re_sol.= "<tr ".(($registro->status == 'A') ? "class='table-success'" : "class='table-danger'")." align='center'>
									<td>".$registro->codigo."</td>
									<td>".$registro->descripcion_trabajo."</td>
									<td>".$registro->numero_parte."</td>
									<td>".$registro->descripcion_parte."</td>
									<td>".$registro->capacidad."</td>
									<td>".$registro->tipo_fluido."</td>
									<td>".$registro->cantidad."</td>
								</tr>";
			endforeach;
			$datos_re_sol.= "</tbody></table>";
		}
		else{
			$datos_re_sol = empty_msg("El prospecto no requiere REFACCIÓN");
			$add_extras.= anchor('#','<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-plus-fill" viewBox="0 0 16 16"><path d="M9.293 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.707A1 1 0 0 0 13.707 4L10 .293A1 1 0 0 0 9.293 0zM9.5 3.5v-2l3 3h-2a1 1 0 0 1-1-1zM8.5 7v1.5H10a.5.5 0 0 1 0 1H8.5V11a.5.5 0 0 1-1 0V9.5H6a.5.5 0 0 1 0-1h1.5V7a.5.5 0 0 1 1 0z"/></svg> Refacción','onclick="loading_small(\'div_modal\');xajax_add_re(\''.$datos->pk_prospecto.'\');" data-toggle="modal" data-target="#myModal"')."<br /><br />";
		}
		/*****SERVICIO SOLICITADA****/
		$datos_se_sol = "";
		if(count($servicio_solicitada) != 0){
			$datos_se_sol = "<table class='table table-bordered table-hover table-condensed' id='dt_servicio'>
								<thead>
									<tr>
										<th>Servicio</th>
										<th>Código</th>
										<th>Descripción Trabajo</th>
										<th>N° Parte</th>
										<th>Descripción Parte</th>
										<th>Capacidad (litros)</th>
										<th>Tipo Fluido</th>
										<th>QT (cantidad)</th>
										<th>Horas</th>
										<th>Unidad</th>
									</tr>
								</thead>
								<tbody>";
			foreach($servicio_solicitada as $registro):
				$datos_se_sol.= "<tr ".(($registro->status == 'A') ? "class='table-success'" : "class='table-danger'")." align='center'>
									<td>".$registro->servicio."</td>
									<td>".$registro->codigo."</td>
									<td>".$registro->descripcion_trabajo."</td>
									<td>".$registro->numero_parte."</td>
									<td>".$registro->descripcion_parte."</td>
									<td>".$registro->capacidad."</td>
									<td>".$registro->tipo_fluido."</td>
									<td>".$registro->cantidad."</td>
									<td>".$registro->horas."</td>
									<td>".$registro->unidad."</td>
								</tr>";
			endforeach;
			$datos_se_sol.= "</tbody></table>";
		}
		else{
			$datos_se_sol = empty_msg("El prospecto no requiere SERVICIO");
			$add_extras.= anchor('#','<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-plus-fill" viewBox="0 0 16 16"><path d="M9.293 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.707A1 1 0 0 0 13.707 4L10 .293A1 1 0 0 0 9.293 0zM9.5 3.5v-2l3 3h-2a1 1 0 0 1-1-1zM8.5 7v1.5H10a.5.5 0 0 1 0 1H8.5V11a.5.5 0 0 1-1 0V9.5H6a.5.5 0 0 1 0-1h1.5V7a.5.5 0 0 1 1 0z"/></svg> Servicio','onclick="loading_small(\'div_modal\');xajax_add_se(\''.$datos->pk_prospecto.'\');" data-toggle="modal" data-target="#myModal"');
		}
		/*****LOCALIZACION ADICIONAL****/
		$datos_localiza = "";
		if(count($localizacion_ad) != 0){
			foreach($localizacion_ad as $registro):
				$datos_localiza.= "<center>
									<div class='form-group row'>
										<div class='col-sm-3'>
											".form_label('Tipo:')."
											".form_input(array('class' => 'form-control','type' => 'text','value' => $registro->tipo))."
										</div>
										<div class='col-sm-3'>
											".form_label('Descripción:')."
											".form_input(array('class' => 'form-control','type' => 'text','value' => $registro->descripcion))."
										</div>
										<div class='col-sm-3'>
											".form_label('Nombre:')."
											".form_input(array('class' => 'form-control','type' => 'text','value' => $registro->nombre))."
										</div>
										<div class='col-sm-3'>
											".form_label('Relación:')."
											".form_input(array('class' => 'form-control','type' => 'text','value' => $registro->relacion))."
										</div>
									</div>
							    	</center>";
			endforeach;
		}
		else
			$datos_localiza = empty_msg("El prospecto no cuenta con localizaciones adicionales");
		/*****DOCUEMNTOS DIGITALES****/
		$doc_dig = "<div class='form-group row'>";
		$mostrar_dig = "<div class='form-group row'>";
		foreach ($anexos as $anexos) {
			//quitamos los caracteres especiales
			$descripcion = str_replace(".","",$anexos->descripcion);
			//quitamos los espacios para remplazarlos por "_"
			$descripcion = str_replace(" ","_",$descripcion);
			//quitamos las mayusculas
			$descripcion = strtolower($descripcion);
			for($j = 1; $j <= $anexos->cantidad; $j++){
				$doc_dig.= "<div class='col-sm-4'>
								".form_label(strtoupper($descripcion)." ".$j,'')."
								".form_upload($descripcion."_".$j)."
							</div>";
				//vemos si existe algún archivo para mostrarlo
				//primero obtenemos el nombre, despues lo convertimos a mayúscula
				$prospecto = strtoupper($prospecto);
				//quitamos los espacios para remplazarlos por "_"
				$prospecto_ = str_replace(" ","_",$prospecto);
				//ponemos el caracter %20 que indica un espacio en la URL
				$prospecto_20 = str_replace(" ","%20",$prospecto);
				//nombre fichero
				$nombre_archivo = $prospecto_."_".$descripcion."_".$j;
				//ruta del fichero
				$ruta_src = base_url("info/".$prospecto_20."/".$nombre_archivo);
				$ruta = "/home/soilabc/public_html/gao/info/".$prospecto."/".$nombre_archivo;
				$bandera_img = FALSE;

				if(file_exists($ruta.".jpg")){
					$ruta_src = $ruta_src.".jpg";
					$nombre_archivo = $nombre_archivo.".jpg";
					$bandera_img = TRUE;
				}
				elseif(file_exists($ruta.".JPG")){
					$ruta_src = $ruta_src.".JPG";
					$nombre_archivo = $nombre_archivo.".JPG";
					$bandera_img = TRUE;
				}
				elseif(file_exists($ruta.".jpeg") ){
					$ruta_src = $ruta_src.".jpeg";
					$nombre_archivo = $nombre_archivo.".jpeg";
					$bandera_img = TRUE;
				}
				elseif(file_exists($ruta.".JPEG") ){
					$ruta_src = $ruta_src.".JPEG";
					$nombre_archivo = $nombre_archivo.".JPEG";
					$bandera_img = TRUE;
				}
				elseif(file_exists($ruta.".png") ){
					$ruta_src = $ruta_src.".png";
					$nombre_archivo = $nombre_archivo.".png";
					$bandera_img = TRUE;
				}
				elseif(file_exists($ruta.".PNG") ){
					$ruta_src = $ruta_src.".PNG";
					$nombre_archivo = $nombre_archivo.".PNG";
					$bandera_img = TRUE;
				}
				if($bandera_img){
						$mostrar_dig.= "<div class='col-sm-3'>
											<div class='img-wrapper'>
												<img class='img-responsive' src='".$ruta_src."' alt='...' width='70%'>
												<div class='caption'>
													<h4>".$descripcion."_".$j."</h4>
													<a href='".base_url('prospectos/agenda/descargar/'.$prospecto_20.'/'.$nombre_archivo)."' class='btn btn-default' role='button'>Descargar</a>
												</div>
											</div>
										</div>";
				}
			}
		}
		$doc_dig.= "</div>";
		$mostrar_dig.= "</div>";
		/*****MOSTRAMOS LA INFO*****/
		$vista = "<ul id='myTabs' class='nav nav-tabs' role='tablist'>
					<li role='presentation' class='nav-item'><a href='#crear_act' id='crear_act-tab' role='tab' data-toggle='tab' aria-controls='crear_act' class='nav-link'>Crear Actividad de Seguimiento</a></li>
					<li role='presentation' class='nav-item'><a href='#historial_act' id='historial_act-tab' role='tab' data-toggle='tab' aria-controls='historial_act' class='nav-link active'>
							Historial de Actividades <span class='badge'>".((!empty($act_pend)) ? $act_pend : "" )."</span></a>
					</li>
					
				    <li class='nav-item dropdown'>
				    	<a href='#' id='datos_per' class='nav-link dropdown-toggle' data-toggle='dropdown' aria-controls='datos_per-contents'>Ver Datos del Prospecto <span class='caret'></span></a>
				        <div class='dropdown-menu' aria-labelledby='datos_per'>
				        	<a href='#info_per' class='dropdown-item' id='info_per-tab' data-toggle='tab' aria-controls='info_per'>Datos Personales</a>
				        	<a href='#info_rel' class='dropdown-item' id='info_rel-tab' data-toggle='tab' aria-controls='info_rel'>Información Relevante</a>
				        	<a href='#inv_cli' class='dropdown-item' id='inv_cli-tab' data-toggle='tab' aria-controls='inv_cli'>Inventario Cliente</a>
							<a href='#solicita' class='dropdown-item' id='solicita-tab' data-toggle='tab' aria-controls='solicita'>Equipo Solicitado</a>
							<a href='#refaccion' class='dropdown-item' id='refaccion-tab' data-toggle='tab' aria-controls='refaccion'>Refacción</a>
							<a href='#servicio' class='dropdown-item' id='servicio-tab' data-toggle='tab' aria-controls='servicio'>Servicio</a>
							<a href='#localizacion' class='dropdown-item' id='localizacion-tab' data-toggle='tab' aria-controls='localizacion'>Localizaciones Adicionales</a>
							<a href='#doc_dig' class='dropdown-item' id='doc_dig-tab' data-toggle='tab' aria-controls='doc_dig'>Documentación Digital</a>
				        </div>
					</li>
				</ul>
				<div id='myTabContent' class='tab-content'>
					<div role='tabpanel' class='tab-pane fade' id='crear_act' aria-labelledBy='crear_act-tab'>
						<p>
							".form_open('',array('class' => 'form-horizontal','role' => 'form','onsubmit' => 'return false;'))."
								<div class='form-group row'>
									".form_label('Status: ','',array('class' => 'col-sm-2 control-label'))."
									<div class='col-sm-4'>
										".combos($status,'pk_cat_status_seguimiento','descripcion','fk_cat_status_seguimiento','fk_cat_status_seguimiento','')."
									</div>
									".form_label('Actividad: ','',array('class' => 'col-sm-2 control-label'))."
									<div class='col-sm-4'>
										".combos($actividad_status,'pk_cat_actividad_status_seguimiento','descripcion','fk_cat_actividad_status_seguimiento','fk_cat_actividad_status_seguimiento','')."
									</div>
								</div>
								<div class='form-group row'>
									".form_label('Fecha Actividad: ','',array('class' => 'col-sm-2 control-label'))."
									<div class='col-sm-3'>
										<div class='input-group date' id='dt_fecha_actividad'>
											".form_input(array('class' => 'form-control','type' => 'text','name' => 'txt_fecha_actividad','id' => 'txt_fecha_actividad','required' => 'required','title' => 'Necesario Seleccionar una Fecha de Actividad','placeholder' => 'Nuevo Fecha de Actividad','data-format' => 'YYYY-MM-DD HH:mm:ss','readonly' => 'readonly'))."
											<span class='input-group-text'>
						                        <svg class='bi bi-calendar3-fill' width='1em' height='1em' viewBox='0 0 16 16' fill='currentColor' xmlns='http://www.w3.org/2000/svg'>
						                          <path d='M0 2a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2H0z'/>
						                          <path fill-rule='evenodd' d='M0 3h16v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3zm6.5 4a1 1 0 1 0 0-2 1 1 0 0 0 0 2zm4-1a1 1 0 1 1-2 0 1 1 0 0 1 2 0zm2 1a1 1 0 1 0 0-2 1 1 0 0 0 0 2zm-8 2a1 1 0 1 1-2 0 1 1 0 0 1 2 0zm2 1a1 1 0 1 0 0-2 1 1 0 0 0 0 2zm4-1a1 1 0 1 1-2 0 1 1 0 0 1 2 0zm2 1a1 1 0 1 0 0-2 1 1 0 0 0 0 2zm-8 2a1 1 0 1 1-2 0 1 1 0 0 1 2 0zm2 1a1 1 0 1 0 0-2 1 1 0 0 0 0 2zm4-1a1 1 0 1 1-2 0 1 1 0 0 1 2 0z'/>
						                        </svg>
						                    </span>
										</div>
									</div>
									".form_label('Lugar: ','',array('class' => 'col-sm-2 control-label'))."
									<div class='col-sm-5'>
										".form_input(array('class' => 'form-control','type' => 'text','name' => 'txt_lugar','id' => 'txt_lugar','required' => 'required','title' => 'Necesario Escribir un Lugar','placeholder' => 'Nuevo Lugar'))."
									</div>
							    </div>
							    <div class='form-group row'>
									<div class='col-sm-2'>
										".form_label('Observaciones: ','',array('class' => 'control-label'))."
									</div>
									<div class='col-sm-7'>
										".form_textarea(array('class' => 'form-control','type' => 'text','name' => 'observaciones_agenda','id' => 'observaciones_agenda','required' => 'required','placeholder' => 'Escribir observaciones de la actividad....','rows' => '2','cols'))."
									</div>
									<div class='col-sm-1'></div>
									<div class='col-sm-2'>
										".$add_extras."
									</div>
								</div>
							<center>
								<div id='div_msj'></div>
								".((!empty($act_pend)) ? empty_msg("No puedes agendar una actividad porque tienes activiades pendientes") : form_button(array('type' => 'button','content' => 'Guardar Actividad','class' => 'btn btn-primary','onclick' => 'xajax_guardar(xajax.getFormValues(\'frm_agenda\'))')) )."
							</center>
							".form_close()."
						</p>
				    </div>
				    <div role='tabpanel' class='tab-pane fade show active' id='historial_act' aria-labelledBy='historial_act-tab'>
						<p>
							<div class='grid'>
							<table class='table table-bordered table-hover table-condensed'>
								<thead>
									<tr>
										<th>Fecha Creación</th>
										<th>Status</th>
										<th>Actividad</th>
										<th>Fecha Actividad</th>
										<th>Lugar</th>
										<th>Observaciones</th>
										<th>Realizada</th>
										<th>Observaciones Realizada</th>
										<th>Fecha Realizada</th>
										<th>Artículo</th>
										<th>Actualizar Actividad</th>
									</tr>
								</thead>
								<tbody>
									".$historial."
								</tbody>
							</table>
							</div>
						</p>
				    </div>
				    <div role='tabpanel' class='tab-pane fade' id='info_per' aria-labelledBy='info_per-tab'>
				    	<p>
				    		<div class='form-group row' id='div_PF'>
								".form_label('Nombre: ','lbl_nombre',array('class' => 'col-sm-1 control-label'))."
								<div class='col-sm-5'>
									".form_input(array('class' => 'form-control','type' => 'text','name' => 'txt_nombre','id' => 'txt_nombre','value' => $datos->nombre))."
								</div>
								".form_label('RFC: ','lbl_rfc',array('class' => 'col-sm-1 control-label'))."
								<div class='col-sm-5'>
									".form_input(array('class' => 'form-control','type' => 'text','name' => 'txt_rfc','id' => 'txt_rfc','value' => $datos->rfc))."
								</div>
							</div>
							<div class='form-group row'>
								".form_label('Razón Social: ','lbl_rs',array('class' => 'col-sm-1 control-label'))."
								<div class='col-sm-5'>
									".form_input(array('class' => 'form-control','type' => 'text','name' => 'txt_razon_social','id' => 'txt_razon_social','value' => $datos->razon_social))."
								</div>
								".form_label('Contacto: ','lbl_contacto',array('class' => 'col-sm-1 control-label'))."
								<div class='col-sm-5'>
									".form_input(array('class' => 'form-control','type' => 'text','name' => 'txt_contacto','id' => 'txt_contacto','value' => $datos->contacto))."
								</div>
							</div>
							".cat_generales($datos)."
							<div class='form-group row'>
								<center>
									<div id='div_msj_info'></div>
									".form_button(array('type' => 'button','content' => 'Actualizar Info','class' => 'btn btn-primary','onclick' => 'xajax_update_info(xajax.getFormValues(\'frm_agenda\'))'))."
								</center>
							</div>
						</p>
					</div>
					<div role='tabpanel' class='tab-pane fade' id='info_rel' aria-labelledBy='info_rel-tab'>
				    	<p>
				    		<center>
				    		<div class='form-group row'>
				    			<div class='col-sm-6'>
									".form_label('Actividad: ','lbl_actividad')."
									<b>".$datos->actividad."</b>
								</div>
								<div class='col-sm-6'>
									".form_label('Tipo de la actividad: ','lbl_tipo_actividad')."
									<b>".$datos->tipo_actividad."</b>
								</div>
							</div>
							<div class='form-group row'>
								<div class='col-sm-4'>
									".form_label('Probabilidad de Compra: ','lbl_colonia')."
									<b>".$datos->probabilidad_compra."</b>
								</div>
								<div class='col-sm-4'>
									".form_label('Condiciones Pago: ','lbl_condiciones_pago')."
									<b>".$datos->condiciones_pago."</b>
								</div>
								<div class='col-sm-4'>
									".form_label('Plazo Pago: ','lbl_plazo_pago')."
									<b>".$datos->plazo_pago."</b>
								</div>
							</div>
							<div class='form-group row'>
								".form_label('Observaciones: ','lbl_obsrevaciones',array('class' => 'col-sm-3 control-label'))."
								<div class='col-sm-5'>
									".form_textarea(array('class' => 'form-control','type' => 'text','name' => 'obs_prospecto','id' => 'obs_prospecto','value' => $datos->obs_pros,'rows' => '2','cols'))."
								</div>
								<div class='col-sm-4'>
									".form_label('El prospecto realiza Servicios: ')." <b>".$datos->servicio."</b>
									".form_label('El prospecto compra Refacciones: ')." <b>".$datos->refacciones."</b>
								</div>
							</div>
							</center>
						</p>
					</div>
				    <div role='tabpanel' class='tab-pane fade' id='inv_cli' aria-labelledBy='inv_cli-tab'>
				    	<p>
				    		".$datos_flotilla."
				    		<div id='div_ic0'>
						    	<center>
						    		".anchor('#','<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-plus-fill" viewBox="0 0 16 16">
  <path d="M9.293 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.707A1 1 0 0 0 13.707 4L10 .293A1 1 0 0 0 9.293 0zM9.5 3.5v-2l3 3h-2a1 1 0 0 1-1-1zM8.5 7v1.5H10a.5.5 0 0 1 0 1H8.5V11a.5.5 0 0 1-1 0V9.5H6a.5.5 0 0 1 0-1h1.5V7a.5.5 0 0 1 1 0z"/>
</svg> Equipo / Implemento','onclick="xajax_add_ic(\'1\');return false;"')."
						    	</center>
					    	</div>
					    	<br />
					    	<center>
								<div id='div_msj_ic'></div>
								".form_button(array('type' => 'button','content' => 'Agregar Inventario Cliente','class' => 'btn btn-primary','onclick' => 'xajax_update_ic(xajax.getFormValues(\'frm_agenda\'))'))."
							</center>
						</p>
					</div>
					<div role='tabpanel' class='tab-pane fade' id='solicita' aria-labelledBy='solicita-tab'>
						<p>
							".$datos_eq_sol."
						</p>
					</div>
					<div role='tabpanel' class='tab-pane fade' id='refaccion' aria-labelledBy='refaccion-tab'>
						<p>
							".$datos_re_sol."
						</p>
					</div>
					<div role='tabpanel' class='tab-pane fade' id='servicio' aria-labelledBy='servicio-tab'>
						<p>
							".$datos_se_sol."
						</p>
					</div>
					<div role='tabpanel' class='tab-pane fade' id='localizacion' aria-labelledBy='localizacion-tab'>
				    	<p>
				    		".$datos_localiza."
				    		<div id='div_la0'>
				    			<center>
						    		".anchor('#','<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-plus-fill" viewBox="0 0 16 16">
  <path d="M9.293 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.707A1 1 0 0 0 13.707 4L10 .293A1 1 0 0 0 9.293 0zM9.5 3.5v-2l3 3h-2a1 1 0 0 1-1-1zM8.5 7v1.5H10a.5.5 0 0 1 0 1H8.5V11a.5.5 0 0 1-1 0V9.5H6a.5.5 0 0 1 0-1h1.5V7a.5.5 0 0 1 1 0z"/>
</svg> Localización Adicional','onclick="xajax_add_la(\'1\');return false;"')."
						    	</center>
					    	</div>
					    	<br />
					    	<center>
								<div id='div_msj_la'></div>
								".form_button(array('type' => 'button','content' => 'Agregar Localizaciones Ad.','class' => 'btn btn-primary','onclick' => 'xajax_update_la(xajax.getFormValues(\'frm_agenda\'))'))."
							</center>
						</p>
					</div>
					<div role='tabpanel' class='tab-pane fade' id='doc_dig' aria-labelledBy='doc_dig-tab'>
						<p>
							".$doc_dig."
							<center>
								".form_button(array('type' => 'submit','content' => 'Subir Archivos','class' => 'btn btn-primary'))."
								<br /><br /><br /><br />
								".$mostrar_dig."
							</center>
						</p>
					</div>
				</div>
				".form_input(array('type' => 'hidden','name' => 'h_num_ic','id' => 'h_num_ic','value' => 0))."
				".form_input(array('type' => 'hidden','name' => 'h_num_la','id' => 'h_num_la','value' => 0))."
				".form_input(array('type' => 'hidden','name' => 'h_pk_prospecto','id' => 'h_pk_prospecto','value' => $datos->pk_prospecto))."
				".form_input(array('type' => 'hidden','name' => 'h_pk_cat_generales','id' => 'h_pk_cat_generales','value' => $datos->pk_cat_generales))."
				".form_input(array('type' => 'hidden','name' => 'h_pk_u_prospecto_ciclo','id' => 'h_pk_u_prospecto_ciclo','value' => $datos->pk_u_prospecto_ciclo))."";
		$vista.= show_modal();
		return $vista;
	}
}

if(!function_exists('mostrar_add_ic')){

	function mostrar_add_ic($num){
		$vista = "<div class='form-group row'>
	    			".form_label('Descripción: ','',array('class' => 'col-sm-1 control-label'))."
					<div class='col-sm-4'>
						".form_input(array('class' => 'form-control','type' => 'text','name' => 'txt_descripcion_ic'.$num,'id' => 'txt_descripcion_ic'.$num,'required' => 'required','title' => 'Necesario Escribir una descripción','placeholder' => 'Nueva Descripción'))."
					</div>
					".form_label('Cantidad: ','',array('class' => 'col-sm-1 control-label'))."
					<div class='col-sm-1'>
						".form_input(array('class' => 'form-control','type' => 'text','name' => 'txt_cantidad_ic'.$num,'id' => 'txt_cantidad_ic'.$num,'required' => 'required','title' => 'Necesario Escribir una cantidad','placeholder' => 'Nueva Cantidad'))."
					</div>
	    			".form_label('Fecha Adquisición: ','',array('class' => 'col-sm-2 control-label'))."
	    			<div class='col-sm-3'>
						<div class='input-group date' id='datetimepicker".$num."'>
							".form_input(array('class' => 'form-control','type' => 'text','name' => 'txt_fecha_adq'.$num,'id' => 'txt_fecha_adq'.$num,'required' => 'required','title' => 'Necesario Seleccionar una Fecha de Adquisición','placeholder' => 'Nuevo Fecha de Adquisición','data-format' => 'YYYY-MM-DD','readonly' => 'readonly'))."
							<span class='input-group-text'>
		                        <svg class='bi bi-calendar3-fill' width='1em' height='1em' viewBox='0 0 16 16' fill='currentColor' xmlns='http://www.w3.org/2000/svg'>
		                          <path d='M0 2a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2H0z'/>
		                          <path fill-rule='evenodd' d='M0 3h16v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3zm6.5 4a1 1 0 1 0 0-2 1 1 0 0 0 0 2zm4-1a1 1 0 1 1-2 0 1 1 0 0 1 2 0zm2 1a1 1 0 1 0 0-2 1 1 0 0 0 0 2zm-8 2a1 1 0 1 1-2 0 1 1 0 0 1 2 0zm2 1a1 1 0 1 0 0-2 1 1 0 0 0 0 2zm4-1a1 1 0 1 1-2 0 1 1 0 0 1 2 0zm2 1a1 1 0 1 0 0-2 1 1 0 0 0 0 2zm-8 2a1 1 0 1 1-2 0 1 1 0 0 1 2 0zm2 1a1 1 0 1 0 0-2 1 1 0 0 0 0 2zm4-1a1 1 0 1 1-2 0 1 1 0 0 1 2 0z'/>
		                        </svg>
		                    </span>
						</div>
					</div>
				</div>
				<div id='div_ic".$num."'>
			    	<center>
			    		".anchor('#','<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-plus-fill" viewBox="0 0 16 16">
  <path d="M9.293 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.707A1 1 0 0 0 13.707 4L10 .293A1 1 0 0 0 9.293 0zM9.5 3.5v-2l3 3h-2a1 1 0 0 1-1-1zM8.5 7v1.5H10a.5.5 0 0 1 0 1H8.5V11a.5.5 0 0 1-1 0V9.5H6a.5.5 0 0 1 0-1h1.5V7a.5.5 0 0 1 1 0z"/>
</svg> Equipo / Implemento','onclick="xajax_add_ic(\''.($num+1).'\');return false;"')."
			    	</center>
		    	</div>";
		return $vista;
	}
}

if(!function_exists('mostrar_add_la')){

	function mostrar_add_la($num){
		$vista = "<center>
	    		<div class='form-group row'>
					<div class='col-sm-3'>
						".form_label('Tipo:')."
						".form_input(array('class' => 'form-control','type' => 'text','name' => 'txt_tipo'.$num,'id' => 'txt_tipo'.$num,'required' => 'required','title' => 'Necesario Escribir un tipo','placeholder' => 'Correo, fax, cel, etc..'))."
					</div>
					<div class='col-sm-3'>
						".form_label('Descripción:')."
						".form_input(array('class' => 'form-control','type' => 'text','name' => 'txt_descripcion_la'.$num,'id' => 'txt_descripcion_la'.$num,'required' => 'required','title' => 'Necesario Escribir una Descripción','placeholder' => 'N° Tel, N° Cel, Correo'))."
					</div>
					<div class='col-sm-3'>
						".form_label('Nombre:')."
						".form_input(array('class' => 'form-control','type' => 'text','name' => 'txt_nombre'.$num,'id' => 'txt_nombre'.$num,'required' => 'required','title' => 'Necesario Escribir un Nombre','placeholder' => 'Nuevo Nombre'))."
					</div>
					<div class='col-sm-3'>
						".form_label('Relación:')."
						".form_input(array('class' => 'form-control','type' => 'text','name' => 'txt_relacion'.$num,'id' => 'txt_relacion'.$num,'required' => 'required','title' => 'Necesario Escribir una Relación','placeholder' => 'Parenteso con el prospecto'))."
					</div>
				</div>
		    	<div id='div_la".$num."'>
			    	".anchor('#','<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-plus-fill" viewBox="0 0 16 16">
  <path d="M9.293 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.707A1 1 0 0 0 13.707 4L10 .293A1 1 0 0 0 9.293 0zM9.5 3.5v-2l3 3h-2a1 1 0 0 1-1-1zM8.5 7v1.5H10a.5.5 0 0 1 0 1H8.5V11a.5.5 0 0 1-1 0V9.5H6a.5.5 0 0 1 0-1h1.5V7a.5.5 0 0 1 1 0z"/>
</svg> Localización Adicional','onclick="xajax_add_la(\''.($num+1).'\');return false;"')."
		    	</div>
		    	</center>";
		return $vista;
	}
}

if(!function_exists('show_modal')){	

	function show_modal(){
		$vista = "<!-- Modal -->
				<div class='modal fade bs-example-modal-lg' id='myModal' tabindex='-1' role='dialog' aria-labelledby='myModalLabel'>
				  <div class='modal-dialog modal-lg' role='document'>
				    <div class='modal-content'>
				      <div class='modal-body' id='div_modal'>
				        
				      </div>
				      <div id='div_msj_modal'></div>
				      <div class='modal-footer' id='div_modal_footer'>
				        
				      </div>
				    </div>
				  </div>
				</div>";
		return $vista;
	}
}

if(!function_exists('mostrar_add')){

	function mostrar_add($tipo_articulo){
		$vista = form_label('Equipo cotizado/solicitado:')."<br /><br />
		    	<center>
				<div class='form-group row'>
					
			    	<div class='col-sm-2'>
						".form_label('Artículo: ','')."
						".combos($tipo_articulo,'pk_cat_tipo_articulo','descripcion','fk_cat_tipo_articulo','fk_cat_tipo_articulo','loading_small(\'div_gpo_catalogo\');xajax_cargar_combos(this.value,\'div_gpo_catalogo\');')."
					</div>
					<div class='col-sm-2' id='div_gpo_catalogo'>
						".form_label('Grupo: ','')."
						".form_dropdown('cmb',array("Seleccione" => "Seleccione...."),'','class="form-control"')."
					</div>
					<div class='col-sm-3' id='div_subgpo_catalogo'>
						".form_label('Subgrupo Catálogo: ','')."
						".form_dropdown('cmb',array("Seleccione" => "Seleccione...."),'','class="form-control"')."
					</div>
					<div class='col-sm-2' id='div_marca'>
						".form_label('Marca: ','')."
						".form_dropdown('cmb',array("Seleccione" => "Seleccione...."),'','class="form-control"')."
					</div>
					<div class='col-sm-3' id='div_modelo'>
						".form_label('Modelo: ','')."
						".form_dropdown('cmb',array("Seleccione" => "Seleccione...."),'','class="form-control"')."
					</div>
				</div>
				</center>";
		return $vista;
	}
}

if(!function_exists('mostrar_add_re')){

	function mostrar_add_re($tipo_articulo){
		$vista = "<center>
					<div class='form-group row'>
						<div class='col-sm-3'></div>
						<div class='col-sm-6'>
							".form_label('Refacción: ','')."
							".combos($tipo_articulo,'refaccionId','refaccionDescripcion','refaccionId','refaccionId','')."
						</div>
						<div class='col-sm-3'></div>
					</div>
				</center>";
		return $vista;
	}
}

if(!function_exists('mostrar_add_se')){

	function mostrar_add_se($tipo_articulo){
		$vista = "<center>
					<div class='form-group row'>
						<div class='col-sm-1'></div>
						<div class='col-sm-4'>
							".form_label('Plantilla de Servicio: ','')."
							".combos($tipo_articulo,'pk_servicio','descripcion','fk_servicio','fk_servicio','loading_small(\'div_unidades_plantilla\');xajax_cargar_combos(this.value,\'div_unidades_plantilla\');')."
						</div>
						<div class='col-sm-6' id='div_unidades_plantilla'>
							".form_label('Unidad: ','')."
							".form_dropdown('cmb',array('Seleccione' => 'Seleccione....'),'','class=\'form-control chosen-select\'')."
						</div>
						<div class='col-sm-2'></div>
					</div>
				</center>";
		return $vista;
	}
}

if(!function_exists('mostrar_combo')){

	function mostrar_combo($datos,$texto){
		$vista = "";
		if(count($datos) != 0){
			switch ($texto) {
				case 'div_gpo_catalogo':
					$vista = form_label('Catálogo: ','');
					$vista.= combos($datos,'pk_gpo_catalogo','descripcion','fk_gpo_catalogo','fk_gpo_catalogo','loading_small(\'div_subgpo_catalogo\');xajax_cargar_combos(this.value,\'div_subgpo_catalogo\');');
				break;
				case 'div_subgpo_catalogo':
					$vista = form_label('Subgrupo Catálogo: ','');
					$vista.= combos($datos,'pk_subgpo_catalogo','descripcion','fk_subgpo_catalogo','fk_subgpo_catalogo','loading_small(\'div_marca\');xajax_cargar_combos(this.value,\'div_marca\');');
				break;
				case 'div_marca':
					$vista = form_label('Marca: ','');
					$vista.= combos($datos,'pk_cat_marca','descripcion','fk_cat_marca','fk_cat_marca','loading_small(\'div_modelo\');xajax_cargar_combos(this.value,\'div_modelo\');');
				break;
				case 'div_modelo':
					$vista = form_label('Modelo: ','');
					$vista.= combos($datos,'pk_cat_modelo','descripcion','fk_cat_modelo','fk_cat_modelo','');
				break;
				case 'div_unidades_plantilla':
					$vista = form_label('Unidad: ','');
					$vista.= combos($datos,'pk_cat_modelo','descripcion','fk_cat_modelo_ser','fk_cat_modelo_ser','');
				break;
			}
		}
		else
			$vista = empty_msg('No existe Registros');
		return $vista;
	}
}

if(!function_exists('botones_add')){

	function botones_add($pk_u_prospecto_ciclo){
		$vista = "<button type='button' class='btn btn-info' id='btn_baja_modal' 
						onclick=\"xajax_guardar_add('".$pk_u_prospecto_ciclo."',$('#fk_cat_modelo').val())\">Agregar Artículo</button>
				  <button type='button' class='btn btn-danger' data-dismiss='modal' id='btn_cancelar_modal'>Cancelar</button>";
		return $vista;
	}
}

if(!function_exists('botones_add_re')){

	function botones_add_re($pk_u_prospecto_ciclo){
		$vista = "<button type='button' class='btn btn-info' id='btn_baja_modal' 
						onclick=\"xajax_guardar_add_re('".$pk_u_prospecto_ciclo."',$('#refaccionId').val())\">Agregar Artículo</button>
				  <button type='button' class='btn btn-danger' data-dismiss='modal' id='btn_cancelar_modal'>Cancelar</button>";
		return $vista;
	}
}

if(!function_exists('botones_add_se')){

	function botones_add_se($pk_u_prospecto_ciclo){
		$vista = "<button type='button' class='btn btn-info' id='btn_baja_modal' 
						onclick=\"xajax_guardar_add_se('".$pk_u_prospecto_ciclo."',$('#fk_servicio').val(),$('#fk_cat_modelo_ser').val())\">Agregar Artículo</button>
				  <button type='button' class='btn btn-danger' data-dismiss='modal' id='btn_cancelar_modal'>Cancelar</button>";
		return $vista;
	}
}