<?php if ( ! defined('BASEPATH')) exit('No esta permitido el acceso directo');//impide el acceso directo a este script

if(!function_exists('mostrar_filtro_prospecto')){

	function mostrar_filtro_prospecto($datos){
		$vista = "";
		if(count($datos) != 0){
			foreach($datos as $value):
				if(stripos($value->nombre, '-') !== FALSE)
					$options[$value->pk_u_prospecto_ciclo] = $value->razon_social;
				else
					$options[$value->pk_u_prospecto_ciclo] = $value->nombre;
			endforeach;
			$vista = form_multiselect('fk_cat_prospecto',$options,set_value('fk_cat_prospecto'),'onclick="loading(\'div_show\');xajax_mostrar_prospectos(this.value);" required="required" class="form-control" style="width:50%"');
		}
		else
			$vista = empty_msg('No existen prospectos según la búsqueda');
		return $vista;
	}
}

if(!function_exists('mostrar_datos_cotizacion')){

	function mostrar_datos_cotizacion($datos,$solicitado,$pk_u_prospecto_ciclo,$articulo_maestro){
		$bandera_cotizacion = FALSE;
		$vista = "<table class='table table-bordered table-hover table-condensed' id='dt_cotizaciones'>
					<thead>
						<tr>
							<th>Unidad / Refacción / Servicio</th>
							<th>Cantidad</th>
							<th>Precio</th>
							<th>Status</th>
							<th>Causa Baja</th>
							<th>Cambiar Status</th>
						</tr>
					</thead>
					<tbody>";
		$i = 0;
		foreach ($solicitado as $registro){
			$vista.= "<tr ".(($registro->status == 'A') ? "class='table-success'" : "class='table-danger'").">
						".form_hidden(array('h_status'.$i => $registro->status,'h_fk_solicitado'.$i => $registro->pk_solicitado))."
						<td>".$registro->equipo."</td>
						<td>".$registro->cantidad."</td>
						<td>".form_input(array('class' => 'form-control','type' => 'text','name' => 'precio'.$i,'id' => 'precio'.$i,'value' => $registro->precio))."</td>
						<td>".(($registro->status == 'A') ? 'ACTIVO' : 'INACTIVO')."</td>
						<td>".$registro->rechazo."</td>
						<td align='center'>"
							.(($registro->status == 'A') ? 
								form_button(array('type' => 'button','name' => 'btn_cancelar','id' => 'btn_cancelar','content' => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
									  <path d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6z"/>
									  <path fill-rule="evenodd" d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118zM2.5 3V2h11v1h-11z"/>
									</svg>','class' => 'btn btn-danger','data-toggle' => 'modal','data-target' => '#myModal','onclick' => 'loading_small(\'div_modal\');xajax_baja(\''.$registro->pk_solicitado.'\',\''.$registro->status.'\',\''.$pk_u_prospecto_ciclo.'\')')) : 
								form_button(array('type' => 'button','name' => 'btn_cancelar','id' => 'btn_cancelar','content' => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-repeat" viewBox="0 0 16 16">
									  <path d="M11.534 7h3.932a.25.25 0 0 1 .192.41l-1.966 2.36a.25.25 0 0 1-.384 0l-1.966-2.36a.25.25 0 0 1 .192-.41zm-11 2h3.932a.25.25 0 0 0 .192-.41L2.692 6.23a.25.25 0 0 0-.384 0L.342 8.59A.25.25 0 0 0 .534 9z"/>
									  <path fill-rule="evenodd" d="M8 3c-1.552 0-2.94.707-3.857 1.818a.5.5 0 1 1-.771-.636A6.002 6.002 0 0 1 13.917 7H12.9A5.002 5.002 0 0 0 8 3zM3.1 9a5.002 5.002 0 0 0 8.757 2.182.5.5 0 1 1 .771.636A6.002 6.002 0 0 1 2.083 9H3.1z"/>
									</svg>','class' => 'btn btn-success','onclick' => 'loading_small(\'div_modal\');xajax_baja(\''.$registro->pk_solicitado.'\',\''.$registro->status.'\',\''.$pk_u_prospecto_ciclo.'\')'))).
						"</td>
					</tr>";
			$i++;
			if(!$bandera_cotizacion && $registro->status == 'A')
				$bandera_cotizacion = TRUE;
		}
		$vista.= "
					</tbody>
				</table>";
		
		$vista.= "<center>
					<b>Tipo de Cotizacion: </b>".form_dropdown("cmb_tipo_cot",array("DE VENTA" => "DE VENTA","INFORMATIVA" => "INFORMATIVA"),"",'required="required" class="form-control chosen-select" style="width:20%"')."
					<br />";
		switch ($articulo_maestro) {
			case 'unidad':
				$vista.= anchor('#','<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-plus-fill" viewBox="0 0 16 16"><path d="M9.293 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.707A1 1 0 0 0 13.707 4L10 .293A1 1 0 0 0 9.293 0zM9.5 3.5v-2l3 3h-2a1 1 0 0 1-1-1zM8.5 7v1.5H10a.5.5 0 0 1 0 1H8.5V11a.5.5 0 0 1-1 0V9.5H6a.5.5 0 0 1 0-1h1.5V7a.5.5 0 0 1 1 0z"/></svg> Equipo / Implemento','onclick="loading_small(\'div_modal\');xajax_add(\''.$pk_u_prospecto_ciclo.'\');" data-toggle="modal" data-target="#myModal"')."<br /><br />";
				break;
			
			case 'refaccion':
				$vista.= anchor('#','<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-plus-fill" viewBox="0 0 16 16"><path d="M9.293 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.707A1 1 0 0 0 13.707 4L10 .293A1 1 0 0 0 9.293 0zM9.5 3.5v-2l3 3h-2a1 1 0 0 1-1-1zM8.5 7v1.5H10a.5.5 0 0 1 0 1H8.5V11a.5.5 0 0 1-1 0V9.5H6a.5.5 0 0 1 0-1h1.5V7a.5.5 0 0 1 1 0z"/></svg> Refacción','onclick="loading_small(\'div_modal\');xajax_add_re(\''.$pk_u_prospecto_ciclo.'\');" data-toggle="modal" data-target="#myModal"')."<br /><br />";
				break;
			
			case 'servicio':
				$vista.= anchor('#','<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-plus-fill" viewBox="0 0 16 16"><path d="M9.293 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.707A1 1 0 0 0 13.707 4L10 .293A1 1 0 0 0 9.293 0zM9.5 3.5v-2l3 3h-2a1 1 0 0 1-1-1zM8.5 7v1.5H10a.5.5 0 0 1 0 1H8.5V11a.5.5 0 0 1-1 0V9.5H6a.5.5 0 0 1 0-1h1.5V7a.5.5 0 0 1 1 0z"/></svg> Servicio','onclick="loading_small(\'div_modal\');xajax_add_se(\''.$pk_u_prospecto_ciclo.'\');" data-toggle="modal" data-target="#myModal"')."<br /><br />";
				break;
		}
		if($bandera_cotizacion)
			$vista.= "".form_button(array('type' => 'submit','name' => 'btn_imprimir','id' => 'btn_imprimir','content' => 'Generar Cotización','class' => 'btn btn-info','formtarget' => '_new'))."
		   			 ".form_input(array('type' => 'hidden','name' => 'h_pk_u_prospecto_ciclo','id' => 'h_pk_u_prospecto_ciclo','value' => $pk_u_prospecto_ciclo))."
		   			 ".form_input(array('type' => 'hidden','name' => 'h_tot_cot','id' => 'h_tot_cot','value' => $i))."";
		else
			$vista.= empty_msg("Para poder cotizar es necesario, por lo menos, tener un Equipo / Implemento Activo");
		$vista.= "</center>";
		$vista.= show_modal();
		return $vista;
	}
}

if(!function_exists('mostrar_datos_baja')){

	function mostrar_datos_baja($rechazo){
		$vista = "<center>
					<div class='form-group row'>
						<div class='col-sm-8 offset-sm-2'>" 
							.form_label('Motivo: ','')."&nbsp;"
							.combos($rechazo,'pk_cat_rechazo','descripcion','fk_cat_rechazo','fk_cat_rechazo','')."
						</div>
					</div>
				</center>";
		return $vista;
	}
}

if(!function_exists('botones_baja')){

	function botones_baja($pk_solicitado,$status,$pk_u_prospecto_ciclo){
		$vista = "<button type='button' class='btn btn-warning' id='btn_baja_modal' 
						onclick=\"xajax_update_status('".$pk_solicitado."',$('#fk_cat_rechazo').val(),'".$status."','".$pk_u_prospecto_ciclo."')\">Dar de Baja</button>
				  <button type='button' class='btn btn-danger' data-dismiss='modal' id='btn_cancelar_modal'>Cancelar</button>";
		return $vista;
	}
}

if(!function_exists('show_modal')){

	function show_modal(){
		$vista = "<!-- Modal -->
				<div class='modal fade bs-example-modal-lg' id='myModal' tabindex='-1' role='dialog' aria-labelledby='myModalLabel'>
				  <div class='modal-dialog modal-lg' role='document'>
				    <div class='modal-content'>
				      <div class='modal-body' id='div_modal'>
				        
				      </div>
				      <div id='div_msj_modal'></div>
				      <div class='modal-footer' id='div_modal_footer'>
				        
				      </div>
				    </div>
				  </div>
				</div>";
		return $vista;
	}
}

if(!function_exists('mostrar_add')){

	function mostrar_add($tipo_articulo){
		$vista = form_label('Equipo cotizado/solicitado:')."<br /><br />
		    	<center>
				<div class='form-group row'>
					
			    	<div class='col-sm-2'>
						".form_label('Artículo: ','')."
						".combos($tipo_articulo,'pk_cat_tipo_articulo','descripcion','fk_cat_tipo_articulo','fk_cat_tipo_articulo','loading_small(\'div_gpo_catalogo\');xajax_cargar_combos(this.value,\'div_gpo_catalogo\');')."
					</div>
					<div class='col-sm-2' id='div_gpo_catalogo'>
						".form_label('Grupo: ','')."
						".form_dropdown('cmb',array("Seleccione" => "Seleccione...."),'','class="form-control"')."
					</div>
					<div class='col-sm-3' id='div_subgpo_catalogo'>
						".form_label('Subgrupo Catálogo: ','')."
						".form_dropdown('cmb',array("Seleccione" => "Seleccione...."),'','class="form-control"')."
					</div>
					<div class='col-sm-2' id='div_marca'>
						".form_label('Marca: ','')."
						".form_dropdown('cmb',array("Seleccione" => "Seleccione...."),'','class="form-control"')."
					</div>
					<div class='col-sm-3' id='div_modelo'>
						".form_label('Modelo: ','')."
						".form_dropdown('cmb',array("Seleccione" => "Seleccione...."),'','class="form-control"')."
					</div>
				</div>
				</center>";
		return $vista;
	}
}

if(!function_exists('mostrar_add_re')){

	function mostrar_add_re($tipo_articulo){
		$vista = "<center>
					<div class='form-group row'>
						<div class='col-sm-3'></div>
						<div class='col-sm-6'>
							".form_label('Refacción: ','')."
							".combos($tipo_articulo,'refaccionId','refaccionDescripcion','refaccionId','refaccionId','')."
						</div>
						<div class='col-sm-3'></div>
					</div>
				</center>";
		return $vista;
	}
}

if(!function_exists('mostrar_add_se')){

	function mostrar_add_se($tipo_articulo){
		$vista = "<center>
					<div class='form-group row'>
						<div class='col-sm-1'></div>
						<div class='col-sm-4'>
							".form_label('Plantilla de Servicio: ','')."
							".combos($tipo_articulo,'pk_servicio','descripcion','fk_servicio','fk_servicio','loading_small(\'div_unidades_plantilla\');xajax_cargar_combos(this.value,\'div_unidades_plantilla\');')."
						</div>
						<div class='col-sm-6' id='div_unidades_plantilla'>
							".form_label('Unidad: ','')."
							".form_dropdown('cmb',array('Seleccione' => 'Seleccione....'),'','class=\'form-control chosen-select\'')."
						</div>
						<div class='col-sm-2'></div>
					</div>
				</center>";
		return $vista;
	}
}

if(!function_exists('mostrar_combo')){

	function mostrar_combo($datos,$texto){
		$vista = "";
		if(count($datos) != 0){
			switch ($texto) {
				case 'div_gpo_catalogo':
					$vista = form_label('Catálogo: ','');
					$vista.= combos($datos,'pk_gpo_catalogo','descripcion','fk_gpo_catalogo','fk_gpo_catalogo','loading_small(\'div_subgpo_catalogo\');xajax_cargar_combos(this.value,\'div_subgpo_catalogo\');');
				break;
				case 'div_subgpo_catalogo':
					$vista = form_label('Subgrupo Catálogo: ','');
					$vista.= combos($datos,'pk_subgpo_catalogo','descripcion','fk_subgpo_catalogo','fk_subgpo_catalogo','loading_small(\'div_marca\');xajax_cargar_combos(this.value,\'div_marca\');');
				break;
				case 'div_marca':
					$vista = form_label('Marca: ','');
					$vista.= combos($datos,'pk_cat_marca','descripcion','fk_cat_marca','fk_cat_marca','loading_small(\'div_modelo\');xajax_cargar_combos(this.value,\'div_modelo\');');
				break;
				case 'div_modelo':
					$vista = form_label('Modelo: ','');
					$vista.= combos($datos,'pk_cat_modelo','descripcion','fk_cat_modelo','fk_cat_modelo','');
				break;
				case 'div_unidades_plantilla':
					$vista = form_label('Unidad: ','');
					$vista.= combos($datos,'pk_cat_modelo','descripcion','fk_cat_modelo_ser','fk_cat_modelo_ser','');
				break;
			}
		}
		else
			$vista = empty_msg('No existe Registros');
		return $vista;
	}
}

if(!function_exists('botones_add')){

	function botones_add($pk_u_prospecto_ciclo){
		$vista = "<button type='button' class='btn btn-info' id='btn_baja_modal' 
						onclick=\"xajax_guardar_add('".$pk_u_prospecto_ciclo."',$('#fk_cat_modelo').val())\">Agregar Artículo</button>
				  <button type='button' class='btn btn-danger' data-dismiss='modal' id='btn_cancelar_modal'>Cancelar</button>";
		return $vista;
	}
}

if(!function_exists('botones_add_re')){

	function botones_add_re($pk_u_prospecto_ciclo){
		$vista = "<button type='button' class='btn btn-info' id='btn_baja_modal' 
						onclick=\"xajax_guardar_add_re('".$pk_u_prospecto_ciclo."',$('#refaccionId').val())\">Agregar Artículo</button>
				  <button type='button' class='btn btn-danger' data-dismiss='modal' id='btn_cancelar_modal'>Cancelar</button>";
		return $vista;
	}
}

if(!function_exists('botones_add_se')){

	function botones_add_se($pk_u_prospecto_ciclo){
		$vista = "<button type='button' class='btn btn-info' id='btn_baja_modal' 
						onclick=\"xajax_guardar_add_se('".$pk_u_prospecto_ciclo."',$('#fk_servicio').val(),$('#fk_cat_modelo_ser').val())\">Agregar Artículo</button>
				  <button type='button' class='btn btn-danger' data-dismiss='modal' id='btn_cancelar_modal'>Cancelar</button>";
		return $vista;
	}
}

if(!function_exists('imprimir')){

	function imprimir($prospecto,$cotizacion){
		$nombre = "";
		if(stripos($prospecto->nombre, '-') !== FALSE)
			$nombre = $prospecto->razon_social;
		else
			$nombre = $prospecto->nombre;
		//instanciamos el objeto para poder obtener todas sus propiedades
		$CI =& get_instance();
		$CI->load->library('prospectos/pdf/Pdf_lib',array(
			'fecha' => $cotizacion[0]->fecha,
			'folio' => $cotizacion[0]->folio,
			'domicilio' => $cotizacion[0]->domicilio,
			'nombre' => $cotizacion[0]->nombre,
			'encargado' => $cotizacion[0]->encargado
		));

		//$CI->pdf_lib->fpdf('L');//Horizontal
        // Define el alias para el número de página que se imprimirá en el pie
        $CI->pdf_lib->AliasNbPages();
        // Agregamos una página
        $CI->pdf_lib->AddPage();
        //Margen Superior
        //$CI->pdf_lib->SetTopMargin(0);
        
		$CI->pdf_lib->SetFont('Arial','B',10);
		$CI->pdf_lib->Cell(30,10,utf8_decode("Estimado Cliente ".$nombre),0,0,'L');
		$CI->pdf_lib->Ln(4);
		$CI->pdf_lib->SetFont('Arial','',8);
		$CI->pdf_lib->Cell(30,10,utf8_decode($prospecto->domicilio),0,0,'L');
		$CI->pdf_lib->Ln(4);
		$CI->pdf_lib->Cell(30,10,utf8_decode($prospecto->domicilio2),0,0,'L');

		$CI->pdf_lib->Ln(10);

		$CI->pdf_lib->SetFont('Arial','',10);
		$CI->pdf_lib->MultiCell(0,5,utf8_decode("Por este medio pongo a su consideración, la cotización que amablemente nos solicitó y que a continuación se detalla:"),0,"J");

		$CI->pdf_lib->Ln(5);
		
		//Datos
		$CI->pdf_lib->SetFont('Arial','',8);
		$importe_total = 0;
		foreach ($cotizacion as $value){
			$CI->pdf_lib->SetFont('Arial','',8);
			$CI->pdf_lib->Cell(191,5,utf8_decode("DESCRIPCIÓN"),1,0,'C');
			$CI->pdf_lib->Ln();
			$CI->pdf_lib->MultiCell(191,5,utf8_decode($value->detalles),1,"J");
				
			$CI->pdf_lib->SetFont('Arial','B',8);
			$CI->pdf_lib->Cell(40,5,utf8_decode("PRECIO"),0,0,'J');
			$CI->pdf_lib->Cell(0,5,"$ ".number_format($value->precio,2),0,0,'J');
			$CI->pdf_lib->Ln(10);

			$importe_total += $value->precio;
		}

		$CI->pdf_lib->SetFont('Arial','B',8);
		$CI->pdf_lib->Cell(40,5,utf8_decode("--- GRAN TOTAL ---"),0,0,'J');
		$CI->pdf_lib->Cell(0,5,"$ ".number_format($importe_total,2),0,0,'J');
		$CI->pdf_lib->Ln(10);

		$CI->pdf_lib->SetFont('Arial','',10);
		//$CI->pdf_lib->MultiCell(0,5,utf8_decode("Esta Cotizacion tendra una vigencia de 30 dias naturales"),0,"J");
		//12-07-2022. Solicitado por Zacarias. Modificar la leyenda
		$CI->pdf_lib->MultiCell(0,5,utf8_decode("Los precio están sujetos a cambio sin previo aviso, esto por las alzas constantes en el acero, según fabricante"),0,"J");

		$CI->pdf_lib->Ln(5);

		$CI->pdf_lib->SetFont('Arial','B',10);
		$CI->pdf_lib->MultiCell(0,5,utf8_decode("Una vez entregada la unidad al productor la garantía será de 18 meses ó 1,500 horas en el tractor,garantizamos refacciones y accesorios están disponibles en cualquiera de nuestras sucursales, para el mantenimiento permanente."),0,"J");

		$CI->pdf_lib->Ln(5);

		$CI->pdf_lib->SetFont('Arial','',10);
		$CI->pdf_lib->MultiCell(0,5,utf8_decode("Sin otro particular y en espera que esta cotización sea de su agrado, me es grato quedar a sus órdenes para cualquier duda o aclaración al respecto"),0,"J");

		$CI->pdf_lib->Ln(10);

		$CI->pdf_lib->SetFont('Arial','B',10);
		$CI->pdf_lib->MultiCell(0,5,utf8_decode("ATENTAMENTE"),0,"C");

		$CI->pdf_lib->Ln(15);

		$CI->pdf_lib->SetFont('Arial','',10);
		$CI->pdf_lib->MultiCell(0,5,utf8_decode($cotizacion[0]->encargado),0,"C");

		$CI->pdf_lib->Ln(1);

		$CI->pdf_lib->SetFont('Arial','',10);
		$CI->pdf_lib->MultiCell(0,5,utf8_decode("GERENTE DE VENTAS"),0,"C");
		

        $CI->pdf_lib->Output("Cotizacion.pdf", 'I');
	}

}