<?php if ( ! defined('BASEPATH')) exit('No esta permitido el acceso directo');//impide el acceso directo a este script

if(!function_exists('mostrar_filtro_prospecto')){

	function mostrar_filtro_prospecto($datos){
		$vista = "";
		if(count($datos) != 0){
			foreach($datos as $value):
				if(stripos($value->nombre, '-') !== FALSE)
					$options[$value->pk_u_prospecto_ciclo] = $value->razon_social;
				else
					$options[$value->pk_u_prospecto_ciclo] = $value->nombre;
			endforeach;
			$vista = form_multiselect('fk_cat_prospecto',$options,set_value('fk_cat_prospecto'),'onclick="loading(\'div_show\');xajax_mostrar_prospectos(this.value);" required="required" class="form-control" style="width:50%"');
		}
		else
			$vista = empty_msg('No existen prospectos según la búsqueda');
		return $vista;
	}
}

if(!function_exists('mostrar_datos_cotizacion')){

	function mostrar_datos_cotizacion($equipo_solicitado,$pk_u_prospecto_ciclo){
		$vista = "";
		if(count($equipo_solicitado)){
			$vista = "<table class='table table-bordered table-hover table-condensed' id='dt_mostrar_datos_cotizacion'>
						<thead>
							<tr>
								<th>Fecha Cotización</th>
								<th>Folio Cotización</th>
								<th>Tipo Cotización</th>
								<th>Cambiar a</th>
								<th>Status</th>
								<th>Ver Cotización</th>
								<th>Registrar Venta</th>
							</tr>
						</thead>
						<tbody>";
			foreach ($equipo_solicitado as $registro):
				$vista.= "<tr ".(($registro->status == 'A') ? "class='table-success'" : "class='table-danger'").">
							<td>".$registro->fecha."</td>
							<td>".$registro->folio."</td>
							<td><b>".$registro->tipo."</b></td>
							<td>".(($registro->tipo == 'INFORMATIVA') ? 
								form_button(array('type' => 'button','name' => 'btn_tipo_cot','id' => 'btn_tipo_cot','value' => $registro->pk_cotizacion,'content' => 'DE VENTA','class' => 'btn-xs btn btn-success','onclick' => 'if(confirm(\'¿Está Seguro que desea cambiar el tipo de cotizacion?\'))xajax_cambiar_cot(\''.$registro->pk_cotizacion.'\',\'DE VENTA\',\''.$pk_u_prospecto_ciclo.'\')')) :  
								form_button(array('type' => 'button','name' => 'btn_tipo_cot','id' => 'btn_tipo_cot','value' => $registro->pk_cotizacion,'content' => 'INFORMATIVA','class' => 'btn-xs btn btn-danger','onclick' => 'if(confirm(\'¿Está Seguro que desea cambiar el tipo de cotizacion?\'))xajax_cambiar_cot(\''.$registro->pk_cotizacion.'\',\'INFORMATIVA\',\''.$pk_u_prospecto_ciclo.'\')')))."
							</td>
							<td>".(($registro->status == 'A') ? 'ACTIVO' : 'INACTIVO')."</td>
							<td align='center'>"
								.anchor('prospectos/venta/reimpresion/'.$pk_u_prospecto_ciclo.'/'.$registro->pk_cotizacion,'Ver Cotización',array('class' => 'btn-xs btn btn-warning','target' => '_new','onClick' => "return confirm('¿Está Seguro?')"))."
							</td>
							<td align='center'>"
								.(($registro->status == 'A' && $registro->tipo == 'DE VENTA') ? 
									form_button(array('type' => 'button','name' => 'btn_venta','id' => 'btn_venta','value' => $registro->pk_cotizacion,'content' => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-bookmark-check-fill" viewBox="0 0 16 16">
										  <path fill-rule="evenodd" d="M2 15.5V2a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v13.5a.5.5 0 0 1-.74.439L8 13.069l-5.26 2.87A.5.5 0 0 1 2 15.5zm8.854-9.646a.5.5 0 0 0-.708-.708L7.5 7.793 6.354 6.646a.5.5 0 1 0-.708.708l1.5 1.5a.5.5 0 0 0 .708 0l3-3z"/>
										</svg>','class' => 'btn-xs btn btn-info','onclick' => 'if(confirm(\'¿Está Seguro que desea registrar la venta?\'))xajax_venta(\''.$registro->pk_cotizacion.'\',\''.$pk_u_prospecto_ciclo.'\',\''.$registro->folio.'\')')) : 
									empty_msg("No puedes vender esta Cotización")).
							"</td>
						</tr>";
			endforeach;
			$vista.= "
						</tbody>
					</table>";
		}
		else
			$vista = empty_msg("El prospecto no puede generar una venta porque no cuenta con cotizaciones");
		return $vista;
	}
}

if(!function_exists('imprimir')){

	function imprimir($prospecto,$cotizacion){
		$nombre = "";
		if(stripos($prospecto->nombre, '-') !== FALSE)
			$nombre = $prospecto->razon_social;
		else
			$nombre = $prospecto->nombre;
		//instanciamos el objeto para poder obtener todas sus propiedades
		$CI =& get_instance();
		$CI->load->library('prospectos/pdf/Pdf_lib',array(
			'fecha' => $cotizacion[0]->fecha,
			'folio' => $cotizacion[0]->folio,
			'domicilio' => $cotizacion[0]->domicilio,
			'nombre' => $cotizacion[0]->nombre
		));

		//$CI->pdf_lib->fpdf('L');//Horizontal
        // Define el alias para el número de página que se imprimirá en el pie
        $CI->pdf_lib->AliasNbPages();
        // Agregamos una página
        $CI->pdf_lib->AddPage();
        //Margen Superior
        //$CI->pdf_lib->SetTopMargin(0);
        
		$CI->pdf_lib->SetFont('Arial','B',10);
		$CI->pdf_lib->Cell(30,10,utf8_decode("Estimado Cliente ".$nombre),0,0,'L');
		$CI->pdf_lib->Ln(4);
		$CI->pdf_lib->SetFont('Arial','',8);
		$CI->pdf_lib->Cell(30,10,utf8_decode($prospecto->domicilio),0,0,'L');
		$CI->pdf_lib->Ln(4);
		$CI->pdf_lib->Cell(30,10,utf8_decode($prospecto->domicilio2),0,0,'L');

		$CI->pdf_lib->Ln(10);

		$CI->pdf_lib->SetFont('Arial','',10);
		$CI->pdf_lib->MultiCell(0,5,utf8_decode("Por este medio pongo a su consideración, la cotización que amablemente nos solicitó y que a continuación se detalla:"),0,"J");

		$CI->pdf_lib->Ln(5);
		
		//Datos
		$CI->pdf_lib->SetFont('Arial','',8);
		$importe_total = 0;
		foreach ($cotizacion as $value){
			$CI->pdf_lib->SetFont('Arial','',8);
			$CI->pdf_lib->Cell(191,5,utf8_decode("DESCRIPCIÓN"),1,0,'C');
			$CI->pdf_lib->Ln();
			$CI->pdf_lib->MultiCell(191,5,utf8_decode($value->detalles),1,"J");
				
			$CI->pdf_lib->SetFont('Arial','B',8);
			$CI->pdf_lib->Cell(40,5,utf8_decode("PRECIO"),0,0,'J');
			$CI->pdf_lib->Cell(0,5,"$ ".number_format($value->precio,2),0,0,'J');
			$CI->pdf_lib->Ln(10);

			$importe_total += $value->precio;
		}

		$CI->pdf_lib->SetFont('Arial','B',8);
		$CI->pdf_lib->Cell(40,5,utf8_decode("--- GRAN TOTAL ---"),0,0,'J');
		$CI->pdf_lib->Cell(0,5,"$ ".number_format($importe_total,2),0,0,'J');
		$CI->pdf_lib->Ln(10);

		$CI->pdf_lib->SetFont('Arial','',10);
		$CI->pdf_lib->MultiCell(0,5,utf8_decode("Esta cotizacion tendra una vigencia de 30 dias naturales"),0,"J");

		$CI->pdf_lib->Ln(5);

		$CI->pdf_lib->SetFont('Arial','B',10);
		$CI->pdf_lib->MultiCell(0,5,utf8_decode("Una vez entregada la unidad al productor la garantía será de 18 meses ó 1,500 horas en el tractor,garantizamos refacciones y accesorios están disponibles en cualquiera de nuestras sucursales, para el mantenimiento permanente."),0,"J");

		$CI->pdf_lib->Ln(5);

		$CI->pdf_lib->SetFont('Arial','',10);
		$CI->pdf_lib->MultiCell(0,5,utf8_decode("Sin otro particular y en espera que esta cotización sea de su agrado, me es grato quedar a sus órdenes para cualquier duda o aclaración al respecto"),0,"J");

		$CI->pdf_lib->Ln(10);

		$CI->pdf_lib->SetFont('Arial','B',10);
		$CI->pdf_lib->MultiCell(0,5,utf8_decode("ATENTAMENTE"),0,"C");

		$CI->pdf_lib->Ln(15);

		$CI->pdf_lib->SetFont('Arial','',10);
		$CI->pdf_lib->MultiCell(0,5,utf8_decode($cotizacion[0]->encargado),0,"C");

		$CI->pdf_lib->Ln(1);

		$CI->pdf_lib->SetFont('Arial','',10);
		$CI->pdf_lib->MultiCell(0,5,utf8_decode("GERENTE DE VENTAS"),0,"C");
		

        $CI->pdf_lib->Output("Cotizacion.pdf", 'I');
	}

}