<?php if ( ! defined('BASEPATH')) exit('No esta permitido el acceso');//La primera línea impide el acceso directo a este script

// Incluimos el archivo fpdf
require_once APPPATH."/third_party/fpdf/fpdf.php";

class Pdf_lib extends FPDF {

	public function __construct($datos){
		parent::__construct();
		$this->fecha = $datos["fecha"];
		$this->folio = $datos["folio"];
		$this->domicilio = $datos["domicilio"];
		$this->sucursal = $datos["nombre"];
	}

	//Encabezado
	public function Header(){
		$date = new DateTime($this->fecha);
		$mes = $date->format("F");
		if ($mes=="January") $mes="Enero";
		if ($mes=="February") $mes="Febrero";
		if ($mes=="March") $mes="Marzo";
		if ($mes=="April") $mes="Abril";
		if ($mes=="May") $mes="Mayo";
		if ($mes=="June") $mes="Junio";
		if ($mes=="July") $mes="Julio";
		if ($mes=="August") $mes="Agosto";
		if ($mes=="September") $mes="Septiembre";
		if ($mes=="October") $mes="Octubre";
		if ($mes=="November") $mes="Noviembre";
		if ($mes=="December") $mes="Diciembre";
		//Logo
		$this->Image('dist/images/grupo.jpg',10,5,30);
		//fuente, tamaño y familia
		$this->SetFont('Arial','',12);
		//Titulo
		$this->Cell(0,0,utf8_decode('Agrotractores del Sureste S.A. de C.V.'),0,0,'R');
		//Salto de Linea
		$this->Ln(4);
		//direccion
		//fuente, tamaño y familia
		$this->SetFont('Arial','',7);
		$this->Cell(0,0,utf8_decode('Av. Universidad N° 160 Col. Ex-Hacienda Candiani, Oaxaca, Oax. C.P. 68130 Tel. 4-65-00 Ext. 4001, Ext. 4003'),0,0,'R');
		$this->Ln(4);
		$this->Cell(0,0,"RFC: ASU860529SC3",0,0,'R');
		$this->Ln(8);
        $this->SetFont('Arial','B',10);
        $this->SetTextColor(194,8,8); //Letra color blanco
		$this->Cell(0,0,utf8_decode("Folio Cotización: ").$this->folio,0,0,'R');
		$this->Ln(8);
        $this->SetFont('Arial','B',10);
        $this->SetTextColor(0,0,0); //Letra color blanco
		$this->Cell(0,0,"Oaxaca, Oax., a ".$date->format('d')." de ".$mes." del ".$date->format('Y')." siendo la(s) ".$date->format('h').":".$date->format('i').":".$date->format('s')." ".$date->format('A'),0,0,'R');
		$this->Ln(5);
	}

	public function Footer(){
		//Posición: a 2.0 cm del Final
		//$this->SetY(-50);
		$this->SetY(-25);
		//Arial italic 8
		$this->SetFont('Arial','I',8);
		//Número de Página
		$this->Cell(92,10,utf8_decode('ELABORÓ: '.get_instance()->session->userdata('nombre')),0,0,'C');
		$this->Cell(92,10,'Pagina '.$this->PageNo().'/{nb}',0,0,'C');
		//Salto de Linea
		$this->SetFont('Arial','BI',8);
		$this->Ln(10);
		$this->Cell(0,0,"Sucursal: ".$this->sucursal,0,0,'L');
		$this->SetFont('Arial','I',8);
		$this->Ln(4);
		$this->Cell(0,0,"--- ".utf8_decode($this->domicilio)." ---",0,0,'C');
	}

}

?>