<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Model_Agenda extends CI_Model{

	function __construct(){
		parent::__construct();

		//conexion para otra base de datos (gopac)
		$this->tractoCRM = $this->load->database("tractoCRM",TRUE);
	}

	function cargar_status(){
		$query = $this->db->query("SELECT * FROM cat_status_seguimiento WHERE status='A'");
		return $query->result();
	}

	function cargar_cat_actividad_status_seguimiento(){
		$query = $this->db->query("SELECT * FROM cat_actividad_status_seguimiento WHERE status='A'");
		return $query->result();
	}

	function cargar_prospecto($fk_cat_personal){
		$query = $this->db->query("SELECT p.pk_prospecto,upc.pk_u_prospecto_ciclo,p.nombre,p.razon_social 
									FROM prospecto p, u_prospecto_ciclo upc 
									WHERE p.pk_prospecto=upc.fk_prospecto and upc.concluido='NO' and p.status='A' and upc.fk_cat_personal=".$fk_cat_personal);
		return $query->result();
	}

	/* function cargar_prospecto($articulo_maestro){
		$query = $this->db->query("SELECT p.pk_prospecto,upc.pk_u_prospecto_ciclo,p.nombre,p.razon_social 
									FROM prospecto p, u_prospecto_ciclo upc 
									WHERE p.pk_prospecto=upc.fk_prospecto and upc.concluido='NO' and p.status='A' and upc.articulo_maestro='".$articulo_maestro."'");
		return $query->result();
	} */

	function buscar_prospecto($fk_cat_personal,$texto){
		$query = $this->db->query("SELECT p.pk_prospecto,upc.pk_u_prospecto_ciclo,p.nombre,p.razon_social 
									FROM prospecto p, u_prospecto_ciclo upc 
									WHERE p.pk_prospecto=upc.fk_prospecto and upc.concluido='NO' and p.status='A' 
										and (p.nombre LIKE '%".$texto."%' OR p.razon_social LIKE '%".$texto."%') 
										and upc.fk_cat_personal=".$fk_cat_personal);
		return $query->result();
	}

	function v_info_prospecto($pk_u_prospecto_ciclo){
		$query = $this->db->query("SELECT * FROM v_info_prospecto WHERE pk_u_prospecto_ciclo=".$pk_u_prospecto_ciclo);
		return $query->row();
	}

	function flotilla_actual($pk_u_prospecto_ciclo){
		$query = $this->db->query("SELECT * FROM flotilla_actual WHERE fk_u_prospecto_ciclo=".$pk_u_prospecto_ciclo);
		return $query->result();
	}

	function equipo_solicitado($pk_u_prospecto_ciclo){
		$query = $this->db->query("SELECT es.pk_equipo_solicitado,CONCAT_WS(' - ',vm.tipo_articulo,vm.grupo,vm.subgrupo,vm.marca,vm.modelo) as equipo,es.cantidad 
									FROM v_modelos vm, equipo_solicitado es 
									WHERE es.fk_cat_modelo=vm.pk_cat_modelo and es.fk_u_prospecto_ciclo=".$pk_u_prospecto_ciclo);
		return $query->result();
	}

	function localizacion_ad($pk_u_prospecto_ciclo){
		$query = $this->db->query("SELECT * FROM localizacion_ad WHERE fk_u_prospecto_ciclo=".$pk_u_prospecto_ciclo);
		return $query->result();
	}

	function refaccion_solicitada($pk_u_prospecto_ciclo){
		$query = $this->db->query("SELECT * FROM refaccion_solicitada WHERE fk_u_prospecto_ciclo=".$pk_u_prospecto_ciclo);
		return $query->result();
	}

	function servicio_solicitada($pk_u_prospecto_ciclo){
		$query = $this->db->query("SELECT
										servicio.descripcion as servicio,
										servicio_solicitada.codigo,
										servicio_solicitada.descripcion_trabajo,
										servicio_solicitada.numero_parte,
										servicio_solicitada.descripcion_parte,
										servicio_solicitada.capacidad,
										servicio_solicitada.tipo_fluido,
										servicio_solicitada.cantidad,
										servicio_solicitada.horas,
										cat_modelo.descripcion as unidad,
										servicio_solicitada.status 
									FROM
										cat_modelo
										INNER JOIN servicio_solicitada ON cat_modelo.pk_cat_modelo = servicio_solicitada.fk_cat_modelo
										INNER JOIN servicio ON servicio_solicitada.fk_servicio = servicio.pk_servicio 
									WHERE
										servicio_solicitada.fk_u_prospecto_ciclo=".$pk_u_prospecto_ciclo);
		return $query->result();
	}

	function agenda($pk_u_prospecto_ciclo){
		$query = $this->db->query("SELECT a.pk_agenda,a.fecha,a.fecha_actividad,a.lugar,a.observaciones,a.realizada,
										a.fecha_realizada,css.descripcion as status_actividad,cass.descripcion as actividad,
										a.observaciones_realizada,a.articulo_maestro 
									FROM agenda a, cat_status_seguimiento css, cat_actividad_status_seguimiento cass 
									WHERE a.fk_cat_status_seguimiento=css.pk_cat_status_seguimiento and 
										a.fk_cat_actividad_status_seguimiento=cass.pk_cat_actividad_status_seguimiento 
										and fk_u_prospecto_ciclo=".$pk_u_prospecto_ciclo."
									ORDER BY realizada,fecha_realizada DESC");
		return $query->result();
	}

	function cargar_cat_anexos(){
		$query = $this->db->query("SELECT * FROM cat_anexos WHERE status='A'");
		return $query->result();
	}

	function cargar_tipo_articulo(){
		$query = $this->db->query("SELECT * FROM cat_tipo_articulo WHERE status='A'");
		return $query->result();
	}

	function cargar_gpo_catalogo($pk){
		$query = $this->db->query("SELECT * FROM gpo_catalogo WHERE status='A' and fk_cat_tipo_articulo=".$pk);
		return $query->result();
	}

	function cargar_subgpo_catalogo($pk){
		$query = $this->db->query("SELECT * FROM subgpo_catalogo WHERE status='A' and fk_gpo_catalogo=".$pk);
		return $query->result();
	}

	function cargar_cat_marca($pk){
		$query = $this->db->query("SELECT * FROM cat_marca WHERE status='A' and fk_subgpo_catalogo=".$pk);
		return $query->result();
	}

	function cargar_cat_modelo($pk){
		$query = $this->db->query("SELECT * FROM cat_modelo WHERE status='A' and fk_cat_marca=".$pk);
		return $query->result();
	}

	function inventRefaccion(){
		//$this->tractoCRM->order_by('refaccionDescripcion');
		//$query = $this->tractoCRM->get('inventRefaccion');
		$query = $this->tractoCRM->query("SELECT CONCAT(refaccionId,'|',refaccionGrupo,'|',refaccionNumero,'|',refaccionDescripcion) as refaccionId,refaccionDescripcion
											FROM inventRefaccion
											ORDER BY refaccionDescripcion");
		return $query->result();
	}

	function servicio(){
		$query = $this->db->query("SELECT * FROM servicio");
		return $query->result();
	}

	function unidades_plantilla($pk_servicio){
		$query = $this->db->query("SELECT
										v_unidades.pk_cat_modelo,
										v_unidades.descripcion 
									FROM
										v_unidades
										INNER JOIN det_servicio ON v_unidades.pk_cat_modelo = det_servicio.fk_cat_modelo 
									WHERE
										det_servicio.fk_servicio = ".$pk_servicio." 
									GROUP BY
										v_unidades.pk_cat_modelo");
		return $query->result();
	}

	function detalle_unidad_plantilla($pk_cat_modelo,$pk_servicio){
		$query = $this->db->query("SELECT
										det_servicio.pk_det_servicio,
										det_servicio.codigo,
										det_servicio.descripcion_trabajo,
										det_servicio.numero_parte,
										det_servicio.descripcion_parte,
										det_servicio.capacidad,
										det_servicio.tipo_fluido,
										det_servicio.cantidad,
										det_servicio.horas,
										det_servicio.status 
									FROM
										servicio
										INNER JOIN det_servicio ON servicio.pk_servicio = det_servicio.fk_servicio 
									WHERE
										det_servicio.fk_cat_modelo = ".$pk_cat_modelo." 
										AND det_servicio.fk_servicio = ".$pk_servicio."");
		return $query->result();
	}

	function validar_ciclo($pk_prospecto,$articulo_maestro){
		$query = $this->db->query("SELECT * FROM u_prospecto_ciclo WHERE fk_prospecto=".$pk_prospecto." and articulo_maestro='".$articulo_maestro."' and concluido='NO'" );
		return $query->row();
	}

	function datos_prospecto($pk_prospecto){
		$query = $this->db->query("SELECT * FROM u_prospecto_ciclo WHERE fk_prospecto=".$pk_prospecto." and concluido='NO';");
		return $query->row();
	}

	function obtener_gerente_articulo_maestro($articulo_maestro){// 2 = Gerente General
		$query = $this->db->query("SELECT * FROM cat_personal WHERE fk_cat_tipo_usuario=2 and articulo_maestro='".$articulo_maestro."' and status='A'");
		return $query->row();
	}

	function update_agenda($registro){
		$this->db->set($registro);
		$this->db->where('pk_agenda',$registro['pk_agenda']);
		$this->db->update('agenda');
	}

	function update_tabla($pk_campo,$tabla,$registro){
		$this->db->set($registro);
		$this->db->where($pk_campo,$registro[$pk_campo]);
		$this->db->update($tabla);
	}

	function insert($registro,$tabla){
		$this->db->set($registro);
		$this->db->insert($tabla);
	}

	function insert_u_prospecto_ciclo($registro){
		$this->db->set($registro);
		$this->db->insert("u_prospecto_ciclo");
		$pk = $this->db->insert_id();
		return $pk;
	}

}