<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Model_Cotizacion extends CI_Model{

	function __construct(){
		parent::__construct();

		//conexion para otra base de datos (gopac)
		$this->tractoCRM = $this->load->database("tractoCRM",TRUE);
	}

	function cargar_prospecto($fk_cat_personal){
		$query = $this->db->query("SELECT p.pk_prospecto,upc.pk_u_prospecto_ciclo,p.nombre,p.razon_social 
									FROM prospecto p, u_prospecto_ciclo upc 
									WHERE p.pk_prospecto=upc.fk_prospecto and upc.concluido='NO' and p.status='A' and upc.fk_cat_personal=".$fk_cat_personal);
		return $query->result();
	}

	/* function cargar_prospecto($articulo_maestro){
		$query = $this->db->query("SELECT p.pk_prospecto,upc.pk_u_prospecto_ciclo,p.nombre,p.razon_social 
									FROM prospecto p, u_prospecto_ciclo upc 
									WHERE p.pk_prospecto=upc.fk_prospecto and upc.concluido='NO' and p.status='A' and upc.articulo_maestro='".$articulo_maestro."'");
		return $query->result();
	} */

	function buscar_prospecto($fk_cat_personal,$texto){
		$query = $this->db->query("SELECT p.pk_prospecto,upc.pk_u_prospecto_ciclo,p.nombre,p.razon_social 
									FROM prospecto p, u_prospecto_ciclo upc 
									WHERE p.pk_prospecto=upc.fk_prospecto and upc.concluido='NO' and p.status='A' 
										and (p.nombre LIKE '%".$texto."%' OR p.razon_social LIKE '%".$texto."%') 
										and upc.fk_cat_personal=".$fk_cat_personal);
		return $query->result();
	}

	function v_info_prospecto($pk_u_prospecto_ciclo){
		$query = $this->db->query("SELECT * FROM v_info_prospecto WHERE pk_u_prospecto_ciclo=".$pk_u_prospecto_ciclo);
		return $query->row();
	}

	function equipo_solicitado($pk_u_prospecto_ciclo){
		$query = $this->db->query("SELECT DISTINCT es.pk_equipo_solicitado as pk_solicitado
										,CONCAT_WS(' - ',vm.tipo_articulo,vm.grupo,vm.subgrupo,vm.marca,vm.modelo) as equipo,
										es.cantidad,vm.precio,vm.detalles,es.status,
									    CASE
											WHEN es.fk_cat_rechazo != 0 
												THEN cr.descripcion
											ELSE
												'NINGUNO'
										END
										as rechazo
									FROM v_modelos vm, equipo_solicitado es, cat_rechazo cr 
									WHERE es.fk_cat_modelo=vm.pk_cat_modelo and es.fk_u_prospecto_ciclo=".$pk_u_prospecto_ciclo." and 
										CASE
											WHEN es.fk_cat_rechazo != 0 
												THEN es.fk_cat_rechazo=cr.pk_cat_rechazo
											ELSE
												es.fk_cat_modelo=vm.pk_cat_modelo
										END");
		return $query->result();
	}

	function refaccion_solicitada($pk_u_prospecto_ciclo){
		$query = $this->db->query("SELECT pk_refaccion_solicitada as pk_solicitado
										,CONCAT_WS(' - ',descripcion_trabajo,descripcion_parte,numero_parte) as equipo
										,cantidad
										,0 as precio
										,status
										,IF(fk_cat_rechazo != 0,(SELECT descripcion FROM cat_rechazo WHERE pk_cat_rechazo=fk_cat_rechazo),'NINGUNO') as rechazo
									FROM refaccion_solicitada 
									WHERE fk_u_prospecto_ciclo=".$pk_u_prospecto_ciclo);
		return $query->result();
	}

	function servicio_solicitada($pk_u_prospecto_ciclo){
		$query = $this->db->query("SELECT pk_servicio_solicitada as pk_solicitado
										,CONCAT_WS(' - ',descripcion_trabajo,descripcion_parte,numero_parte) as equipo
										,cantidad
										,0 as precio
										,status
										,IF(fk_cat_rechazo != 0,(SELECT descripcion FROM cat_rechazo WHERE pk_cat_rechazo=fk_cat_rechazo),'NINGUNO') as rechazo
									FROM servicio_solicitada 
									WHERE fk_u_prospecto_ciclo=".$pk_u_prospecto_ciclo);
		return $query->result();
	}

	function cat_rechazo(){
		$query = $this->db->query("SELECT * FROM cat_rechazo WHERE status='A'");
		return $query->result();
	}

	function cargar_tipo_articulo(){
		$query = $this->db->query("SELECT * FROM cat_tipo_articulo WHERE status='A'");
		return $query->result();
	}

	function cargar_gpo_catalogo($pk){
		$query = $this->db->query("SELECT * FROM gpo_catalogo WHERE status='A' and fk_cat_tipo_articulo=".$pk);
		return $query->result();
	}

	function cargar_subgpo_catalogo($pk){
		$query = $this->db->query("SELECT * FROM subgpo_catalogo WHERE status='A' and fk_gpo_catalogo=".$pk);
		return $query->result();
	}

	function cargar_cat_marca($pk){
		$query = $this->db->query("SELECT * FROM cat_marca WHERE status='A' and fk_subgpo_catalogo=".$pk);
		return $query->result();
	}

	function cargar_cat_modelo($pk){
		$query = $this->db->query("SELECT * FROM cat_modelo WHERE status='A' and fk_cat_marca=".$pk);
		return $query->result();
	}

	function prospecto_impresion($pk_u_prospecto_ciclo){
		$query = $this->db->query("SELECT p.pk_prospecto,upc.pk_u_prospecto_ciclo,p.nombre,p.razon_social,p.rfc,
										CONCAT_WS(' ',cg.calle,CONCAT('#',cg.num_ext),cg.num_int,CONCAT('C.P. ',cg.cp),cg.colonia,cg.localidad) as domicilio,
										CONCAT_WS(', ',cg.municipio,cg.ciudad,cg.estado,cg.pais) as domicilio2  
									FROM prospecto p, u_prospecto_ciclo upc, cat_generales cg 
									WHERE p.pk_prospecto=upc.fk_prospecto and upc.concluido='NO' and p.status='A' and p.fk_cat_generales=cg.pk_cat_generales and 
										upc.pk_u_prospecto_ciclo=".$pk_u_prospecto_ciclo);
		return $query->row();
	}

	function prefijo($pk_cat_sucursal){
		$query = $this->db->query("SELECT CAST(CONCAT((SELECT CONCAT('C',prefijo) 
														FROM cat_sucursal 
									                    WHERE pk_cat_sucursal=".$pk_cat_sucursal."),MAX(CAST(SUBSTRING(folio,5) as SIGNED))+1) as CHAR) as folio 
									FROM cotizacion WHERE fk_cat_sucursal=".$pk_cat_sucursal."
									UNION ALL
									SELECT CONCAT('C',prefijo) FROM cat_sucursal WHERE pk_cat_sucursal=".$pk_cat_sucursal);
		return $query->result();
	}

	function obtener_cotizacion($pk_cotizacion){
		$query = $this->db->query("SELECT c.fecha,c.folio,CONCAT_WS(' - ',vm.tipo_articulo,vm.grupo,vm.subgrupo,vm.marca,vm.modelo) as equipo,dc.precio,vm.detalles,cs.nombre,cs.encargado,
										CONCAT_WS(' ',cg.calle,CONCAT('Nº',cg.num_int),CONCAT('Col.',cg.colonia),', ',cg.municipio,', ',cg.estado,'. C,P. ',cg.cp,' Tel. ',cg.telefono) as domicilio 
									FROM v_modelos vm, cotizacion c, det_cotizacion dc, equipo_solicitado es, cat_sucursal cs, cat_generales cg 
									WHERE dc.fk_cotizacion=c.pk_cotizacion and dc.fk_equipo_solicitado=es.pk_equipo_solicitado and 
										c.fk_cat_sucursal=cs.pk_cat_sucursal and cs.fk_cat_generales=cg.pk_cat_generales  
										and es.fk_cat_modelo=vm.pk_cat_modelo and c.pk_cotizacion=".$pk_cotizacion);
		return $query->result();
	}

	function obtener_cotizacion_refa($pk_cotizacion){
		$query = $this->db->query("SELECT c.fecha,c.folio,CONCAT_WS(' - ',vm.tipo_articulo,vm.grupo,vm.subgrupo,vm.marca,vm.modelo) as equipo,dc.precio,vm.detalles,cs.nombre,cs.encargado,
										CONCAT_WS(' ',cg.calle,CONCAT('Nº',cg.num_int),CONCAT('Col.',cg.colonia),', ',cg.municipio,', ',cg.estado,'. C,P. ',cg.cp,' Tel. ',cg.telefono) as domicilio 
									FROM v_modelos vm, cotizacion c, det_cotizacion dc, equipo_solicitado es, cat_sucursal cs, cat_generales cg 
									WHERE dc.fk_cotizacion=c.pk_cotizacion and dc.fk_equipo_solicitado=es.pk_equipo_solicitado and 
										c.fk_cat_sucursal=cs.pk_cat_sucursal and cs.fk_cat_generales=cg.pk_cat_generales  
										and es.fk_cat_modelo=vm.pk_cat_modelo and c.pk_cotizacion=".$pk_cotizacion);
		return $query->result();
	}

	function obtener_cotizacion_serv($pk_cotizacion){
		$query = $this->db->query("SELECT c.fecha,c.folio,CONCAT_WS(' - ',vm.tipo_articulo,vm.grupo,vm.subgrupo,vm.marca,vm.modelo) as equipo,dc.precio,vm.detalles,cs.nombre,cs.encargado,
										CONCAT_WS(' ',cg.calle,CONCAT('Nº',cg.num_int),CONCAT('Col.',cg.colonia),', ',cg.municipio,', ',cg.estado,'. C,P. ',cg.cp,' Tel. ',cg.telefono) as domicilio 
									FROM v_modelos vm, cotizacion c, det_cotizacion dc, equipo_solicitado es, cat_sucursal cs, cat_generales cg 
									WHERE dc.fk_cotizacion=c.pk_cotizacion and dc.fk_equipo_solicitado=es.pk_equipo_solicitado and 
										c.fk_cat_sucursal=cs.pk_cat_sucursal and cs.fk_cat_generales=cg.pk_cat_generales  
										and es.fk_cat_modelo=vm.pk_cat_modelo and c.pk_cotizacion=".$pk_cotizacion);
		return $query->result();
	}

	function inventRefaccion(){
		//$this->tractoCRM->order_by('refaccionDescripcion');
		//$query = $this->tractoCRM->get('inventRefaccion');
		$query = $this->tractoCRM->query("SELECT CONCAT(refaccionId,'|',refaccionGrupo,'|',refaccionNumero,'|',refaccionDescripcion) as refaccionId,refaccionDescripcion
											FROM inventRefaccion
											ORDER BY refaccionDescripcion");
		return $query->result();
	}

	function servicio(){
		$query = $this->db->query("SELECT * FROM servicio");
		return $query->result();
	}

	function unidades_plantilla($pk_servicio){
		$query = $this->db->query("SELECT
										v_unidades.pk_cat_modelo,
										v_unidades.descripcion 
									FROM
										v_unidades
										INNER JOIN det_servicio ON v_unidades.pk_cat_modelo = det_servicio.fk_cat_modelo 
									WHERE
										det_servicio.fk_servicio = ".$pk_servicio." 
									GROUP BY
										v_unidades.pk_cat_modelo");
		return $query->result();
	}

	function detalle_unidad_plantilla($pk_cat_modelo,$pk_servicio){
		$query = $this->db->query("SELECT
										det_servicio.pk_det_servicio,
										det_servicio.codigo,
										det_servicio.descripcion_trabajo,
										det_servicio.numero_parte,
										det_servicio.descripcion_parte,
										det_servicio.capacidad,
										det_servicio.tipo_fluido,
										det_servicio.cantidad,
										det_servicio.horas,
										det_servicio.status 
									FROM
										servicio
										INNER JOIN det_servicio ON servicio.pk_servicio = det_servicio.fk_servicio 
									WHERE
										det_servicio.fk_cat_modelo = ".$pk_cat_modelo." 
										AND det_servicio.fk_servicio = ".$pk_servicio."");
		return $query->result();
	}

	function insert_cotizacion($registro){
		$this->db->set($registro);
		$this->db->insert("cotizacion");
		$pk = $this->db->insert_id();
		return $pk;
	}

	function insert($registro,$tabla){
		$this->db->set($registro);
		$this->db->insert($tabla);
	}

	function update_status($pk,$registro,$tabla){
		$this->db->where('pk_'.$tabla.'',$pk);
		$this->db->update($tabla,$registro);
	}

}