<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Model_Nuevo extends CI_Model{

	function __construct(){
		parent::__construct();

		//conexion para otra base de datos (gopac)
		$this->tractoCRM = $this->load->database("tractoCRM",TRUE);
	}

	function cargar_actividades(){
		$query = $this->db->query("SELECT * FROM cat_actividad WHERE status='A'	ORDER BY descripcion");
		return $query->result();
	}

	function cargar_tipo_actividades($pk_actividad){
		$query = $this->db->query("SELECT cta.pk_cat_tipo_actividad,cta.descripcion,ca.descripcion as actividad,cta.status 
									FROM cat_tipo_actividad cta, cat_actividad ca 
									WHERE cta.fk_cat_actividad=ca.pk_cat_actividad and cta.fk_cat_actividad='".$pk_actividad."'
									ORDER BY cta.descripcion");
		return $query->result();
	}

	function cargar_probabilidades_compra(){
		$query = $this->db->query("SELECT * FROM cat_probabilidad_compra WHERE status='A'");
		return $query->result();
	}

	function cargar_condiciones_pago(){
		$query = $this->db->query("SELECT * FROM cat_condiciones_pago WHERE status='A'");
		return $query->result();
	}

	function cargar_plazo_pago(){
		$query = $this->db->query("SELECT * FROM cat_plazo_pago WHERE status='A'");
		return $query->result();
	}

	function cargar_status(){
		$query = $this->db->query("SELECT * FROM cat_status_seguimiento WHERE status='A'");
		return $query->result();
	}

	function cargar_tipo_articulo(){
		$query = $this->db->query("SELECT * FROM cat_tipo_articulo WHERE status='A'");
		return $query->result();
	}

	function cargar_gpo_catalogo($pk){
		$query = $this->db->query("SELECT * FROM gpo_catalogo WHERE status='A' and fk_cat_tipo_articulo=".$pk);
		return $query->result();
	}

	function cargar_subgpo_catalogo($pk){
		$query = $this->db->query("SELECT * FROM subgpo_catalogo WHERE status='A' and fk_gpo_catalogo=".$pk);
		return $query->result();
	}

	function cargar_cat_marca($pk){
		$query = $this->db->query("SELECT * FROM cat_marca WHERE status='A' and fk_subgpo_catalogo=".$pk);
		return $query->result();
	}

	function cargar_cat_modelo($pk){
		$query = $this->db->query("SELECT * FROM cat_modelo WHERE status='A' and fk_cat_marca=".$pk);
		return $query->result();
	}

	function v_unidades($pk){
		$query = $this->db->query("SELECT * FROM v_unidades WHERE pk_cat_modelo=".$pk);
		return $query->row();
	}

	function inventRefaccion(){
		//$this->tractoCRM->order_by('refaccionDescripcion');
		//$query = $this->tractoCRM->get('inventRefaccion');
		$query = $this->tractoCRM->query("SELECT CONCAT(refaccionId,'|',refaccionGrupo,'|',refaccionNumero,'|',refaccionDescripcion) as refaccionId,refaccionDescripcion
											FROM inventRefaccion
											ORDER BY refaccionDescripcion");
		return $query->result();
	}

	function servicio(){
		$query = $this->db->query("SELECT * FROM servicio");
		return $query->result();
	}

	function unidades_plantilla($pk_servicio){
		$query = $this->db->query("SELECT
										v_unidades.pk_cat_modelo,
										v_unidades.descripcion 
									FROM
										v_unidades
										INNER JOIN det_servicio ON v_unidades.pk_cat_modelo = det_servicio.fk_cat_modelo 
									WHERE
										det_servicio.fk_servicio = ".$pk_servicio." 
									GROUP BY
										v_unidades.pk_cat_modelo");
		return $query->result();
	}

	function detalle_unidad_plantilla($pk_cat_modelo,$pk_servicio){
		$query = $this->db->query("SELECT
										det_servicio.pk_det_servicio,
										det_servicio.codigo,
										det_servicio.descripcion_trabajo,
										det_servicio.numero_parte,
										det_servicio.descripcion_parte,
										det_servicio.capacidad,
										det_servicio.tipo_fluido,
										det_servicio.cantidad,
										det_servicio.horas,
										det_servicio.status 
									FROM
										servicio
										INNER JOIN det_servicio ON servicio.pk_servicio = det_servicio.fk_servicio 
									WHERE
										det_servicio.fk_cat_modelo = ".$pk_cat_modelo." 
										AND det_servicio.fk_servicio = ".$pk_servicio."");
		return $query->result();
	}

	function cargar_cat_anexos(){
		$query = $this->db->query("SELECT * FROM cat_anexos WHERE status='A'");
		return $query->result();
	}

	function cargar_cat_actividad_status_seguimiento(){
		$query = $this->db->query("SELECT * FROM cat_actividad_status_seguimiento WHERE status='A'");
		return $query->result();
	}

	function obtener_gerente_articulo_maestro($articulo_maestro){// 2 = Gerente General
		$query = $this->db->query("SELECT * FROM cat_personal WHERE fk_cat_tipo_usuario=2 and articulo_maestro='".$articulo_maestro."' and status='A'");
		return $query->row();
	}

	function insert_cat_general($registro){
		$this->db->set($registro);
		$this->db->insert("cat_generales");
		$pk = $this->db->insert_id();
		return $pk;
	}

	function insert_prospecto($registro){
		$this->db->set($registro);
		$this->db->insert("prospecto");
		$pk = $this->db->insert_id();
		return $pk;
	}

	function insert_u_prospecto_ciclo($registro){
		$this->db->set($registro);
		$this->db->insert("u_prospecto_ciclo");
		$pk = $this->db->insert_id();
		return $pk;
	}

	function insert($registro,$tabla){
		$this->db->set($registro);
		$this->db->insert($tabla);
	}

}