<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Model_Postventa extends CI_Model{

	function __construct(){
		parent::__construct();
	}

	function cargar_status(){
		$query = $this->db->query("SELECT * FROM cat_status_seguimiento WHERE status='A'");
		return $query->result();
	}

	function cargar_cat_actividad_status_seguimiento(){
		$query = $this->db->query("SELECT * FROM cat_actividad_status_seguimiento WHERE status='A'");
		return $query->result();
	}

	function cargar_prospecto($fk_cat_personal){
		$query = $this->db->query("SELECT p.pk_prospecto,upc.pk_u_prospecto_ciclo,p.nombre,p.razon_social 
									FROM prospecto p, u_prospecto_ciclo upc 
									WHERE p.pk_prospecto=upc.fk_prospecto and upc.concluido='SI' and p.status='A' and upc.fk_cat_personal=".$fk_cat_personal);
		return $query->result();
	}

	function buscar_prospecto($fk_cat_personal,$texto){
		$query = $this->db->query("SELECT p.pk_prospecto,upc.pk_u_prospecto_ciclo,p.nombre,p.razon_social 
									FROM prospecto p, u_prospecto_ciclo upc 
									WHERE p.pk_prospecto=upc.fk_prospecto and upc.concluido='SI' and p.status='A' 
										and (p.nombre LIKE '%".$texto."%' OR p.razon_social LIKE '%".$texto."%') 
										and upc.fk_cat_personal=".$fk_cat_personal);
		return $query->result();
	}

	function v_info_prospecto($pk_u_prospecto_ciclo){
		$query = $this->db->query("SELECT * FROM v_info_prospecto WHERE pk_u_prospecto_ciclo=".$pk_u_prospecto_ciclo);
		return $query->row();
	}

	function flotilla_actual($pk_u_prospecto_ciclo){
		$query = $this->db->query("SELECT * FROM flotilla_actual WHERE fk_u_prospecto_ciclo=".$pk_u_prospecto_ciclo);
		return $query->result();
	}

	function equipo_solicitado($pk_u_prospecto_ciclo){
		$query = $this->db->query("SELECT es.pk_equipo_solicitado,CONCAT_WS(' - ',vm.tipo_articulo,vm.grupo,vm.subgrupo,vm.marca,vm.modelo) as equipo,es.cantidad 
									FROM v_modelos vm, equipo_solicitado es 
									WHERE es.fk_cat_modelo=vm.pk_cat_modelo and es.fk_u_prospecto_ciclo=".$pk_u_prospecto_ciclo);
		return $query->result();
	}

	function localizacion_ad($pk_u_prospecto_ciclo){
		$query = $this->db->query("SELECT * FROM localizacion_ad WHERE fk_u_prospecto_ciclo=".$pk_u_prospecto_ciclo);
		return $query->result();
	}

	function equipo_comprado($pk_u_prospecto_ciclo){
		$query = $this->db->query("SELECT v.pk_venta,CONCAT_WS(' - ',vm.tipo_articulo,vm.grupo,vm.subgrupo,vm.marca,vm.modelo) as equipo,es.cantidad 
									FROM v_modelos vm, equipo_solicitado es, cotizacion c, det_cotizacion dc, venta v 
									WHERE v.fk_cotizacion=c.pk_cotizacion and c.pk_cotizacion=dc.fk_cotizacion and dc.fk_equipo_solicitado=es.pk_equipo_solicitado and
										es.fk_cat_modelo=vm.pk_cat_modelo and es.fk_u_prospecto_ciclo=".$pk_u_prospecto_ciclo);
		return $query->result();
	}

	function agenda($pk_u_prospecto_ciclo){
		$query = $this->db->query("SELECT a.pk_agenda,a.fecha,a.fecha_actividad,a.lugar,a.observaciones,a.realizada,
										a.fecha_realizada,css.descripcion as status_actividad,cass.descripcion as actividad,
										a.observaciones_realizada 
									FROM agenda a, cat_status_seguimiento css, cat_actividad_status_seguimiento cass 
									WHERE a.fk_cat_status_seguimiento=css.pk_cat_status_seguimiento and 
										a.fk_cat_actividad_status_seguimiento=cass.pk_cat_actividad_status_seguimiento 
										and fk_u_prospecto_ciclo=".$pk_u_prospecto_ciclo."
									ORDER BY realizada,fecha_realizada DESC");
		return $query->result();
	}

	function cargar_cat_anexos(){
		$query = $this->db->query("SELECT * FROM cat_anexos WHERE status='A'");
		return $query->result();
	}

	function cargar_actividades(){
		$query = $this->db->query("SELECT * FROM cat_actividad WHERE status='A'	ORDER BY descripcion");
		return $query->result();
	}

	function cargar_tipo_actividades($pk_actividad){
		$query = $this->db->query("SELECT cta.pk_cat_tipo_actividad,cta.descripcion,ca.descripcion as actividad,cta.status 
									FROM cat_tipo_actividad cta, cat_actividad ca 
									WHERE cta.fk_cat_actividad=ca.pk_cat_actividad and cta.fk_cat_actividad='".$pk_actividad."'
									ORDER BY cta.descripcion");
		return $query->result();
	}

	function cargar_probabilidades_compra(){
		$query = $this->db->query("SELECT * FROM cat_probabilidad_compra WHERE status='A'");
		return $query->result();
	}

	function cargar_condiciones_pago(){
		$query = $this->db->query("SELECT * FROM cat_condiciones_pago WHERE status='A'");
		return $query->result();
	}

	function cargar_plazo_pago(){
		$query = $this->db->query("SELECT * FROM cat_plazo_pago WHERE status='A'");
		return $query->result();
	}

	function update_agenda($registro){
		$this->db->set($registro);
		$this->db->where('pk_agenda',$registro['pk_agenda']);
		$this->db->update('agenda');
	}

	function insert_u_prospecto_ciclo($registro){
		$this->db->set($registro);
		$this->db->insert("u_prospecto_ciclo");
		$pk = $this->db->insert_id();
		return $pk;
	}

	function insert($registro,$tabla){
		$this->db->set($registro);
		$this->db->insert($tabla);
	}

}