<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Model_Analisis_Venta extends CI_Model{

	function __construct(){
		parent::__construct();
	}

	function sucursal(){
		$query = $this->db->query("SELECT * FROM cat_sucursal WHERE status='A' ORDER BY nombre");
		$num_rows = $query->num_rows();
		$query = $query->result();
		$query[$num_rows]->pk_cat_sucursal = '*';
		$query[$num_rows]->nombre = 'TODOS';
		return $query;
	}

	function ventas($fecha_inicio,$fecha_fin,$com_sql = "",$bandera = FALSE){
		$query = $this->db->query("SELECT SUBSTRING(v.fecha,6,2) as mes,COUNT(*) as tot,vm.tipo_articulo,v.fk_cat_sucursal,cs.nombre 
									FROM det_cotizacion dc, cotizacion c, equipo_solicitado es, v_modelos vm, venta v, cat_sucursal cs 
									WHERE dc.fk_cotizacion=c.pk_cotizacion and dc.fk_equipo_solicitado=es.pk_equipo_solicitado and 
										es.fk_cat_modelo=vm.pk_cat_modelo and v.fk_cotizacion=c.pk_cotizacion and v.fk_cat_sucursal=cs.pk_cat_sucursal and 
									    v.fecha BETWEEN STR_TO_DATE('".$fecha_inicio." 00:00:00','%Y-%m-%d %H:%i:%s') and STR_TO_DATE('".$fecha_fin." 23:59:59','%Y-%m-%d %H:%i:%s') ".$com_sql."
									GROUP BY vm.tipo_articulo,mes;");
		if($bandera)
			return $query->result_array();
		else
			return $query->result();
	}

	function prospecciones($fecha_inicio,$fecha_fin,$com_sql = "",$bandera = FALSE){
		$query = $this->db->query("SELECT SUBSTRING(a.fecha_realizada,6,2) as mes,COUNT(a.pk_agenda) as tot,cp.empleado_de 
									FROM agenda a, cat_personal cp 
									WHERE a.fk_cat_personal=cp.pk_cat_personal and a.realizada='SI' and 
										a.observaciones NOT LIKE 'Generación de cotización%' and 
										a.fecha_realizada BETWEEN STR_TO_DATE('".$fecha_inicio." 00:00:00','%Y-%m-%d %H:%i:%s') and STR_TO_DATE('".$fecha_fin." 23:59:59','%Y-%m-%d %H:%i:%s') ".$com_sql."
									GROUP BY mes;");
		if($bandera)
			return $query->result_array();
		else
			return $query->result();
	}

	function cotizaciones($fecha_inicio,$fecha_fin,$com_sql = "",$bandera = FALSE){
		$query = $this->db->query("SELECT SUBSTRING(c.fecha,6,2) as mes,COUNT(*) as tot,vm.tipo_articulo,c.fk_cat_sucursal,cs.nombre 
									FROM det_cotizacion dc, cotizacion c, equipo_solicitado es, v_modelos vm, cat_sucursal cs 
									WHERE dc.fk_cotizacion=c.pk_cotizacion and dc.fk_equipo_solicitado=es.pk_equipo_solicitado and 
										es.fk_cat_modelo=vm.pk_cat_modelo and c.tipo='DE VENTA' and c.fk_cat_sucursal=cs.pk_cat_sucursal and 
                                        c.fecha BETWEEN STR_TO_DATE('".$fecha_inicio." 00:00:00','%Y-%m-%d %H:%i:%s') and STR_TO_DATE('".$fecha_fin." 23:59:59','%Y-%m-%d %H:%i:%s') ".$com_sql."
                                    GROUP BY vm.tipo_articulo,mes;");
		if($bandera)
			return $query->result_array();
		else
			return $query->result();
	}

	function vta_perdidas($fecha_inicio,$fecha_fin,$com_sql = "",$bandera = FALSE){
		$query = $this->db->query("SELECT SUBSTRING(es.fecha_rechazo,6,2) as mes,COUNT(*) as tot,vm.tipo_articulo,cp.empleado_de 
									FROM equipo_solicitado es, v_modelos vm, u_prospecto_ciclo u, cat_personal cp 
									WHERE es.fk_cat_modelo=vm.pk_cat_modelo and es.fk_u_prospecto_ciclo=u.pk_u_prospecto_ciclo and 
										u.fk_cat_personal=cp.pk_cat_personal and 
										es.status='B' and es.fk_cat_rechazo!=0 and
                                        es.fecha_rechazo BETWEEN STR_TO_DATE('".$fecha_inicio." 00:00:00','%Y-%m-%d %H:%i:%s') and STR_TO_DATE('".$fecha_fin." 23:59:59','%Y-%m-%d %H:%i:%s') ".$com_sql."
                                    GROUP BY vm.tipo_articulo,mes;");
		if($bandera)
			return $query->result_array();
		else
			return $query->result();
	}

	function metas_ventas($anio,$com_sql_metas){
		$query = $this->db->query("SELECT cta.descripcion as articulo,
										u.cumplido,u.mes,u.anio,SUM(u.cantidad) as tot 
									FROM cat_metas cm, cat_tipo_articulo cta, cat_status_seguimiento css, union_personal_metas u 
									WHERE cm.fk_cat_tipo_articulo=cta.pk_cat_tipo_articulo and 
										cm.fk_cat_status_seguimiento=css.pk_cat_status_seguimiento and 
									    cm.pk_cat_metas=u.fk_cat_metas and cm.fk_cat_status_seguimiento=5 and u.anio=".$anio." ".$com_sql_metas."
                                        GROUP BY articulo,mes;");
		return $query->result_array();
	}

	function metas_prospecciones($anio,$com_sql_metas){
		$query = $this->db->query("SELECT u.cumplido,u.mes,u.anio,SUM(u.cantidad) as tot 
									FROM cat_metas cm, cat_tipo_articulo cta, cat_status_seguimiento css, union_personal_metas u 
									WHERE cm.fk_cat_tipo_articulo=cta.pk_cat_tipo_articulo and 
										cm.fk_cat_status_seguimiento=css.pk_cat_status_seguimiento and 
									    cm.pk_cat_metas=u.fk_cat_metas and cm.fk_cat_status_seguimiento=1 and u.anio=".$anio." ".$com_sql_metas."
                                        GROUP BY mes;");
		return $query->result_array();
	}

	function metas_cotizaciones($anio,$com_sql_metas){
		$query = $this->db->query("SELECT cta.descripcion as articulo,
										u.cumplido,u.mes,u.anio,SUM(u.cantidad) as tot 
									FROM cat_metas cm, cat_tipo_articulo cta, cat_status_seguimiento css, union_personal_metas u 
									WHERE cm.fk_cat_tipo_articulo=cta.pk_cat_tipo_articulo and 
										cm.fk_cat_status_seguimiento=css.pk_cat_status_seguimiento and 
									    cm.pk_cat_metas=u.fk_cat_metas and cm.fk_cat_status_seguimiento=2 and u.anio=".$anio." ".$com_sql_metas."
                                        GROUP BY articulo,mes;");
		return $query->result_array();
	}

	function cat_tipo_articulo(){
		$query = $this->db->query("SELECT * FROM cat_tipo_articulo WHERE status='A'");
		return $query->result();
	}

	function eje_ventas($fecha_inicio,$fecha_fin,$com_sql = "",$bandera = FALSE){
		$query = $this->db->query("SELECT SUBSTRING(v.fecha,6,2) as mes,COUNT(*) as tot,vm.tipo_articulo,CONCAT_WS(' ',cp.nombre,cp.apat,cp.amat) as ejecutivo 
									FROM det_cotizacion dc, cotizacion c, equipo_solicitado es, v_modelos vm, venta v, cat_sucursal cs, cat_personal cp 
									WHERE dc.fk_cotizacion=c.pk_cotizacion and dc.fk_equipo_solicitado=es.pk_equipo_solicitado and 
										v.fk_cat_personal=cp.pk_cat_personal and 
										es.fk_cat_modelo=vm.pk_cat_modelo and v.fk_cotizacion=c.pk_cotizacion and v.fk_cat_sucursal=cs.pk_cat_sucursal and 
									    v.fecha BETWEEN STR_TO_DATE('".$fecha_inicio." 00:00:00','%Y-%m-%d %H:%i:%s') and STR_TO_DATE('".$fecha_fin." 23:59:59','%Y-%m-%d %H:%i:%s') ".$com_sql."
									GROUP BY vm.tipo_articulo,mes,ejecutivo;");
		if($bandera)
			return $query->result_array();
		else
			return $query->result();
	}

	function eje_prospecciones($fecha_inicio,$fecha_fin,$com_sql = "",$bandera = FALSE){
		$query = $this->db->query("SELECT SUBSTRING(a.fecha_realizada,6,2) as mes,COUNT(a.pk_agenda) as tot,CONCAT_WS(' ',cp.nombre,cp.apat,cp.amat) as ejecutivo 
									FROM agenda a, cat_personal cp 
									WHERE a.fk_cat_personal=cp.pk_cat_personal and a.realizada='SI' and 
										a.observaciones NOT LIKE 'Generación de cotización%' and 
										a.fecha_realizada BETWEEN STR_TO_DATE('".$fecha_inicio." 00:00:00','%Y-%m-%d %H:%i:%s') and STR_TO_DATE('".$fecha_fin." 23:59:59','%Y-%m-%d %H:%i:%s') ".$com_sql."
									GROUP BY mes,ejecutivo;");
		if($bandera)
			return $query->result_array();
		else
			return $query->result();
	}

	function eje_cotizaciones($fecha_inicio,$fecha_fin,$com_sql = "",$bandera = FALSE){
		$query = $this->db->query("SELECT SUBSTRING(c.fecha,6,2) as mes,COUNT(*) as tot,vm.tipo_articulo,CONCAT_WS(' ',cp.nombre,cp.apat,cp.amat) as ejecutivo 
									FROM det_cotizacion dc, cotizacion c, equipo_solicitado es, v_modelos vm, cat_sucursal cs, cat_personal cp 
									WHERE dc.fk_cotizacion=c.pk_cotizacion and dc.fk_equipo_solicitado=es.pk_equipo_solicitado and 
										c.fk_cat_personal=cp.pk_cat_personal and 
										es.fk_cat_modelo=vm.pk_cat_modelo and c.tipo='DE VENTA' and c.fk_cat_sucursal=cs.pk_cat_sucursal and 
                                        c.fecha BETWEEN STR_TO_DATE('".$fecha_inicio." 00:00:00','%Y-%m-%d %H:%i:%s') and STR_TO_DATE('".$fecha_fin." 23:59:59','%Y-%m-%d %H:%i:%s') ".$com_sql."
                                    GROUP BY vm.tipo_articulo,mes,ejecutivo;");
		if($bandera)
			return $query->result_array();
		else
			return $query->result();
	}

	function eje_vta_perdidas($fecha_inicio,$fecha_fin,$com_sql = "",$bandera = FALSE){
		$query = $this->db->query("SELECT SUBSTRING(es.fecha_rechazo,6,2) as mes,COUNT(*) as tot,vm.tipo_articulo,CONCAT_WS(' ',cp.nombre,cp.apat,cp.amat) as ejecutivo 
									FROM equipo_solicitado es, v_modelos vm, u_prospecto_ciclo u, cat_personal cp 
									WHERE es.fk_cat_modelo=vm.pk_cat_modelo and es.fk_u_prospecto_ciclo=u.pk_u_prospecto_ciclo and 
										u.fk_cat_personal=cp.pk_cat_personal and 
										es.status='B' and es.fk_cat_rechazo!=0 and
                                        es.fecha_rechazo BETWEEN STR_TO_DATE('".$fecha_inicio." 00:00:00','%Y-%m-%d %H:%i:%s') and STR_TO_DATE('".$fecha_fin." 23:59:59','%Y-%m-%d %H:%i:%s') ".$com_sql."
                                    GROUP BY vm.tipo_articulo,mes,ejecutivo;");
		if($bandera)
			return $query->result_array();
		else
			return $query->result();
	}

	function ejecutivo($fk_sucursal,$com_sql_eje = ""){
		$query = $this->db->query("SELECT pk_cat_personal,CONCAT_WS(' ',nombre,apat,amat) as ejecutivo 
									FROM cat_personal 
									WHERE pk_cat_personal!=1 and status='A' ".$com_sql_eje."
									ORDER BY ejecutivo");
		return $query->result();
	}

}