<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Model_Altas extends CI_Model{

	function __construct(){
		parent::__construct();
	}

	function all(){
		$query = $this->db->query("SELECT cp.pk_cat_personal,CONCAT_WS(' ',cp.nombre,cp.apat,cp.amat) as nombre,cg.correo
										,cp.usuario,ctu.descripcion,cp.status,cp.articulo_maestro 
									FROM cat_personal cp, cat_generales cg, cat_tipo_usuario ctu 
									WHERE cp.fk_cat_generales=cg.pk_cat_generales and cp.fk_cat_tipo_usuario=ctu.pk_cat_tipo_usuario and ctu.pk_cat_tipo_usuario!=1 
									ORDER BY nombre");
		return $query->result();
	}

	function all_filtered($valor){
		$query = $this->db->query("SELECT cp.pk_cat_personal,CONCAT_WS(' ',cp.nombre,cp.apat,cp.amat) as nombre,cg.correo
										,cp.usuario,ctu.descripcion,cp.status,cp.articulo_maestro 
									FROM cat_personal cp, cat_generales cg, cat_tipo_usuario ctu 
									WHERE cp.fk_cat_generales=cg.pk_cat_generales and cp.fk_cat_tipo_usuario=ctu.pk_cat_tipo_usuario 
										and cp.nombre LIKE '%".$valor."%' and ctu.pk_cat_tipo_usuario!=1 ORDER BY nombre");
		return $query->result();
	}

	function find($pk_cat_personal){
		$query = $this->db->query("SELECT cp.pk_cat_personal,cp.nombre,cp.apat,cp.amat,cg.correo,cp.usuario,ctu.pk_cat_tipo_usuario,cp.status,
										cg.calle,cg.num_int,cg.num_ext,cg.cp,cg.colonia,cg.localidad,cg.municipio,cg.ciudad,cg.estado,cg.pais,
										cg.telefono,cg.correo,cp.empleado_de,cp.fk_cat_generales 
									FROM cat_personal cp, cat_generales cg, cat_tipo_usuario ctu 
									WHERE cp.fk_cat_generales=cg.pk_cat_generales and cp.fk_cat_tipo_usuario=ctu.pk_cat_tipo_usuario and cp.pk_cat_personal=".$pk_cat_personal);
		return $query->row();
	}

	function tipo_usuarios(){
		$query = $this->db->query("SELECT * FROM cat_tipo_usuario WHERE status='A' and pk_cat_tipo_usuario!=1");
		return $query->result();
	}

	function articulos($pk_cat_personal){
		$query = $this->db->query("SELECT articulo_maestro FROM cat_personal WHERE pk_cat_personal=".$pk_cat_personal."");
		return $query->row();
	}

	function cat_empresa(){
		$this->db->where('status','A');
		$query = $this->db->get('cat_empresa');
		return $query->result();
	}

	function cat_sucursal($pk_cat_empresa){
		$this->db->where('status','A');
		$this->db->where('fk_cat_empresa',$pk_cat_empresa);
		$query = $this->db->get('cat_sucursal');
		return $query->result();
	}

	function insert_cat_general($registro){
		$this->db->set($registro);
		$this->db->insert("cat_generales");
		$pk = $this->db->insert_id();
		return $pk;
	}

	function insert($registro){
		$this->db->set($registro);
		$this->db->insert('cat_personal');
	}

	function update($registro,$pk_campo,$tabla){
		$this->db->set($registro);
		$this->db->where($pk_campo,$registro[$pk_campo]);
		$this->db->update($tabla);
	}

	function update_status ($pk,$status){
		$registro = array("status" => $status);
		$this->db->where('pk_cat_personal',$pk);
		$this->db->update('cat_personal',$registro);
	}

	function pertenece_a($empleado_de){
		$explode = explode("_", $empleado_de);
		if($explode[0] == "e")
			$query = $this->db->query("SELECT CONCAT('Empresa:     ',razon_social) as establecimiento FROM cat_empresa WHERE pk_cat_empresa=".$explode[1]);
		else
			$query = $this->db->query("SELECT CONCAT('Sucursal:     ',nombre) as establecimiento FROM cat_sucursal WHERE pk_cat_sucursal=".$explode[1]);
		return $query->row();
	}

}