
(function($){

$.iordaz_Timer = function f(newTimeout){

    var idle    = false,
        enabled = true,
        timeout = 30000,
        events  = 'mousemove keydown DOMMouseScroll mousewheel mousedown',

    toggleIdleState = function(){
        idle = !idle;
        f.olddate = +new Date;
        $(document).trigger(  $.data(document,'iordaz_Timer', idle ? "idle" : "active" )  + '.iordaz_Timer');            
    },
      
    stop = function(){
        enabled = false;
        clearTimeout($.iordaz_Timer.tId);
        $(document).unbind('.iordaz_Timer');
    },

    handleUserEvent = function(){
        clearTimeout($.iordaz_Timer.tId);
        
        if (enabled){

            if (idle){
                toggleIdleState();           
            } 

            $.iordaz_Timer.tId = setTimeout(toggleIdleState, timeout);
        }    
     };
    
    f.olddate = f.olddate || +new Date;
    if (typeof newTimeout == "number"){
        timeout = newTimeout;
    } else if (newTimeout === 'destroy') {
        stop();
        return this;  
    } else if (newTimeout === 'getElapsedTime'){
        return (+new Date) - f.olddate;
    }

    $(document).bind($.trim((events+' ').split(' ').join('.iordaz_Timer ')),handleUserEvent);
    $.iordaz_Timer.tId = setTimeout(toggleIdleState, timeout);
    $.data(document,'iordaz_Timer',"active"); 
};

})(jQuery);
