CREATE OR REPLACE VIEW v_unidades AS
SELECT 
        `cmo`.`pk_cat_modelo` AS `pk_cat_modelo`,
        `cmo`.`descripcion` AS `descripcion`,
        `cmo`.`potencia` AS `potencia`,
        `cmo`.`rodada` AS `rodada`,
        `cmo`.`anio` AS `anio`,
        `cmo`.`precio` AS `precio`,
        `cmo`.`detalles` AS `detalles`,
        `cmo`.`status` AS `status`,
        `cta`.`pk_cat_tipo_articulo` AS `pk_cat_tipo_articulo`,
        `gc`.`pk_gpo_catalogo` AS `pk_gpo_catalogo`,
        `sgc`.`pk_subgpo_catalogo` AS `pk_subgpo_catalogo`,
        `cm`.`pk_cat_marca` AS `pk_cat_marca`
    FROM
        ((((`cat_tipo_articulo` `cta`
        JOIN `gpo_catalogo` `gc`)
        JOIN `subgpo_catalogo` `sgc`)
        JOIN `cat_marca` `cm`)
        JOIN `cat_modelo` `cmo`)
    WHERE
        ((`cmo`.`fk_cat_marca` = `cm`.`pk_cat_marca`)
            AND (`cm`.`fk_subgpo_catalogo` = `sgc`.`pk_subgpo_catalogo`)
            AND (`sgc`.`fk_gpo_catalogo` = `gc`.`pk_gpo_catalogo`)
            AND (`gc`.`fk_cat_tipo_articulo` = `cta`.`pk_cat_tipo_articulo`)
            AND `cta`.`pk_cat_tipo_articulo`)
    ORDER BY `cmo`.`pk_cat_modelo`;

CREATE OR REPLACE ViEW v_info_prospecto AS
SELECT 
        `upc`.`pk_u_prospecto_ciclo` AS `pk_u_prospecto_ciclo`,
        `p`.`pk_prospecto` AS `pk_prospecto`,
        `cg`.`pk_cat_generales` AS `pk_cat_generales`,
        `p`.`nombre` AS `nombre`,
        `p`.`razon_social` AS `razon_social`,
        `p`.`rfc` AS `rfc`,
        `p`.`contacto` AS `contacto`,
        `upc`.`observaciones` AS `obs_pros`,
        `cg`.`calle` AS `calle`,
        `cg`.`num_int` AS `num_int`,
        `cg`.`num_ext` AS `num_ext`,
        `cg`.`cp` AS `cp`,
        `cg`.`colonia` AS `colonia`,
        `cg`.`localidad` AS `localidad`,
        `cg`.`municipio` AS `municipio`,
        `cg`.`ciudad` AS `ciudad`,
        `cg`.`estado` AS `estado`,
        `cg`.`pais` AS `pais`,
        `cg`.`telefono` AS `telefono`,
        `cg`.`correo` AS `correo`,
        `cg`.`fecha` AS `fecha`,
        `ccp`.`descripcion` AS `condiciones_pago`,
        `cpc`.`descripcion` AS `probabilidad_compra`,
        `cpp`.`descripcion` AS `plazo_pago`,
        `ca`.`descripcion` AS `actividad`,
        `cta`.`descripcion` AS `tipo_actividad`,
        `upc`.`servicio` AS `servicio`,
        `upc`.`refacciones` AS `refacciones`
    FROM
        (((((((`prospecto` `p`
        JOIN `cat_generales` `cg`)
        JOIN `u_prospecto_ciclo` `upc`)
        JOIN `cat_condiciones_pago` `ccp`)
        JOIN `cat_probabilidad_compra` `cpc`)
        JOIN `cat_plazo_pago` `cpp`)
        JOIN `cat_actividad` `ca`)
        JOIN `cat_tipo_actividad` `cta`)
    WHERE
        ((`upc`.`fk_prospecto` = `p`.`pk_prospecto`)
            AND (`p`.`fk_cat_generales` = `cg`.`pk_cat_generales`)
            AND (`upc`.`fk_cat_tipo_actividad` = `cta`.`pk_cat_tipo_actividad`)
            AND (`cta`.`fk_cat_actividad` = `ca`.`pk_cat_actividad`)
            AND (`upc`.`fk_cat_probabilidad_compra` = `cpc`.`pk_cat_probabilidad_compra`)
            AND (`upc`.`fk_cat_condiciones_pago` = `ccp`.`pk_cat_condiciones_pago`)
            AND (`upc`.`fk_cat_plazo_pago` = `cpp`.`pk_cat_plazo_pago`));

CREATE OR REPLACE VIEW v_modelos AS 
SELECT 
        `cta`.`pk_cat_tipo_articulo` AS `pk_cat_tipo_articulo`,
        `cta`.`descripcion` AS `tipo_articulo`,
        `cta`.`status` AS `status_cta`,
        `gc`.`pk_gpo_catalogo` AS `pk_gpo_catalogo`,
        `gc`.`descripcion` AS `grupo`,
        `gc`.`status` AS `status_gc`,
        `sgc`.`pk_subgpo_catalogo` AS `pk_subgpo_catalogo`,
        `sgc`.`descripcion` AS `subgrupo`,
        `sgc`.`status` AS `status_sgc`,
        `cm`.`pk_cat_marca` AS `pk_cat_marca`,
        `cm`.`descripcion` AS `marca`,
        `cm`.`status` AS `status_cm`,
        `cmo`.`pk_cat_modelo` AS `pk_cat_modelo`,
        `cmo`.`descripcion` AS `modelo`,
        `cmo`.`potencia` AS `potencia`,
        `cmo`.`rodada` AS `rodada`,
        `cmo`.`anio` AS `anio`,
        `cmo`.`precio` AS `precio`,
        `cmo`.`detalles` AS `detalles`,
        `cmo`.`status` AS `status_cmo`
    FROM
        ((((`cat_tipo_articulo` `cta`
        JOIN `gpo_catalogo` `gc`)
        JOIN `subgpo_catalogo` `sgc`)
        JOIN `cat_marca` `cm`)
        JOIN `cat_modelo` `cmo`)
    WHERE
        ((`cmo`.`fk_cat_marca` = `cm`.`pk_cat_marca`)
            AND (`cm`.`fk_subgpo_catalogo` = `sgc`.`pk_subgpo_catalogo`)
            AND (`sgc`.`fk_gpo_catalogo` = `gc`.`pk_gpo_catalogo`)
            AND (`gc`.`fk_cat_tipo_articulo` = `cta`.`pk_cat_tipo_articulo`));

CREATE OR REPLACE VIEW v_actividades AS
SELECT 
        `a`.`fk_u_prospecto_ciclo` AS `fk_u_prospecto_ciclo`,
        `css`.`descripcion` AS `status`,
        `cass`.`descripcion` AS `actividad`,
        `p`.`nombre` AS `nombre`,
        `p`.`razon_social` AS `razon_social`,
        `a`.`realizada` AS `realizada`,
        `a`.`fk_cat_personal` AS `fk_cat_personal`,
        `a`.`fecha_actividad` AS `fecha_actividad`,
        `a`.`fk_cat_status_seguimiento` AS `fk_cat_status_seguimiento`,
        `a`.`fk_cat_actividad_status_seguimiento` AS `fk_cat_actividad_status_seguimiento`
    FROM
        ((((`agenda` `a`
        JOIN `cat_status_seguimiento` `css`)
        JOIN `cat_actividad_status_seguimiento` `cass`)
        JOIN `prospecto` `p`)
        JOIN `u_prospecto_ciclo` `upc`)
    WHERE
        ((`a`.`fk_cat_actividad_status_seguimiento` = `cass`.`pk_cat_actividad_status_seguimiento`)
            AND (`a`.`fk_cat_status_seguimiento` = `css`.`pk_cat_status_seguimiento`)
            AND (`a`.`fk_u_prospecto_ciclo` = `upc`.`pk_u_prospecto_ciclo`)
            AND (`upc`.`fk_prospecto` = `p`.`pk_prospecto`))
    ORDER BY `css`.`descripcion` , `cass`.`descripcion` , `p`.`nombre`;

CREATE OR REPLACE VIEW v_metas_personal AS
SELECT DISTINCT
        `u`.`pk_union_personal_metas` AS `pk_union_personal_metas`,
        `u`.`cumplido` AS `cumplido`,
        `u`.`mes` AS `mes`,
        `u`.`anio` AS `anio`,
        `u`.`cantidad` AS `cantidad`,
        IF((`u`.`fk_cat_personal` = 0),
            `cs`.`nombre`,
            CONCAT_WS(' ',
                    `cp`.`nombre`,
                    `cp`.`apat`,
                    `cp`.`amat`)) AS `personal`,
        CONCAT_WS(' - ',
                CONVERT( IF((`m`.`tipo` = 'I'),
                    'Individual',
                    'Grupal') USING LATIN1),
                `css`.`descripcion`,
                `cta`.`descripcion`) AS `meta`,
        `u`.`status` AS `status`,
        u.meta_por
    FROM
        (((((`union_personal_metas` `u`
        JOIN `cat_personal` `cp`)
        JOIN `cat_metas` `m`)
        JOIN `cat_status_seguimiento` `css`)
        JOIN `cat_tipo_articulo` `cta`)
        JOIN `cat_sucursal` `cs`)
    WHERE
        (IF((`u`.`fk_cat_personal` = 0),
            (`u`.`fk_cat_sucursal` = `cs`.`pk_cat_sucursal`),
            (`u`.`fk_cat_personal` = `cp`.`pk_cat_personal`))
            AND (`u`.`fk_cat_metas` = `m`.`pk_cat_metas`)
            AND (`m`.`fk_cat_status_seguimiento` = `css`.`pk_cat_status_seguimiento`)
            AND (`m`.`fk_cat_tipo_articulo` = `cta`.`pk_cat_tipo_articulo`));
-- ORDER BY personal;

SELECT * FROM v_modelos;